/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.BooleanFlagDefaults;
import com.launchdarkly.api.model.DefaultClientSideAvailability;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class UpsertFlagDefaultsPayload {
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_TEMPORARY = "temporary";
    @SerializedName(value="temporary")
    private Boolean temporary;
    public static final String SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY = "defaultClientSideAvailability";
    @SerializedName(value="defaultClientSideAvailability")
    private DefaultClientSideAvailability defaultClientSideAvailability;
    public static final String SERIALIZED_NAME_BOOLEAN_DEFAULTS = "booleanDefaults";
    @SerializedName(value="booleanDefaults")
    private BooleanFlagDefaults booleanDefaults;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UpsertFlagDefaultsPayload tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UpsertFlagDefaultsPayload addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"tag-1\",\"tag-2\"]", required=true, value="A list of default tags for each flag")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UpsertFlagDefaultsPayload temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether the flag should be temporary by default")
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public UpsertFlagDefaultsPayload defaultClientSideAvailability(DefaultClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DefaultClientSideAvailability getDefaultClientSideAvailability() {
        return this.defaultClientSideAvailability;
    }

    public void setDefaultClientSideAvailability(DefaultClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
    }

    public UpsertFlagDefaultsPayload booleanDefaults(BooleanFlagDefaults booleanDefaults) {
        this.booleanDefaults = booleanDefaults;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public BooleanFlagDefaults getBooleanDefaults() {
        return this.booleanDefaults;
    }

    public void setBooleanDefaults(BooleanFlagDefaults booleanDefaults) {
        this.booleanDefaults = booleanDefaults;
    }

    public UpsertFlagDefaultsPayload putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpsertFlagDefaultsPayload upsertFlagDefaultsPayload = (UpsertFlagDefaultsPayload)o;
        return Objects.equals(this.tags, upsertFlagDefaultsPayload.tags) && Objects.equals(this.temporary, upsertFlagDefaultsPayload.temporary) && Objects.equals(this.defaultClientSideAvailability, upsertFlagDefaultsPayload.defaultClientSideAvailability) && Objects.equals(this.booleanDefaults, upsertFlagDefaultsPayload.booleanDefaults) && Objects.equals(this.additionalProperties, upsertFlagDefaultsPayload.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.temporary, this.defaultClientSideAvailability, this.booleanDefaults, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpsertFlagDefaultsPayload {\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    defaultClientSideAvailability: ").append(this.toIndentedString(this.defaultClientSideAvailability)).append("\n");
        sb.append("    booleanDefaults: ").append(this.toIndentedString(this.booleanDefaults)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpsertFlagDefaultsPayload is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY) != null) {
            DefaultClientSideAvailability.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BOOLEAN_DEFAULTS) != null) {
            BooleanFlagDefaults.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BOOLEAN_DEFAULTS));
        }
    }

    public static UpsertFlagDefaultsPayload fromJson(String jsonString) throws IOException {
        return (UpsertFlagDefaultsPayload)JSON.getGson().fromJson(jsonString, UpsertFlagDefaultsPayload.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_BOOLEAN_DEFAULTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY);
        openapiRequiredFields.add(SERIALIZED_NAME_BOOLEAN_DEFAULTS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UpsertFlagDefaultsPayload.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpsertFlagDefaultsPayload.class));
            return new TypeAdapter<UpsertFlagDefaultsPayload>(){

                public void write(JsonWriter out, UpsertFlagDefaultsPayload value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public UpsertFlagDefaultsPayload read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpsertFlagDefaultsPayload.validateJsonObject(jsonObj);
                    UpsertFlagDefaultsPayload instance = (UpsertFlagDefaultsPayload)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

