/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class User {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_SECONDARY = "secondary";
    @SerializedName(value="secondary")
    private String secondary;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";
    @SerializedName(value="firstName")
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "lastName";
    @SerializedName(value="lastName")
    private String lastName;
    public static final String SERIALIZED_NAME_AVATAR = "avatar";
    @SerializedName(value="avatar")
    private String avatar;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ANONYMOUS = "anonymous";
    @SerializedName(value="anonymous")
    private Boolean anonymous;
    public static final String SERIALIZED_NAME_CUSTOM = "custom";
    @SerializedName(value="custom")
    private Map<String, Object> custom = null;
    public static final String SERIALIZED_NAME_PRIVATE_ATTRS = "privateAttrs";
    @SerializedName(value="privateAttrs")
    private List<String> privateAttrs = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public User key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user-key-123abc", value="The user key. This is the only mandatory user attribute.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public User secondary(String secondary) {
        this.secondary = secondary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2398127", value="If provided, used with the user key to generate a variation in percentage rollouts")
    public String getSecondary() {
        return this.secondary;
    }

    public void setSecondary(String secondary) {
        this.secondary = secondary;
    }

    public User ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10.10.10.10", value="The user's IP address")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public User country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United States", value="The user's country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sandy@example.com", value="The user's email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sandy", value="The user's first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Smith", value="The user's last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public User avatar(String avatar) {
        this.avatar = avatar;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="http://example.com/avatar.png", value="An absolute URL to an avatar image.")
    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sandy Smith", value="The user's full name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User anonymous(Boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the user is anonymous. If true, this user does not appear on the Contexts list in the LaunchDarkly user interface.")
    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public User custom(Map<String, Object> custom) {
        this.custom = custom;
        return this;
    }

    public User putCustomItem(String key, Object customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, Object>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Any other custom attributes for this user. Custom attributes contain any other user data that you would like to use to conditionally target your users.")
    public Map<String, Object> getCustom() {
        return this.custom;
    }

    public void setCustom(Map<String, Object> custom) {
        this.custom = custom;
    }

    public User privateAttrs(List<String> privateAttrs) {
        this.privateAttrs = privateAttrs;
        return this;
    }

    public User addPrivateAttrsItem(String privateAttrsItem) {
        if (this.privateAttrs == null) {
            this.privateAttrs = new ArrayList<String>();
        }
        this.privateAttrs.add(privateAttrsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of attribute names that are marked as private. You can use these attributes in targeting rules and segments. If you are using a server-side SDK, the SDK will not send the private attribute back to LaunchDarkly. If you are using a client-side SDK, the SDK will send the private attribute back to LaunchDarkly for evaluation. However, the SDK won't send the attribute to LaunchDarkly in events data, LaunchDarkly won't store the private attribute, and the private attribute will not appear on the Contexts list.")
    public List<String> getPrivateAttrs() {
        return this.privateAttrs;
    }

    public void setPrivateAttrs(List<String> privateAttrs) {
        this.privateAttrs = privateAttrs;
    }

    public User putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.key, user.key) && Objects.equals(this.secondary, user.secondary) && Objects.equals(this.ip, user.ip) && Objects.equals(this.country, user.country) && Objects.equals(this.email, user.email) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.avatar, user.avatar) && Objects.equals(this.name, user.name) && Objects.equals(this.anonymous, user.anonymous) && Objects.equals(this.custom, user.custom) && Objects.equals(this.privateAttrs, user.privateAttrs) && Objects.equals(this.additionalProperties, user.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.secondary, this.ip, this.country, this.email, this.firstName, this.lastName, this.avatar, this.name, this.anonymous, this.custom, this.privateAttrs, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    secondary: ").append(this.toIndentedString(this.secondary)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    avatar: ").append(this.toIndentedString(this.avatar)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    anonymous: ").append(this.toIndentedString(this.anonymous)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    privateAttrs: ").append(this.toIndentedString(this.privateAttrs)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in User is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECONDARY) != null && !jsonObj.get(SERIALIZED_NAME_SECONDARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secondary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP) != null && !jsonObj.get(SERIALIZED_NAME_IP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ip` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `firstName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `lastName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AVATAR) != null && !jsonObj.get(SERIALIZED_NAME_AVATAR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `avatar` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AVATAR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIVATE_ATTRS) != null && !jsonObj.get(SERIALIZED_NAME_PRIVATE_ATTRS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `privateAttrs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIVATE_ATTRS).toString()));
        }
    }

    public static User fromJson(String jsonString) throws IOException {
        return (User)JSON.getGson().fromJson(jsonString, User.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_SECONDARY);
        openapiFields.add(SERIALIZED_NAME_IP);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_FIRST_NAME);
        openapiFields.add(SERIALIZED_NAME_LAST_NAME);
        openapiFields.add(SERIALIZED_NAME_AVATAR);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ANONYMOUS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM);
        openapiFields.add(SERIALIZED_NAME_PRIVATE_ATTRS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!User.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(User.class));
            return new TypeAdapter<User>(){

                public void write(JsonWriter out, User value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public User read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    User.validateJsonObject(jsonObj);
                    User instance = (User)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

