/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class UserRecordRep {
    public static final String SERIALIZED_NAME_LAST_PING = "lastPing";
    @SerializedName(value="lastPing")
    private OffsetDateTime lastPing;
    public static final String SERIALIZED_NAME_ENVIRONMENT_ID = "environmentId";
    @SerializedName(value="environmentId")
    private String environmentId;
    public static final String SERIALIZED_NAME_OWNER_ID = "ownerId";
    @SerializedName(value="ownerId")
    private String ownerId;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private User user;
    public static final String SERIALIZED_NAME_SORT_VALUE = "sortValue";
    @SerializedName(value="sortValue")
    private Object sortValue = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UserRecordRep lastPing(OffsetDateTime lastPing) {
        this.lastPing = lastPing;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-06-28T23:21:29.176609596Z", value="Timestamp of the last time this user was seen")
    public OffsetDateTime getLastPing() {
        return this.lastPing;
    }

    public void setLastPing(OffsetDateTime lastPing) {
        this.lastPing = lastPing;
    }

    public UserRecordRep environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public UserRecordRep ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public UserRecordRep user(User user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public UserRecordRep sortValue(Object sortValue) {
        this.sortValue = sortValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user-key-123abc", value="If this record is returned as part of a list, the value used to sort the list. This is only included when the <code>sort</code> query parameter is specified. It is a time, in Unix milliseconds, if the sort is by <code>lastSeen</code>. It is a user key if the sort is by <code>userKey</code>.")
    public Object getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(Object sortValue) {
        this.sortValue = sortValue;
    }

    public UserRecordRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRecordRep userRecordRep = (UserRecordRep)o;
        return Objects.equals(this.lastPing, userRecordRep.lastPing) && Objects.equals(this.environmentId, userRecordRep.environmentId) && Objects.equals(this.ownerId, userRecordRep.ownerId) && Objects.equals(this.user, userRecordRep.user) && Objects.equals(this.sortValue, userRecordRep.sortValue) && Objects.equals(this.additionalProperties, userRecordRep.additionalProperties);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.lastPing, this.environmentId, this.ownerId, this.user, this.sortValue, this.additionalProperties);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRecordRep {\n");
        sb.append("    lastPing: ").append(this.toIndentedString(this.lastPing)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    sortValue: ").append(this.toIndentedString(this.sortValue)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UserRecordRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `environmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OWNER_ID) != null && !jsonObj.get(SERIALIZED_NAME_OWNER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ownerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OWNER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_USER) != null) {
            User.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_USER));
        }
    }

    public static UserRecordRep fromJson(String jsonString) throws IOException {
        return (UserRecordRep)JSON.getGson().fromJson(jsonString, UserRecordRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAST_PING);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_ID);
        openapiFields.add(SERIALIZED_NAME_OWNER_ID);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_SORT_VALUE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!UserRecordRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UserRecordRep.class));
            return new TypeAdapter<UserRecordRep>(){

                public void write(JsonWriter out, UserRecordRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public UserRecordRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UserRecordRep.validateJsonObject(jsonObj);
                    UserRecordRep instance = (UserRecordRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

