/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.ApplicationCollectionRep;
import com.launchdarkly.api.model.ApplicationRep;
import com.launchdarkly.api.model.ApplicationVersionRep;
import com.launchdarkly.api.model.ApplicationVersionsCollectionRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ApplicationsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ApplicationsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteApplicationCall(String applicationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/applications/{applicationKey}".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteApplicationValidateBeforeCall(String applicationKey, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling deleteApplication(Async)");
        }
        Call localVarCall = this.deleteApplicationCall(applicationKey, _callback);
        return localVarCall;
    }

    public void deleteApplication(String applicationKey) throws ApiException {
        this.deleteApplicationWithHttpInfo(applicationKey);
    }

    public ApiResponse<Void> deleteApplicationWithHttpInfo(String applicationKey) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(applicationKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteApplicationAsync(String applicationKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteApplicationValidateBeforeCall(applicationKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteApplicationVersionCall(String applicationKey, String versionKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/applications/{applicationKey}/versions/{versionKey}".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString())).replaceAll("\\{versionKey\\}", this.localVarApiClient.escapeString(versionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteApplicationVersionValidateBeforeCall(String applicationKey, String versionKey, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling deleteApplicationVersion(Async)");
        }
        if (versionKey == null) {
            throw new ApiException("Missing the required parameter 'versionKey' when calling deleteApplicationVersion(Async)");
        }
        Call localVarCall = this.deleteApplicationVersionCall(applicationKey, versionKey, _callback);
        return localVarCall;
    }

    public void deleteApplicationVersion(String applicationKey, String versionKey) throws ApiException {
        this.deleteApplicationVersionWithHttpInfo(applicationKey, versionKey);
    }

    public ApiResponse<Void> deleteApplicationVersionWithHttpInfo(String applicationKey, String versionKey) throws ApiException {
        Call localVarCall = this.deleteApplicationVersionValidateBeforeCall(applicationKey, versionKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteApplicationVersionAsync(String applicationKey, String versionKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteApplicationVersionValidateBeforeCall(applicationKey, versionKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getApplicationCall(String applicationKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/applications/{applicationKey}".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationValidateBeforeCall(String applicationKey, String expand, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling getApplication(Async)");
        }
        Call localVarCall = this.getApplicationCall(applicationKey, expand, _callback);
        return localVarCall;
    }

    public ApplicationRep getApplication(String applicationKey, String expand) throws ApiException {
        ApiResponse<ApplicationRep> localVarResp = this.getApplicationWithHttpInfo(applicationKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationRep> getApplicationWithHttpInfo(String applicationKey, String expand) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(applicationKey, expand, null);
        Type localVarReturnType = new TypeToken<ApplicationRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationAsync(String applicationKey, String expand, ApiCallback<ApplicationRep> _callback) throws ApiException {
        Call localVarCall = this.getApplicationValidateBeforeCall(applicationKey, expand, _callback);
        Type localVarReturnType = new TypeToken<ApplicationRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getApplicationVersionsCall(String applicationKey, String filter, Long limit, Long offset, String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/applications/{applicationKey}/versions".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationVersionsValidateBeforeCall(String applicationKey, String filter, Long limit, Long offset, String sort, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling getApplicationVersions(Async)");
        }
        Call localVarCall = this.getApplicationVersionsCall(applicationKey, filter, limit, offset, sort, _callback);
        return localVarCall;
    }

    public ApplicationVersionsCollectionRep getApplicationVersions(String applicationKey, String filter, Long limit, Long offset, String sort) throws ApiException {
        ApiResponse<ApplicationVersionsCollectionRep> localVarResp = this.getApplicationVersionsWithHttpInfo(applicationKey, filter, limit, offset, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationVersionsCollectionRep> getApplicationVersionsWithHttpInfo(String applicationKey, String filter, Long limit, Long offset, String sort) throws ApiException {
        Call localVarCall = this.getApplicationVersionsValidateBeforeCall(applicationKey, filter, limit, offset, sort, null);
        Type localVarReturnType = new TypeToken<ApplicationVersionsCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationVersionsAsync(String applicationKey, String filter, Long limit, Long offset, String sort, ApiCallback<ApplicationVersionsCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getApplicationVersionsValidateBeforeCall(applicationKey, filter, limit, offset, sort, _callback);
        Type localVarReturnType = new TypeToken<ApplicationVersionsCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getApplicationsCall(String filter, Long limit, Long offset, String sort, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/applications";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApplicationsValidateBeforeCall(String filter, Long limit, Long offset, String sort, String expand, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getApplicationsCall(filter, limit, offset, sort, expand, _callback);
        return localVarCall;
    }

    public ApplicationCollectionRep getApplications(String filter, Long limit, Long offset, String sort, String expand) throws ApiException {
        ApiResponse<ApplicationCollectionRep> localVarResp = this.getApplicationsWithHttpInfo(filter, limit, offset, sort, expand);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationCollectionRep> getApplicationsWithHttpInfo(String filter, Long limit, Long offset, String sort, String expand) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(filter, limit, offset, sort, expand, null);
        Type localVarReturnType = new TypeToken<ApplicationCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApplicationsAsync(String filter, Long limit, Long offset, String sort, String expand, ApiCallback<ApplicationCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getApplicationsValidateBeforeCall(filter, limit, offset, sort, expand, _callback);
        Type localVarReturnType = new TypeToken<ApplicationCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchApplicationCall(String applicationKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/applications/{applicationKey}".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchApplicationValidateBeforeCall(String applicationKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling patchApplication(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchApplication(Async)");
        }
        Call localVarCall = this.patchApplicationCall(applicationKey, patchOperation, _callback);
        return localVarCall;
    }

    public ApplicationRep patchApplication(String applicationKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<ApplicationRep> localVarResp = this.patchApplicationWithHttpInfo(applicationKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationRep> patchApplicationWithHttpInfo(String applicationKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchApplicationValidateBeforeCall(applicationKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<ApplicationRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchApplicationAsync(String applicationKey, List<PatchOperation> patchOperation, ApiCallback<ApplicationRep> _callback) throws ApiException {
        Call localVarCall = this.patchApplicationValidateBeforeCall(applicationKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<ApplicationRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchApplicationVersionCall(String applicationKey, String versionKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/applications/{applicationKey}/versions/{versionKey}".replaceAll("\\{applicationKey\\}", this.localVarApiClient.escapeString(applicationKey.toString())).replaceAll("\\{versionKey\\}", this.localVarApiClient.escapeString(versionKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchApplicationVersionValidateBeforeCall(String applicationKey, String versionKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (applicationKey == null) {
            throw new ApiException("Missing the required parameter 'applicationKey' when calling patchApplicationVersion(Async)");
        }
        if (versionKey == null) {
            throw new ApiException("Missing the required parameter 'versionKey' when calling patchApplicationVersion(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchApplicationVersion(Async)");
        }
        Call localVarCall = this.patchApplicationVersionCall(applicationKey, versionKey, patchOperation, _callback);
        return localVarCall;
    }

    public ApplicationVersionRep patchApplicationVersion(String applicationKey, String versionKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<ApplicationVersionRep> localVarResp = this.patchApplicationVersionWithHttpInfo(applicationKey, versionKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<ApplicationVersionRep> patchApplicationVersionWithHttpInfo(String applicationKey, String versionKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchApplicationVersionValidateBeforeCall(applicationKey, versionKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<ApplicationVersionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchApplicationVersionAsync(String applicationKey, String versionKey, List<PatchOperation> patchOperation, ApiCallback<ApplicationVersionRep> _callback) throws ApiException {
        Call localVarCall = this.patchApplicationVersionValidateBeforeCall(applicationKey, versionKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<ApplicationVersionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

