/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Experiment;
import com.launchdarkly.api.model.ExperimentBayesianResultsRep;
import com.launchdarkly.api.model.ExperimentCollectionRep;
import com.launchdarkly.api.model.ExperimentPatchInput;
import com.launchdarkly.api.model.ExperimentPost;
import com.launchdarkly.api.model.ExperimentResults;
import com.launchdarkly.api.model.IterationInput;
import com.launchdarkly.api.model.IterationRep;
import com.launchdarkly.api.model.MetricGroupResultsRep;
import com.launchdarkly.api.model.RandomizationSettingsPut;
import com.launchdarkly.api.model.RandomizationSettingsRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExperimentsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createExperimentCall(String projectKey, String environmentKey, ExperimentPost experimentPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExperimentPost localVarPostBody = experimentPost;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExperimentValidateBeforeCall(String projectKey, String environmentKey, ExperimentPost experimentPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createExperiment(Async)");
        }
        if (experimentPost == null) {
            throw new ApiException("Missing the required parameter 'experimentPost' when calling createExperiment(Async)");
        }
        Call localVarCall = this.createExperimentCall(projectKey, environmentKey, experimentPost, _callback);
        return localVarCall;
    }

    public Experiment createExperiment(String projectKey, String environmentKey, ExperimentPost experimentPost) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.createExperimentWithHttpInfo(projectKey, environmentKey, experimentPost);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> createExperimentWithHttpInfo(String projectKey, String environmentKey, ExperimentPost experimentPost) throws ApiException {
        Call localVarCall = this.createExperimentValidateBeforeCall(projectKey, environmentKey, experimentPost, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExperimentAsync(String projectKey, String environmentKey, ExperimentPost experimentPost, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.createExperimentValidateBeforeCall(projectKey, environmentKey, experimentPost, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIterationCall(String projectKey, String environmentKey, String experimentKey, IterationInput iterationInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IterationInput localVarPostBody = iterationInput;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}/iterations".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{experimentKey\\}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIterationValidateBeforeCall(String projectKey, String environmentKey, String experimentKey, IterationInput iterationInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createIteration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createIteration(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling createIteration(Async)");
        }
        if (iterationInput == null) {
            throw new ApiException("Missing the required parameter 'iterationInput' when calling createIteration(Async)");
        }
        Call localVarCall = this.createIterationCall(projectKey, environmentKey, experimentKey, iterationInput, _callback);
        return localVarCall;
    }

    public IterationRep createIteration(String projectKey, String environmentKey, String experimentKey, IterationInput iterationInput) throws ApiException {
        ApiResponse<IterationRep> localVarResp = this.createIterationWithHttpInfo(projectKey, environmentKey, experimentKey, iterationInput);
        return localVarResp.getData();
    }

    public ApiResponse<IterationRep> createIterationWithHttpInfo(String projectKey, String environmentKey, String experimentKey, IterationInput iterationInput) throws ApiException {
        Call localVarCall = this.createIterationValidateBeforeCall(projectKey, environmentKey, experimentKey, iterationInput, null);
        Type localVarReturnType = new TypeToken<IterationRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIterationAsync(String projectKey, String environmentKey, String experimentKey, IterationInput iterationInput, ApiCallback<IterationRep> _callback) throws ApiException {
        Call localVarCall = this.createIterationValidateBeforeCall(projectKey, environmentKey, experimentKey, iterationInput, _callback);
        Type localVarReturnType = new TypeToken<IterationRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentCall(String projectKey, String environmentKey, String experimentKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{experimentKey\\}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentValidateBeforeCall(String projectKey, String environmentKey, String experimentKey, String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperiment(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling getExperiment(Async)");
        }
        Call localVarCall = this.getExperimentCall(projectKey, environmentKey, experimentKey, expand, _callback);
        return localVarCall;
    }

    public Experiment getExperiment(String projectKey, String environmentKey, String experimentKey, String expand) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.getExperimentWithHttpInfo(projectKey, environmentKey, experimentKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> getExperimentWithHttpInfo(String projectKey, String environmentKey, String experimentKey, String expand) throws ApiException {
        Call localVarCall = this.getExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, expand, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentAsync(String projectKey, String environmentKey, String experimentKey, String expand, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.getExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, expand, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentResultsCall(String projectKey, String environmentKey, String experimentKey, String metricKey, String iterationId, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}/metrics/{metricKey}/results".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{experimentKey\\}", this.localVarApiClient.escapeString(experimentKey.toString())).replaceAll("\\{metricKey\\}", this.localVarApiClient.escapeString(metricKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (iterationId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("iterationId", iterationId));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentResultsValidateBeforeCall(String projectKey, String environmentKey, String experimentKey, String metricKey, String iterationId, String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperimentResults(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperimentResults(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling getExperimentResults(Async)");
        }
        if (metricKey == null) {
            throw new ApiException("Missing the required parameter 'metricKey' when calling getExperimentResults(Async)");
        }
        Call localVarCall = this.getExperimentResultsCall(projectKey, environmentKey, experimentKey, metricKey, iterationId, expand, _callback);
        return localVarCall;
    }

    public ExperimentBayesianResultsRep getExperimentResults(String projectKey, String environmentKey, String experimentKey, String metricKey, String iterationId, String expand) throws ApiException {
        ApiResponse<ExperimentBayesianResultsRep> localVarResp = this.getExperimentResultsWithHttpInfo(projectKey, environmentKey, experimentKey, metricKey, iterationId, expand);
        return localVarResp.getData();
    }

    public ApiResponse<ExperimentBayesianResultsRep> getExperimentResultsWithHttpInfo(String projectKey, String environmentKey, String experimentKey, String metricKey, String iterationId, String expand) throws ApiException {
        Call localVarCall = this.getExperimentResultsValidateBeforeCall(projectKey, environmentKey, experimentKey, metricKey, iterationId, expand, null);
        Type localVarReturnType = new TypeToken<ExperimentBayesianResultsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentResultsAsync(String projectKey, String environmentKey, String experimentKey, String metricKey, String iterationId, String expand, ApiCallback<ExperimentBayesianResultsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentResultsValidateBeforeCall(projectKey, environmentKey, experimentKey, metricKey, iterationId, expand, _callback);
        Type localVarReturnType = new TypeToken<ExperimentBayesianResultsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentResultsForMetricGroupCall(String projectKey, String environmentKey, String experimentKey, String metricGroupKey, String iterationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}/metric-groups/{metricGroupKey}/results".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{experimentKey\\}", this.localVarApiClient.escapeString(experimentKey.toString())).replaceAll("\\{metricGroupKey\\}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (iterationId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("iterationId", iterationId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentResultsForMetricGroupValidateBeforeCall(String projectKey, String environmentKey, String experimentKey, String metricGroupKey, String iterationId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperimentResultsForMetricGroup(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperimentResultsForMetricGroup(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling getExperimentResultsForMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling getExperimentResultsForMetricGroup(Async)");
        }
        Call localVarCall = this.getExperimentResultsForMetricGroupCall(projectKey, environmentKey, experimentKey, metricGroupKey, iterationId, _callback);
        return localVarCall;
    }

    public MetricGroupResultsRep getExperimentResultsForMetricGroup(String projectKey, String environmentKey, String experimentKey, String metricGroupKey, String iterationId) throws ApiException {
        ApiResponse<MetricGroupResultsRep> localVarResp = this.getExperimentResultsForMetricGroupWithHttpInfo(projectKey, environmentKey, experimentKey, metricGroupKey, iterationId);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupResultsRep> getExperimentResultsForMetricGroupWithHttpInfo(String projectKey, String environmentKey, String experimentKey, String metricGroupKey, String iterationId) throws ApiException {
        Call localVarCall = this.getExperimentResultsForMetricGroupValidateBeforeCall(projectKey, environmentKey, experimentKey, metricGroupKey, iterationId, null);
        Type localVarReturnType = new TypeToken<MetricGroupResultsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentResultsForMetricGroupAsync(String projectKey, String environmentKey, String experimentKey, String metricGroupKey, String iterationId, ApiCallback<MetricGroupResultsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentResultsForMetricGroupValidateBeforeCall(projectKey, environmentKey, experimentKey, metricGroupKey, iterationId, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupResultsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentationSettingsCall(String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/experimentation-settings".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentationSettingsValidateBeforeCall(String projectKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperimentationSettings(Async)");
        }
        Call localVarCall = this.getExperimentationSettingsCall(projectKey, _callback);
        return localVarCall;
    }

    public RandomizationSettingsRep getExperimentationSettings(String projectKey) throws ApiException {
        ApiResponse<RandomizationSettingsRep> localVarResp = this.getExperimentationSettingsWithHttpInfo(projectKey);
        return localVarResp.getData();
    }

    public ApiResponse<RandomizationSettingsRep> getExperimentationSettingsWithHttpInfo(String projectKey) throws ApiException {
        Call localVarCall = this.getExperimentationSettingsValidateBeforeCall(projectKey, null);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentationSettingsAsync(String projectKey, ApiCallback<RandomizationSettingsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentationSettingsValidateBeforeCall(projectKey, _callback);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentsCall(String projectKey, String environmentKey, Long limit, Long offset, String filter, String expand, String lifecycleState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (lifecycleState != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lifecycleState", lifecycleState));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentsValidateBeforeCall(String projectKey, String environmentKey, Long limit, Long offset, String filter, String expand, String lifecycleState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperiments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperiments(Async)");
        }
        Call localVarCall = this.getExperimentsCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, _callback);
        return localVarCall;
    }

    public ExperimentCollectionRep getExperiments(String projectKey, String environmentKey, Long limit, Long offset, String filter, String expand, String lifecycleState) throws ApiException {
        ApiResponse<ExperimentCollectionRep> localVarResp = this.getExperimentsWithHttpInfo(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState);
        return localVarResp.getData();
    }

    public ApiResponse<ExperimentCollectionRep> getExperimentsWithHttpInfo(String projectKey, String environmentKey, Long limit, Long offset, String filter, String expand, String lifecycleState) throws ApiException {
        Call localVarCall = this.getExperimentsValidateBeforeCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, null);
        Type localVarReturnType = new TypeToken<ExperimentCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentsAsync(String projectKey, String environmentKey, Long limit, Long offset, String filter, String expand, String lifecycleState, ApiCallback<ExperimentCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentsValidateBeforeCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, _callback);
        Type localVarReturnType = new TypeToken<ExperimentCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call getLegacyExperimentResultsCall(String projectKey, String featureFlagKey, String environmentKey, String metricKey, Long from, Long to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/experiments/{environmentKey}/{metricKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{metricKey\\}", this.localVarApiClient.escapeString(metricKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getLegacyExperimentResultsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String metricKey, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getLegacyExperimentResults(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getLegacyExperimentResults(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getLegacyExperimentResults(Async)");
        }
        if (metricKey == null) {
            throw new ApiException("Missing the required parameter 'metricKey' when calling getLegacyExperimentResults(Async)");
        }
        Call localVarCall = this.getLegacyExperimentResultsCall(projectKey, featureFlagKey, environmentKey, metricKey, from, to, _callback);
        return localVarCall;
    }

    @Deprecated
    public ExperimentResults getLegacyExperimentResults(String projectKey, String featureFlagKey, String environmentKey, String metricKey, Long from, Long to) throws ApiException {
        ApiResponse<ExperimentResults> localVarResp = this.getLegacyExperimentResultsWithHttpInfo(projectKey, featureFlagKey, environmentKey, metricKey, from, to);
        return localVarResp.getData();
    }

    @Deprecated
    public ApiResponse<ExperimentResults> getLegacyExperimentResultsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String metricKey, Long from, Long to) throws ApiException {
        Call localVarCall = this.getLegacyExperimentResultsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, metricKey, from, to, null);
        Type localVarReturnType = new TypeToken<ExperimentResults>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    @Deprecated
    public Call getLegacyExperimentResultsAsync(String projectKey, String featureFlagKey, String environmentKey, String metricKey, Long from, Long to, ApiCallback<ExperimentResults> _callback) throws ApiException {
        Call localVarCall = this.getLegacyExperimentResultsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, metricKey, from, to, _callback);
        Type localVarReturnType = new TypeToken<ExperimentResults>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExperimentCall(String projectKey, String environmentKey, String experimentKey, ExperimentPatchInput experimentPatchInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExperimentPatchInput localVarPostBody = experimentPatchInput;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{experimentKey\\}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExperimentValidateBeforeCall(String projectKey, String environmentKey, String experimentKey, ExperimentPatchInput experimentPatchInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExperiment(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling patchExperiment(Async)");
        }
        if (experimentPatchInput == null) {
            throw new ApiException("Missing the required parameter 'experimentPatchInput' when calling patchExperiment(Async)");
        }
        Call localVarCall = this.patchExperimentCall(projectKey, environmentKey, experimentKey, experimentPatchInput, _callback);
        return localVarCall;
    }

    public Experiment patchExperiment(String projectKey, String environmentKey, String experimentKey, ExperimentPatchInput experimentPatchInput) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.patchExperimentWithHttpInfo(projectKey, environmentKey, experimentKey, experimentPatchInput);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> patchExperimentWithHttpInfo(String projectKey, String environmentKey, String experimentKey, ExperimentPatchInput experimentPatchInput) throws ApiException {
        Call localVarCall = this.patchExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, experimentPatchInput, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExperimentAsync(String projectKey, String environmentKey, String experimentKey, ExperimentPatchInput experimentPatchInput, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.patchExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, experimentPatchInput, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putExperimentationSettingsCall(String projectKey, RandomizationSettingsPut randomizationSettingsPut, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RandomizationSettingsPut localVarPostBody = randomizationSettingsPut;
        String localVarPath = "/api/v2/projects/{projectKey}/experimentation-settings".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putExperimentationSettingsValidateBeforeCall(String projectKey, RandomizationSettingsPut randomizationSettingsPut, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putExperimentationSettings(Async)");
        }
        if (randomizationSettingsPut == null) {
            throw new ApiException("Missing the required parameter 'randomizationSettingsPut' when calling putExperimentationSettings(Async)");
        }
        Call localVarCall = this.putExperimentationSettingsCall(projectKey, randomizationSettingsPut, _callback);
        return localVarCall;
    }

    public RandomizationSettingsRep putExperimentationSettings(String projectKey, RandomizationSettingsPut randomizationSettingsPut) throws ApiException {
        ApiResponse<RandomizationSettingsRep> localVarResp = this.putExperimentationSettingsWithHttpInfo(projectKey, randomizationSettingsPut);
        return localVarResp.getData();
    }

    public ApiResponse<RandomizationSettingsRep> putExperimentationSettingsWithHttpInfo(String projectKey, RandomizationSettingsPut randomizationSettingsPut) throws ApiException {
        Call localVarCall = this.putExperimentationSettingsValidateBeforeCall(projectKey, randomizationSettingsPut, null);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putExperimentationSettingsAsync(String projectKey, RandomizationSettingsPut randomizationSettingsPut, ApiCallback<RandomizationSettingsRep> _callback) throws ApiException {
        Call localVarCall = this.putExperimentationSettingsValidateBeforeCall(projectKey, randomizationSettingsPut, _callback);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

