/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.DependentFlagsByEnvironment;
import com.launchdarkly.api.model.FlagSempatch;
import com.launchdarkly.api.model.MigrationSafetyIssueRep;
import com.launchdarkly.api.model.MultiEnvironmentDependentFlags;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class FeatureFlagsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FeatureFlagsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FeatureFlagsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getDependentFlagsCall(String projectKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/dependent-flags".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDependentFlagsValidateBeforeCall(String projectKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getDependentFlags(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getDependentFlags(Async)");
        }
        Call localVarCall = this.getDependentFlagsCall(projectKey, featureFlagKey, _callback);
        return localVarCall;
    }

    public MultiEnvironmentDependentFlags getDependentFlags(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<MultiEnvironmentDependentFlags> localVarResp = this.getDependentFlagsWithHttpInfo(projectKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<MultiEnvironmentDependentFlags> getDependentFlagsWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call localVarCall = this.getDependentFlagsValidateBeforeCall(projectKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDependentFlagsAsync(String projectKey, String featureFlagKey, ApiCallback<MultiEnvironmentDependentFlags> _callback) throws ApiException {
        Call localVarCall = this.getDependentFlagsValidateBeforeCall(projectKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDependentFlagsByEnvCall(String projectKey, String environmentKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{environmentKey}/{featureFlagKey}/dependent-flags".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDependentFlagsByEnvValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getDependentFlagsByEnv(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getDependentFlagsByEnv(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getDependentFlagsByEnv(Async)");
        }
        Call localVarCall = this.getDependentFlagsByEnvCall(projectKey, environmentKey, featureFlagKey, _callback);
        return localVarCall;
    }

    public DependentFlagsByEnvironment getDependentFlagsByEnv(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<DependentFlagsByEnvironment> localVarResp = this.getDependentFlagsByEnvWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<DependentFlagsByEnvironment> getDependentFlagsByEnvWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call localVarCall = this.getDependentFlagsByEnvValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDependentFlagsByEnvAsync(String projectKey, String environmentKey, String featureFlagKey, ApiCallback<DependentFlagsByEnvironment> _callback) throws ApiException {
        Call localVarCall = this.getDependentFlagsByEnvValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postMigrationSafetyIssuesCall(String projectKey, String flagKey, String environmentKey, FlagSempatch flagSempatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagSempatch localVarPostBody = flagSempatch;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{flagKey}/environments/{environmentKey}/migration-safety-issues".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{flagKey\\}", this.localVarApiClient.escapeString(flagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postMigrationSafetyIssuesValidateBeforeCall(String projectKey, String flagKey, String environmentKey, FlagSempatch flagSempatch, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (flagSempatch == null) {
            throw new ApiException("Missing the required parameter 'flagSempatch' when calling postMigrationSafetyIssues(Async)");
        }
        Call localVarCall = this.postMigrationSafetyIssuesCall(projectKey, flagKey, environmentKey, flagSempatch, _callback);
        return localVarCall;
    }

    public List<MigrationSafetyIssueRep> postMigrationSafetyIssues(String projectKey, String flagKey, String environmentKey, FlagSempatch flagSempatch) throws ApiException {
        ApiResponse<List<MigrationSafetyIssueRep>> localVarResp = this.postMigrationSafetyIssuesWithHttpInfo(projectKey, flagKey, environmentKey, flagSempatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<MigrationSafetyIssueRep>> postMigrationSafetyIssuesWithHttpInfo(String projectKey, String flagKey, String environmentKey, FlagSempatch flagSempatch) throws ApiException {
        Call localVarCall = this.postMigrationSafetyIssuesValidateBeforeCall(projectKey, flagKey, environmentKey, flagSempatch, null);
        Type localVarReturnType = new TypeToken<List<MigrationSafetyIssueRep>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postMigrationSafetyIssuesAsync(String projectKey, String flagKey, String environmentKey, FlagSempatch flagSempatch, ApiCallback<List<MigrationSafetyIssueRep>> _callback) throws ApiException {
        Call localVarCall = this.postMigrationSafetyIssuesValidateBeforeCall(projectKey, flagKey, environmentKey, flagSempatch, _callback);
        Type localVarReturnType = new TypeToken<List<MigrationSafetyIssueRep>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

