/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContextInstanceEvaluationReason {
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_RULE_INDEX = "ruleIndex";
    @SerializedName(value="ruleIndex")
    private Integer ruleIndex;
    public static final String SERIALIZED_NAME_RULE_I_D = "ruleID";
    @SerializedName(value="ruleID")
    private String ruleID;
    public static final String SERIALIZED_NAME_PREREQUISITE_KEY = "prerequisiteKey";
    @SerializedName(value="prerequisiteKey")
    private String prerequisiteKey;
    public static final String SERIALIZED_NAME_IN_EXPERIMENT = "inExperiment";
    @SerializedName(value="inExperiment")
    private Boolean inExperiment;
    public static final String SERIALIZED_NAME_ERROR_KIND = "errorKind";
    @SerializedName(value="errorKind")
    private String errorKind;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContextInstanceEvaluationReason kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="OFF", required=true, value="Describes the general reason that LaunchDarkly selected this variation.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public ContextInstanceEvaluationReason ruleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="The positional index of the matching rule if the kind is 'RULE_MATCH'. The index is 0-based.")
    public Integer getRuleIndex() {
        return this.ruleIndex;
    }

    public void setRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
    }

    public ContextInstanceEvaluationReason ruleID(String ruleID) {
        this.ruleID = ruleID;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234567890", value="The unique identifier of the matching rule if the kind is 'RULE_MATCH'.")
    public String getRuleID() {
        return this.ruleID;
    }

    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    public ContextInstanceEvaluationReason prerequisiteKey(String prerequisiteKey) {
        this.prerequisiteKey = prerequisiteKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="someotherflagkey", value="The key of the flag that failed if the kind is 'PREREQUISITE_FAILED'.")
    public String getPrerequisiteKey() {
        return this.prerequisiteKey;
    }

    public void setPrerequisiteKey(String prerequisiteKey) {
        this.prerequisiteKey = prerequisiteKey;
    }

    public ContextInstanceEvaluationReason inExperiment(Boolean inExperiment) {
        this.inExperiment = inExperiment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates whether the context was evaluated as part of an experiment.")
    public Boolean getInExperiment() {
        return this.inExperiment;
    }

    public void setInExperiment(Boolean inExperiment) {
        this.inExperiment = inExperiment;
    }

    public ContextInstanceEvaluationReason errorKind(String errorKind) {
        this.errorKind = errorKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="tried to use uninitialized Context", value="The specific error type if the kind is 'ERROR'.")
    public String getErrorKind() {
        return this.errorKind;
    }

    public void setErrorKind(String errorKind) {
        this.errorKind = errorKind;
    }

    public ContextInstanceEvaluationReason putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextInstanceEvaluationReason contextInstanceEvaluationReason = (ContextInstanceEvaluationReason)o;
        return Objects.equals(this.kind, contextInstanceEvaluationReason.kind) && Objects.equals(this.ruleIndex, contextInstanceEvaluationReason.ruleIndex) && Objects.equals(this.ruleID, contextInstanceEvaluationReason.ruleID) && Objects.equals(this.prerequisiteKey, contextInstanceEvaluationReason.prerequisiteKey) && Objects.equals(this.inExperiment, contextInstanceEvaluationReason.inExperiment) && Objects.equals(this.errorKind, contextInstanceEvaluationReason.errorKind) && Objects.equals(this.additionalProperties, contextInstanceEvaluationReason.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.ruleIndex, this.ruleID, this.prerequisiteKey, this.inExperiment, this.errorKind, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContextInstanceEvaluationReason {\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    ruleIndex: ").append(this.toIndentedString(this.ruleIndex)).append("\n");
        sb.append("    ruleID: ").append(this.toIndentedString(this.ruleID)).append("\n");
        sb.append("    prerequisiteKey: ").append(this.toIndentedString(this.prerequisiteKey)).append("\n");
        sb.append("    inExperiment: ").append(this.toIndentedString(this.inExperiment)).append("\n");
        sb.append("    errorKind: ").append(this.toIndentedString(this.errorKind)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContextInstanceEvaluationReason is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RULE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_RULE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ruleID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULE_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREREQUISITE_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PREREQUISITE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `prerequisiteKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREREQUISITE_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ERROR_KIND) != null && !jsonObj.get(SERIALIZED_NAME_ERROR_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `errorKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_KIND).toString()));
        }
    }

    public static ContextInstanceEvaluationReason fromJson(String jsonString) throws IOException {
        return (ContextInstanceEvaluationReason)JSON.getGson().fromJson(jsonString, ContextInstanceEvaluationReason.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_RULE_INDEX);
        openapiFields.add(SERIALIZED_NAME_RULE_I_D);
        openapiFields.add(SERIALIZED_NAME_PREREQUISITE_KEY);
        openapiFields.add(SERIALIZED_NAME_IN_EXPERIMENT);
        openapiFields.add(SERIALIZED_NAME_ERROR_KIND);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ContextInstanceEvaluationReason.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContextInstanceEvaluationReason.class));
            return new TypeAdapter<ContextInstanceEvaluationReason>(){

                public void write(JsonWriter out, ContextInstanceEvaluationReason value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ContextInstanceEvaluationReason read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContextInstanceEvaluationReason.validateJsonObject(jsonObj);
                    ContextInstanceEvaluationReason instance = (ContextInstanceEvaluationReason)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

