/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ExpiringTarget;
import com.launchdarkly.api.model.ExpiringTargetError;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpiringTargetPatchResponse {
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<ExpiringTarget> items = new ArrayList<ExpiringTarget>();
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_TOTAL_INSTRUCTIONS = "totalInstructions";
    @SerializedName(value="totalInstructions")
    private Integer totalInstructions;
    public static final String SERIALIZED_NAME_SUCCESSFUL_INSTRUCTIONS = "successfulInstructions";
    @SerializedName(value="successfulInstructions")
    private Integer successfulInstructions;
    public static final String SERIALIZED_NAME_FAILED_INSTRUCTIONS = "failedInstructions";
    @SerializedName(value="failedInstructions")
    private Integer failedInstructions;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<ExpiringTargetError> errors = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExpiringTargetPatchResponse items(List<ExpiringTarget> items) {
        this.items = items;
        return this;
    }

    public ExpiringTargetPatchResponse addItemsItem(ExpiringTarget itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of the results from each instruction")
    public List<ExpiringTarget> getItems() {
        return this.items;
    }

    public void setItems(List<ExpiringTarget> items) {
        this.items = items;
    }

    public ExpiringTargetPatchResponse links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ExpiringTargetPatchResponse putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ExpiringTargetPatchResponse totalInstructions(Integer totalInstructions) {
        this.totalInstructions = totalInstructions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getTotalInstructions() {
        return this.totalInstructions;
    }

    public void setTotalInstructions(Integer totalInstructions) {
        this.totalInstructions = totalInstructions;
    }

    public ExpiringTargetPatchResponse successfulInstructions(Integer successfulInstructions) {
        this.successfulInstructions = successfulInstructions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getSuccessfulInstructions() {
        return this.successfulInstructions;
    }

    public void setSuccessfulInstructions(Integer successfulInstructions) {
        this.successfulInstructions = successfulInstructions;
    }

    public ExpiringTargetPatchResponse failedInstructions(Integer failedInstructions) {
        this.failedInstructions = failedInstructions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getFailedInstructions() {
        return this.failedInstructions;
    }

    public void setFailedInstructions(Integer failedInstructions) {
        this.failedInstructions = failedInstructions;
    }

    public ExpiringTargetPatchResponse errors(List<ExpiringTargetError> errors) {
        this.errors = errors;
        return this;
    }

    public ExpiringTargetPatchResponse addErrorsItem(ExpiringTargetError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ExpiringTargetError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ExpiringTargetError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ExpiringTargetError> errors) {
        this.errors = errors;
    }

    public ExpiringTargetPatchResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpiringTargetPatchResponse expiringTargetPatchResponse = (ExpiringTargetPatchResponse)o;
        return Objects.equals(this.items, expiringTargetPatchResponse.items) && Objects.equals(this.links, expiringTargetPatchResponse.links) && Objects.equals(this.totalInstructions, expiringTargetPatchResponse.totalInstructions) && Objects.equals(this.successfulInstructions, expiringTargetPatchResponse.successfulInstructions) && Objects.equals(this.failedInstructions, expiringTargetPatchResponse.failedInstructions) && Objects.equals(this.errors, expiringTargetPatchResponse.errors) && Objects.equals(this.additionalProperties, expiringTargetPatchResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.links, this.totalInstructions, this.successfulInstructions, this.failedInstructions, this.errors, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpiringTargetPatchResponse {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    totalInstructions: ").append(this.toIndentedString(this.totalInstructions)).append("\n");
        sb.append("    successfulInstructions: ").append(this.toIndentedString(this.successfulInstructions)).append("\n");
        sb.append("    failedInstructions: ").append(this.toIndentedString(this.failedInstructions)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayerrors;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExpiringTargetPatchResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS);
        if (jsonArrayitems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                ExpiringTarget.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                ExpiringTargetError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static ExpiringTargetPatchResponse fromJson(String jsonString) throws IOException {
        return (ExpiringTargetPatchResponse)JSON.getGson().fromJson(jsonString, ExpiringTargetPatchResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_SUCCESSFUL_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_FAILED_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ExpiringTargetPatchResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExpiringTargetPatchResponse.class));
            return new TypeAdapter<ExpiringTargetPatchResponse>(){

                public void write(JsonWriter out, ExpiringTargetPatchResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ExpiringTargetPatchResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExpiringTargetPatchResponse.validateJsonObject(jsonObj);
                    ExpiringTargetPatchResponse instance = (ExpiringTargetPatchResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

