/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ClientSideAvailabilityPost;
import com.launchdarkly.api.model.CustomProperty;
import com.launchdarkly.api.model.Defaults;
import com.launchdarkly.api.model.MigrationSettingsPost;
import com.launchdarkly.api.model.Variation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FeatureFlagBody {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_INCLUDE_IN_SNIPPET = "includeInSnippet";
    @SerializedName(value="includeInSnippet")
    private Boolean includeInSnippet;
    public static final String SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY = "clientSideAvailability";
    @SerializedName(value="clientSideAvailability")
    private ClientSideAvailabilityPost clientSideAvailability;
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    private List<Variation> variations = null;
    public static final String SERIALIZED_NAME_TEMPORARY = "temporary";
    @SerializedName(value="temporary")
    private Boolean temporary;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_CUSTOM_PROPERTIES = "customProperties";
    @SerializedName(value="customProperties")
    private Map<String, CustomProperty> customProperties = null;
    public static final String SERIALIZED_NAME_DEFAULTS = "defaults";
    @SerializedName(value="defaults")
    private Defaults defaults;
    public static final String SERIALIZED_NAME_PURPOSE = "purpose";
    @SerializedName(value="purpose")
    private PurposeEnum purpose;
    public static final String SERIALIZED_NAME_MIGRATION_SETTINGS = "migrationSettings";
    @SerializedName(value="migrationSettings")
    private MigrationSettingsPost migrationSettings;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "maintainerId";
    @SerializedName(value="maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_MAINTAINER_TEAM_KEY = "maintainerTeamKey";
    @SerializedName(value="maintainerTeamKey")
    private String maintainerTeamKey;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FeatureFlagBody name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My flag", required=true, value="A human-friendly name for the feature flag")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeatureFlagBody key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="flag-key-123abc", required=true, value="A unique key used to reference the flag in your code")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FeatureFlagBody description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This flag controls the example widgets", value="Description of the feature flag. Defaults to an empty string.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FeatureFlagBody includeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Deprecated, use <code>clientSideAvailability</code>. Whether this flag should be made available to the client-side JavaScript SDK. Defaults to <code>false</code>.")
    public Boolean getIncludeInSnippet() {
        return this.includeInSnippet;
    }

    public void setIncludeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
    }

    public FeatureFlagBody clientSideAvailability(ClientSideAvailabilityPost clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ClientSideAvailabilityPost getClientSideAvailability() {
        return this.clientSideAvailability;
    }

    public void setClientSideAvailability(ClientSideAvailabilityPost clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
    }

    public FeatureFlagBody variations(List<Variation> variations) {
        this.variations = variations;
        return this;
    }

    public FeatureFlagBody addVariationsItem(Variation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<Variation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"value\":true},{\"value\":false}]", value="An array of possible variations for the flag. The variation values must be unique. If omitted, two boolean variations of <code>true</code> and <code>false</code> will be used.")
    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    public FeatureFlagBody temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the flag is a temporary flag. Defaults to <code>true</code>.")
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FeatureFlagBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FeatureFlagBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-tag\"]", value="Tags for the feature flag. Defaults to an empty array.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FeatureFlagBody customProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public FeatureFlagBody putCustomPropertiesItem(String key, CustomProperty customPropertiesItem) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, CustomProperty>();
        }
        this.customProperties.put(key, customPropertiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public FeatureFlagBody defaults(Defaults defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Defaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    public FeatureFlagBody purpose(PurposeEnum purpose) {
        this.purpose = purpose;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="migration", value="Purpose of the flag")
    public PurposeEnum getPurpose() {
        return this.purpose;
    }

    public void setPurpose(PurposeEnum purpose) {
        this.purpose = purpose;
    }

    public FeatureFlagBody migrationSettings(MigrationSettingsPost migrationSettings) {
        this.migrationSettings = migrationSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MigrationSettingsPost getMigrationSettings() {
        return this.migrationSettings;
    }

    public void setMigrationSettings(MigrationSettingsPost migrationSettings) {
        this.migrationSettings = migrationSettings;
    }

    public FeatureFlagBody maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910fgh12345", value="The ID of the member who maintains this feature flag")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public FeatureFlagBody maintainerTeamKey(String maintainerTeamKey) {
        this.maintainerTeamKey = maintainerTeamKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="team-1", value="The key of the team that maintains this feature flag")
    public String getMaintainerTeamKey() {
        return this.maintainerTeamKey;
    }

    public void setMaintainerTeamKey(String maintainerTeamKey) {
        this.maintainerTeamKey = maintainerTeamKey;
    }

    public FeatureFlagBody putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlagBody featureFlagBody = (FeatureFlagBody)o;
        return Objects.equals(this.name, featureFlagBody.name) && Objects.equals(this.key, featureFlagBody.key) && Objects.equals(this.description, featureFlagBody.description) && Objects.equals(this.includeInSnippet, featureFlagBody.includeInSnippet) && Objects.equals(this.clientSideAvailability, featureFlagBody.clientSideAvailability) && Objects.equals(this.variations, featureFlagBody.variations) && Objects.equals(this.temporary, featureFlagBody.temporary) && Objects.equals(this.tags, featureFlagBody.tags) && Objects.equals(this.customProperties, featureFlagBody.customProperties) && Objects.equals(this.defaults, featureFlagBody.defaults) && Objects.equals((Object)this.purpose, (Object)featureFlagBody.purpose) && Objects.equals(this.migrationSettings, featureFlagBody.migrationSettings) && Objects.equals(this.maintainerId, featureFlagBody.maintainerId) && Objects.equals(this.maintainerTeamKey, featureFlagBody.maintainerTeamKey) && Objects.equals(this.additionalProperties, featureFlagBody.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.key, this.description, this.includeInSnippet, this.clientSideAvailability, this.variations, this.temporary, this.tags, this.customProperties, this.defaults, this.purpose, this.migrationSettings, this.maintainerId, this.maintainerTeamKey, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlagBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    includeInSnippet: ").append(this.toIndentedString(this.includeInSnippet)).append("\n");
        sb.append("    clientSideAvailability: ").append(this.toIndentedString(this.clientSideAvailability)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString((Object)this.purpose)).append("\n");
        sb.append("    migrationSettings: ").append(this.toIndentedString(this.migrationSettings)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    maintainerTeamKey: ").append(this.toIndentedString(this.maintainerTeamKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvariations;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FeatureFlagBody is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY) != null) {
            ClientSideAvailabilityPost.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY));
        }
        if ((jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayvariations.size(); ++i) {
                Variation.validateJsonObject(jsonArrayvariations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULTS) != null) {
            Defaults.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURPOSE) != null && !jsonObj.get(SERIALIZED_NAME_PURPOSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `purpose` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PURPOSE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MIGRATION_SETTINGS) != null) {
            MigrationSettingsPost.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MIGRATION_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintainerTeamKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY).toString()));
        }
    }

    public static FeatureFlagBody fromJson(String jsonString) throws IOException {
        return (FeatureFlagBody)JSON.getGson().fromJson(jsonString, FeatureFlagBody.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_IN_SNIPPET);
        openapiFields.add(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_VARIATIONS);
        openapiFields.add(SERIALIZED_NAME_TEMPORARY);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_PROPERTIES);
        openapiFields.add(SERIALIZED_NAME_DEFAULTS);
        openapiFields.add(SERIALIZED_NAME_PURPOSE);
        openapiFields.add(SERIALIZED_NAME_MIGRATION_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_TEAM_KEY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FeatureFlagBody.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FeatureFlagBody.class));
            return new TypeAdapter<FeatureFlagBody>(){

                public void write(JsonWriter out, FeatureFlagBody value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FeatureFlagBody read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FeatureFlagBody.validateJsonObject(jsonObj);
                    FeatureFlagBody instance = (FeatureFlagBody)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PurposeEnum {
        MIGRATION("migration");

        private String value;

        private PurposeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PurposeEnum fromValue(String value) {
            for (PurposeEnum b : PurposeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PurposeEnum> {
            public void write(JsonWriter jsonWriter, PurposeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PurposeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PurposeEnum.fromValue(value);
            }
        }
    }
}

