/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.InsightGroupScores;
import com.launchdarkly.api.model.InsightPeriod;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InsightScores {
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private InsightPeriod period;
    public static final String SERIALIZED_NAME_LAST_PERIOD = "lastPeriod";
    @SerializedName(value="lastPeriod")
    private InsightPeriod lastPeriod;
    public static final String SERIALIZED_NAME_SCORES = "scores";
    @SerializedName(value="scores")
    private InsightGroupScores scores;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InsightScores period(InsightPeriod period) {
        this.period = period;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public InsightPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(InsightPeriod period) {
        this.period = period;
    }

    public InsightScores lastPeriod(InsightPeriod lastPeriod) {
        this.lastPeriod = lastPeriod;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public InsightPeriod getLastPeriod() {
        return this.lastPeriod;
    }

    public void setLastPeriod(InsightPeriod lastPeriod) {
        this.lastPeriod = lastPeriod;
    }

    public InsightScores scores(InsightGroupScores scores) {
        this.scores = scores;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public InsightGroupScores getScores() {
        return this.scores;
    }

    public void setScores(InsightGroupScores scores) {
        this.scores = scores;
    }

    public InsightScores links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public InsightScores putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public InsightScores putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightScores insightScores = (InsightScores)o;
        return Objects.equals(this.period, insightScores.period) && Objects.equals(this.lastPeriod, insightScores.lastPeriod) && Objects.equals(this.scores, insightScores.scores) && Objects.equals(this.links, insightScores.links) && Objects.equals(this.additionalProperties, insightScores.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.lastPeriod, this.scores, this.links, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsightScores {\n");
        sb.append("    period: ").append(this.toIndentedString(this.period)).append("\n");
        sb.append("    lastPeriod: ").append(this.toIndentedString(this.lastPeriod)).append("\n");
        sb.append("    scores: ").append(this.toIndentedString(this.scores)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InsightScores is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PERIOD) != null) {
            InsightPeriod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PERIOD));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_PERIOD) != null) {
            InsightPeriod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_PERIOD));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORES) != null) {
            InsightGroupScores.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORES));
        }
    }

    public static InsightScores fromJson(String jsonString) throws IOException {
        return (InsightScores)JSON.getGson().fromJson(jsonString, InsightScores.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PERIOD);
        openapiFields.add(SERIALIZED_NAME_LAST_PERIOD);
        openapiFields.add(SERIALIZED_NAME_SCORES);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PERIOD);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_PERIOD);
        openapiRequiredFields.add(SERIALIZED_NAME_SCORES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!InsightScores.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InsightScores.class));
            return new TypeAdapter<InsightScores>(){

                public void write(JsonWriter out, InsightScores value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public InsightScores read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InsightScores.validateJsonObject(jsonObj);
                    InsightScores instance = (InsightScores)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

