/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricInGroupRep {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_VERSION_ID = "_versionId";
    @SerializedName(value="_versionId")
    private String versionId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_IS_NUMERIC = "isNumeric";
    @SerializedName(value="isNumeric")
    private Boolean isNumeric;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_NAME_IN_GROUP = "nameInGroup";
    @SerializedName(value="nameInGroup")
    private String nameInGroup;
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNITS = "randomizationUnits";
    @SerializedName(value="randomizationUnits")
    private List<String> randomizationUnits = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MetricInGroupRep key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="metric-key-123abc", required=true, value="The metric key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MetricInGroupRep versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="version-id-123abc", value="The version ID of the metric")
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public MetricInGroupRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example metric", required=true, value="The metric name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricInGroupRep kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="custom", required=true, value="The kind of event the metric tracks")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public MetricInGroupRep isNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="For custom metrics, whether to track numeric changes in value against a baseline (<code>true</code>) or to track a conversion when an end user takes an action (<code>false</code>).")
    public Boolean getIsNumeric() {
        return this.isNumeric;
    }

    public void setIsNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public MetricInGroupRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MetricInGroupRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"self\":{\"href\":\"/api/v2/metrics/my-project/my-metric\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public MetricInGroupRep nameInGroup(String nameInGroup) {
        this.nameInGroup = nameInGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Step 1", value="Name of the metric when used within the associated metric group. Can be different from the original name of the metric. Required if and only if the metric group is a <code>funnel</code>.")
    public String getNameInGroup() {
        return this.nameInGroup;
    }

    public void setNameInGroup(String nameInGroup) {
        this.nameInGroup = nameInGroup;
    }

    public MetricInGroupRep randomizationUnits(List<String> randomizationUnits) {
        this.randomizationUnits = randomizationUnits;
        return this;
    }

    public MetricInGroupRep addRandomizationUnitsItem(String randomizationUnitsItem) {
        if (this.randomizationUnits == null) {
            this.randomizationUnits = new ArrayList<String>();
        }
        this.randomizationUnits.add(randomizationUnitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"user\"]", value="The randomization units for the metric")
    public List<String> getRandomizationUnits() {
        return this.randomizationUnits;
    }

    public void setRandomizationUnits(List<String> randomizationUnits) {
        this.randomizationUnits = randomizationUnits;
    }

    public MetricInGroupRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricInGroupRep metricInGroupRep = (MetricInGroupRep)o;
        return Objects.equals(this.key, metricInGroupRep.key) && Objects.equals(this.versionId, metricInGroupRep.versionId) && Objects.equals(this.name, metricInGroupRep.name) && Objects.equals((Object)this.kind, (Object)metricInGroupRep.kind) && Objects.equals(this.isNumeric, metricInGroupRep.isNumeric) && Objects.equals(this.links, metricInGroupRep.links) && Objects.equals(this.nameInGroup, metricInGroupRep.nameInGroup) && Objects.equals(this.randomizationUnits, metricInGroupRep.randomizationUnits) && Objects.equals(this.additionalProperties, metricInGroupRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.versionId, this.name, this.kind, this.isNumeric, this.links, this.nameInGroup, this.randomizationUnits, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricInGroupRep {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    isNumeric: ").append(this.toIndentedString(this.isNumeric)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    nameInGroup: ").append(this.toIndentedString(this.nameInGroup)).append("\n");
        sb.append("    randomizationUnits: ").append(this.toIndentedString(this.randomizationUnits)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MetricInGroupRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION_ID) != null && !jsonObj.get(SERIALIZED_NAME_VERSION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_versionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME_IN_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_NAME_IN_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nameInGroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME_IN_GROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS).toString()));
        }
    }

    public static MetricInGroupRep fromJson(String jsonString) throws IOException {
        return (MetricInGroupRep)JSON.getGson().fromJson(jsonString, MetricInGroupRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_VERSION_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_IS_NUMERIC);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_NAME_IN_GROUP);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNITS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricInGroupRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricInGroupRep.class));
            return new TypeAdapter<MetricInGroupRep>(){

                public void write(JsonWriter out, MetricInGroupRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricInGroupRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MetricInGroupRep.validateJsonObject(jsonObj);
                    MetricInGroupRep instance = (MetricInGroupRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        PAGEVIEW("pageview"),
        CLICK("click"),
        CUSTOM("custom");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

