/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.BranchRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryRep {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SOURCE_LINK = "sourceLink";
    @SerializedName(value="sourceLink")
    private String sourceLink;
    public static final String SERIALIZED_NAME_COMMIT_URL_TEMPLATE = "commitUrlTemplate";
    @SerializedName(value="commitUrlTemplate")
    private String commitUrlTemplate;
    public static final String SERIALIZED_NAME_HUNK_URL_TEMPLATE = "hunkUrlTemplate";
    @SerializedName(value="hunkUrlTemplate")
    private String hunkUrlTemplate;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_DEFAULT_BRANCH = "defaultBranch";
    @SerializedName(value="defaultBranch")
    private String defaultBranch;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_BRANCHES = "branches";
    @SerializedName(value="branches")
    private List<BranchRep> branches = null;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Object> links = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RepositoryRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="LaunchDarkly-Docs", required=true, value="The repository name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryRep sourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs", value="A URL to access the repository")
    public String getSourceLink() {
        return this.sourceLink;
    }

    public void setSourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
    }

    public RepositoryRep commitUrlTemplate(String commitUrlTemplate) {
        this.commitUrlTemplate = commitUrlTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs/commit/${sha}", value="A template for constructing a valid URL to view the commit")
    public String getCommitUrlTemplate() {
        return this.commitUrlTemplate;
    }

    public void setCommitUrlTemplate(String commitUrlTemplate) {
        this.commitUrlTemplate = commitUrlTemplate;
    }

    public RepositoryRep hunkUrlTemplate(String hunkUrlTemplate) {
        this.hunkUrlTemplate = hunkUrlTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs/blob/${sha}/${filePath}#L${lineNumber}", value="A template for constructing a valid URL to view the hunk")
    public String getHunkUrlTemplate() {
        return this.hunkUrlTemplate;
    }

    public void setHunkUrlTemplate(String hunkUrlTemplate) {
        this.hunkUrlTemplate = hunkUrlTemplate;
    }

    public RepositoryRep type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="github", required=true, value="The type of repository")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RepositoryRep defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="main", required=true, value="The repository's default branch")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public RepositoryRep enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether or not a repository is enabled for code reference scanning")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public RepositoryRep version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3", required=true, value="The version of the repository's saved information")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public RepositoryRep branches(List<BranchRep> branches) {
        this.branches = branches;
        return this;
    }

    public RepositoryRep addBranchesItem(BranchRep branchesItem) {
        if (this.branches == null) {
            this.branches = new ArrayList<BranchRep>();
        }
        this.branches.add(branchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of the repository's branches that have been scanned for code references")
    public List<BranchRep> getBranches() {
        return this.branches;
    }

    public void setBranches(List<BranchRep> branches) {
        this.branches = branches;
    }

    public RepositoryRep links(Map<String, Object> links) {
        this.links = links;
        return this;
    }

    public RepositoryRep putLinksItem(String key, Object linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Map<String, Object> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Object> links) {
        this.links = links;
    }

    public RepositoryRep access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public RepositoryRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryRep repositoryRep = (RepositoryRep)o;
        return Objects.equals(this.name, repositoryRep.name) && Objects.equals(this.sourceLink, repositoryRep.sourceLink) && Objects.equals(this.commitUrlTemplate, repositoryRep.commitUrlTemplate) && Objects.equals(this.hunkUrlTemplate, repositoryRep.hunkUrlTemplate) && Objects.equals((Object)this.type, (Object)repositoryRep.type) && Objects.equals(this.defaultBranch, repositoryRep.defaultBranch) && Objects.equals(this.enabled, repositoryRep.enabled) && Objects.equals(this.version, repositoryRep.version) && Objects.equals(this.branches, repositoryRep.branches) && Objects.equals(this.links, repositoryRep.links) && Objects.equals(this.access, repositoryRep.access) && Objects.equals(this.additionalProperties, repositoryRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceLink, this.commitUrlTemplate, this.hunkUrlTemplate, this.type, this.defaultBranch, this.enabled, this.version, this.branches, this.links, this.access, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepositoryRep {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceLink: ").append(this.toIndentedString(this.sourceLink)).append("\n");
        sb.append("    commitUrlTemplate: ").append(this.toIndentedString(this.commitUrlTemplate)).append("\n");
        sb.append("    hunkUrlTemplate: ").append(this.toIndentedString(this.hunkUrlTemplate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    branches: ").append(this.toIndentedString(this.branches)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RepositoryRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_LINK) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitUrlTemplate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hunkUrlTemplate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultBranch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).toString()));
        }
        JsonArray jsonArraybranches = jsonObj.getAsJsonArray(SERIALIZED_NAME_BRANCHES);
        if (jsonArraybranches != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BRANCHES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `branches` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRANCHES).toString()));
            }
            for (int i = 0; i < jsonArraybranches.size(); ++i) {
                BranchRep.validateJsonObject(jsonArraybranches.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
    }

    public static RepositoryRep fromJson(String jsonString) throws IOException {
        return (RepositoryRep)JSON.getGson().fromJson(jsonString, RepositoryRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SOURCE_LINK);
        openapiFields.add(SERIALIZED_NAME_COMMIT_URL_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_HUNK_URL_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_BRANCH);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_BRANCHES);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_DEFAULT_BRANCH);
        openapiRequiredFields.add(SERIALIZED_NAME_ENABLED);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RepositoryRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RepositoryRep.class));
            return new TypeAdapter<RepositoryRep>(){

                public void write(JsonWriter out, RepositoryRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RepositoryRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RepositoryRep.validateJsonObject(jsonObj);
                    RepositoryRep instance = (RepositoryRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BITBUCKET("bitbucket"),
        CUSTOM("custom"),
        GITHUB("github"),
        GITLAB("gitlab");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

