/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ActionOutput;
import com.launchdarkly.api.model.ConditionOutput;
import com.launchdarkly.api.model.ExecutionOutput;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StageOutput {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<ConditionOutput> conditions = new ArrayList<ConditionOutput>();
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private ActionOutput action;
    public static final String SERIALIZED_NAME_EXECUTION = "_execution";
    @SerializedName(value="_execution")
    private ExecutionOutput execution;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StageOutput id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12ab3c45de678910abc12345", required=true, value="The ID of this stage")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StageOutput name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10% rollout on day 1", value="The stage name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StageOutput conditions(List<ConditionOutput> conditions) {
        this.conditions = conditions;
        return this;
    }

    public StageOutput addConditionsItem(ConditionOutput conditionsItem) {
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[{\"_execution\":{\"status\":\"completed\"},\"id\":\"12ab3c45de678910abc12345\",\"kind\":\"schedule\",\"scheduleKind\":\"relative\",\"waitDuration\":2,\"waitDurationUnit\":\"calendarDay\"}]", required=true, value="An array of conditions for the stage")
    public List<ConditionOutput> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionOutput> conditions) {
        this.conditions = conditions;
    }

    public StageOutput action(ActionOutput action) {
        this.action = action;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ActionOutput getAction() {
        return this.action;
    }

    public void setAction(ActionOutput action) {
        this.action = action;
    }

    public StageOutput execution(ExecutionOutput execution) {
        this.execution = execution;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ExecutionOutput getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionOutput execution) {
        this.execution = execution;
    }

    public StageOutput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageOutput stageOutput = (StageOutput)o;
        return Objects.equals(this.id, stageOutput.id) && Objects.equals(this.name, stageOutput.name) && Objects.equals(this.conditions, stageOutput.conditions) && Objects.equals(this.action, stageOutput.action) && Objects.equals(this.execution, stageOutput.execution) && Objects.equals(this.additionalProperties, stageOutput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.conditions, this.action, this.execution, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StageOutput {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    execution: ").append(this.toIndentedString(this.execution)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StageOutput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        JsonArray jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS);
        if (jsonArrayconditions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                ConditionOutput.validateJsonObject(jsonArrayconditions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION) != null) {
            ActionOutput.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACTION));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EXECUTION) != null) {
            ExecutionOutput.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXECUTION));
        }
    }

    public static StageOutput fromJson(String jsonString) throws IOException {
        return (StageOutput)JSON.getGson().fromJson(jsonString, StageOutput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_ACTION);
        openapiFields.add(SERIALIZED_NAME_EXECUTION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_ACTION);
        openapiRequiredFields.add(SERIALIZED_NAME_EXECUTION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!StageOutput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StageOutput.class));
            return new TypeAdapter<StageOutput>(){

                public void write(JsonWriter out, StageOutput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public StageOutput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StageOutput.validateJsonObject(jsonObj);
                    StageOutput instance = (StageOutput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

