/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.TreatmentParameterInput;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TreatmentInput {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_BASELINE = "baseline";
    @SerializedName(value="baseline")
    private Boolean baseline;
    public static final String SERIALIZED_NAME_ALLOCATION_PERCENT = "allocationPercent";
    @SerializedName(value="allocationPercent")
    private String allocationPercent;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private List<TreatmentParameterInput> parameters = new ArrayList<TreatmentParameterInput>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TreatmentInput name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Treatment 1", required=true, value="The treatment name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TreatmentInput baseline(Boolean baseline) {
        this.baseline = baseline;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether this treatment is the baseline to compare other treatments against")
    public Boolean getBaseline() {
        return this.baseline;
    }

    public void setBaseline(Boolean baseline) {
        this.baseline = baseline;
    }

    public TreatmentInput allocationPercent(String allocationPercent) {
        this.allocationPercent = allocationPercent;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="10", required=true, value="The percentage of traffic allocated to this treatment during the iteration")
    public String getAllocationPercent() {
        return this.allocationPercent;
    }

    public void setAllocationPercent(String allocationPercent) {
        this.allocationPercent = allocationPercent;
    }

    public TreatmentInput parameters(List<TreatmentParameterInput> parameters) {
        this.parameters = parameters;
        return this;
    }

    public TreatmentInput addParametersItem(TreatmentParameterInput parametersItem) {
        this.parameters.add(parametersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Details on the flag and variation to use for this treatment")
    public List<TreatmentParameterInput> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<TreatmentParameterInput> parameters) {
        this.parameters = parameters;
    }

    public TreatmentInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreatmentInput treatmentInput = (TreatmentInput)o;
        return Objects.equals(this.name, treatmentInput.name) && Objects.equals(this.baseline, treatmentInput.baseline) && Objects.equals(this.allocationPercent, treatmentInput.allocationPercent) && Objects.equals(this.parameters, treatmentInput.parameters) && Objects.equals(this.additionalProperties, treatmentInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.baseline, this.allocationPercent, this.parameters, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreatmentInput {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    baseline: ").append(this.toIndentedString(this.baseline)).append("\n");
        sb.append("    allocationPercent: ").append(this.toIndentedString(this.allocationPercent)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TreatmentInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATION_PERCENT) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATION_PERCENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `allocationPercent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOCATION_PERCENT).toString()));
        }
        JsonArray jsonArrayparameters = jsonObj.getAsJsonArray(SERIALIZED_NAME_PARAMETERS);
        if (jsonArrayparameters != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PARAMETERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PARAMETERS).toString()));
            }
            for (int i = 0; i < jsonArrayparameters.size(); ++i) {
                TreatmentParameterInput.validateJsonObject(jsonArrayparameters.get(i).getAsJsonObject());
            }
        }
    }

    public static TreatmentInput fromJson(String jsonString) throws IOException {
        return (TreatmentInput)JSON.getGson().fromJson(jsonString, TreatmentInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_BASELINE);
        openapiFields.add(SERIALIZED_NAME_ALLOCATION_PERCENT);
        openapiFields.add(SERIALIZED_NAME_PARAMETERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_BASELINE);
        openapiRequiredFields.add(SERIALIZED_NAME_ALLOCATION_PERCENT);
        openapiRequiredFields.add(SERIALIZED_NAME_PARAMETERS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TreatmentInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TreatmentInput.class));
            return new TypeAdapter<TreatmentInput>(){

                public void write(JsonWriter out, TreatmentInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TreatmentInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TreatmentInput.validateJsonObject(jsonObj);
                    TreatmentInput instance = (TreatmentInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

