/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.FlagLinkCollectionRep;
import com.launchdarkly.api.model.FlagLinkPost;
import com.launchdarkly.api.model.FlagLinkRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class FlagLinksBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FlagLinksBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlagLinksBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createFlagLinkCall(String projectKey, String featureFlagKey, FlagLinkPost flagLinkPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagLinkPost localVarPostBody = flagLinkPost;
        String localVarPath = "/api/v2/flag-links/projects/{projectKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFlagLinkValidateBeforeCall(String projectKey, String featureFlagKey, FlagLinkPost flagLinkPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createFlagLink(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling createFlagLink(Async)");
        }
        if (flagLinkPost == null) {
            throw new ApiException("Missing the required parameter 'flagLinkPost' when calling createFlagLink(Async)");
        }
        Call localVarCall = this.createFlagLinkCall(projectKey, featureFlagKey, flagLinkPost, _callback);
        return localVarCall;
    }

    public FlagLinkRep createFlagLink(String projectKey, String featureFlagKey, FlagLinkPost flagLinkPost) throws ApiException {
        ApiResponse<FlagLinkRep> localVarResp = this.createFlagLinkWithHttpInfo(projectKey, featureFlagKey, flagLinkPost);
        return localVarResp.getData();
    }

    public ApiResponse<FlagLinkRep> createFlagLinkWithHttpInfo(String projectKey, String featureFlagKey, FlagLinkPost flagLinkPost) throws ApiException {
        Call localVarCall = this.createFlagLinkValidateBeforeCall(projectKey, featureFlagKey, flagLinkPost, null);
        Type localVarReturnType = new TypeToken<FlagLinkRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFlagLinkAsync(String projectKey, String featureFlagKey, FlagLinkPost flagLinkPost, ApiCallback<FlagLinkRep> _callback) throws ApiException {
        Call localVarCall = this.createFlagLinkValidateBeforeCall(projectKey, featureFlagKey, flagLinkPost, _callback);
        Type localVarReturnType = new TypeToken<FlagLinkRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFlagLinkCall(String projectKey, String featureFlagKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flag-links/projects/{projectKey}/flags/{featureFlagKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFlagLinkValidateBeforeCall(String projectKey, String featureFlagKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFlagLink(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFlagLink(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteFlagLink(Async)");
        }
        Call localVarCall = this.deleteFlagLinkCall(projectKey, featureFlagKey, id, _callback);
        return localVarCall;
    }

    public void deleteFlagLink(String projectKey, String featureFlagKey, String id) throws ApiException {
        this.deleteFlagLinkWithHttpInfo(projectKey, featureFlagKey, id);
    }

    public ApiResponse<Void> deleteFlagLinkWithHttpInfo(String projectKey, String featureFlagKey, String id) throws ApiException {
        Call localVarCall = this.deleteFlagLinkValidateBeforeCall(projectKey, featureFlagKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFlagLinkAsync(String projectKey, String featureFlagKey, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFlagLinkValidateBeforeCall(projectKey, featureFlagKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getFlagLinksCall(String projectKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flag-links/projects/{projectKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFlagLinksValidateBeforeCall(String projectKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagLinks(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagLinks(Async)");
        }
        Call localVarCall = this.getFlagLinksCall(projectKey, featureFlagKey, _callback);
        return localVarCall;
    }

    public FlagLinkCollectionRep getFlagLinks(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<FlagLinkCollectionRep> localVarResp = this.getFlagLinksWithHttpInfo(projectKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<FlagLinkCollectionRep> getFlagLinksWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call localVarCall = this.getFlagLinksValidateBeforeCall(projectKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<FlagLinkCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFlagLinksAsync(String projectKey, String featureFlagKey, ApiCallback<FlagLinkCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getFlagLinksValidateBeforeCall(projectKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<FlagLinkCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFlagLinkCall(String projectKey, String featureFlagKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/flag-links/projects/{projectKey}/flags/{featureFlagKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFlagLinkValidateBeforeCall(String projectKey, String featureFlagKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateFlagLink(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling updateFlagLink(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateFlagLink(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling updateFlagLink(Async)");
        }
        Call localVarCall = this.updateFlagLinkCall(projectKey, featureFlagKey, id, patchOperation, _callback);
        return localVarCall;
    }

    public FlagLinkRep updateFlagLink(String projectKey, String featureFlagKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<FlagLinkRep> localVarResp = this.updateFlagLinkWithHttpInfo(projectKey, featureFlagKey, id, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<FlagLinkRep> updateFlagLinkWithHttpInfo(String projectKey, String featureFlagKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.updateFlagLinkValidateBeforeCall(projectKey, featureFlagKey, id, patchOperation, null);
        Type localVarReturnType = new TypeToken<FlagLinkRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateFlagLinkAsync(String projectKey, String featureFlagKey, String id, List<PatchOperation> patchOperation, ApiCallback<FlagLinkRep> _callback) throws ApiException {
        Call localVarCall = this.updateFlagLinkValidateBeforeCall(projectKey, featureFlagKey, id, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<FlagLinkRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

