/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.InsightsRepositoryCollection;
import com.launchdarkly.api.model.InsightsRepositoryProjectCollection;
import com.launchdarkly.api.model.InsightsRepositoryProjectMappings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class InsightsRepositoriesBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InsightsRepositoriesBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightsRepositoriesBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call associateRepositoriesAndProjectsCall(InsightsRepositoryProjectMappings insightsRepositoryProjectMappings, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InsightsRepositoryProjectMappings localVarPostBody = insightsRepositoryProjectMappings;
        String localVarPath = "/api/v2/engineering-insights/repositories/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call associateRepositoriesAndProjectsValidateBeforeCall(InsightsRepositoryProjectMappings insightsRepositoryProjectMappings, ApiCallback _callback) throws ApiException {
        if (insightsRepositoryProjectMappings == null) {
            throw new ApiException("Missing the required parameter 'insightsRepositoryProjectMappings' when calling associateRepositoriesAndProjects(Async)");
        }
        Call localVarCall = this.associateRepositoriesAndProjectsCall(insightsRepositoryProjectMappings, _callback);
        return localVarCall;
    }

    public InsightsRepositoryProjectCollection associateRepositoriesAndProjects(InsightsRepositoryProjectMappings insightsRepositoryProjectMappings) throws ApiException {
        ApiResponse<InsightsRepositoryProjectCollection> localVarResp = this.associateRepositoriesAndProjectsWithHttpInfo(insightsRepositoryProjectMappings);
        return localVarResp.getData();
    }

    public ApiResponse<InsightsRepositoryProjectCollection> associateRepositoriesAndProjectsWithHttpInfo(InsightsRepositoryProjectMappings insightsRepositoryProjectMappings) throws ApiException {
        Call localVarCall = this.associateRepositoriesAndProjectsValidateBeforeCall(insightsRepositoryProjectMappings, null);
        Type localVarReturnType = new TypeToken<InsightsRepositoryProjectCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call associateRepositoriesAndProjectsAsync(InsightsRepositoryProjectMappings insightsRepositoryProjectMappings, ApiCallback<InsightsRepositoryProjectCollection> _callback) throws ApiException {
        Call localVarCall = this.associateRepositoriesAndProjectsValidateBeforeCall(insightsRepositoryProjectMappings, _callback);
        Type localVarReturnType = new TypeToken<InsightsRepositoryProjectCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteRepositoryProjectCall(String repositoryKey, String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/repositories/{repositoryKey}/projects/{projectKey}".replaceAll("\\{repositoryKey\\}", this.localVarApiClient.escapeString(repositoryKey.toString())).replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryProjectValidateBeforeCall(String repositoryKey, String projectKey, ApiCallback _callback) throws ApiException {
        if (repositoryKey == null) {
            throw new ApiException("Missing the required parameter 'repositoryKey' when calling deleteRepositoryProject(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteRepositoryProject(Async)");
        }
        Call localVarCall = this.deleteRepositoryProjectCall(repositoryKey, projectKey, _callback);
        return localVarCall;
    }

    public void deleteRepositoryProject(String repositoryKey, String projectKey) throws ApiException {
        this.deleteRepositoryProjectWithHttpInfo(repositoryKey, projectKey);
    }

    public ApiResponse<Void> deleteRepositoryProjectWithHttpInfo(String repositoryKey, String projectKey) throws ApiException {
        Call localVarCall = this.deleteRepositoryProjectValidateBeforeCall(repositoryKey, projectKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRepositoryProjectAsync(String repositoryKey, String projectKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryProjectValidateBeforeCall(repositoryKey, projectKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getInsightsRepositoriesCall(String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightsRepositoriesValidateBeforeCall(String expand, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getInsightsRepositoriesCall(expand, _callback);
        return localVarCall;
    }

    public InsightsRepositoryCollection getInsightsRepositories(String expand) throws ApiException {
        ApiResponse<InsightsRepositoryCollection> localVarResp = this.getInsightsRepositoriesWithHttpInfo(expand);
        return localVarResp.getData();
    }

    public ApiResponse<InsightsRepositoryCollection> getInsightsRepositoriesWithHttpInfo(String expand) throws ApiException {
        Call localVarCall = this.getInsightsRepositoriesValidateBeforeCall(expand, null);
        Type localVarReturnType = new TypeToken<InsightsRepositoryCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightsRepositoriesAsync(String expand, ApiCallback<InsightsRepositoryCollection> _callback) throws ApiException {
        Call localVarCall = this.getInsightsRepositoriesValidateBeforeCall(expand, _callback);
        Type localVarReturnType = new TypeToken<InsightsRepositoryCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

