/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Export;
import com.launchdarkly.api.model.ModelImport;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SegmentsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SegmentsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createBigSegmentExportCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentExportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentExport(Async)");
        }
        Call localVarCall = this.createBigSegmentExportCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public void createBigSegmentExport(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        this.createBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey);
    }

    public ApiResponse<Void> createBigSegmentExportWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentExportAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createBigSegmentImportCall(String projectKey, String environmentKey, String segmentKey, File _file, String mode, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (mode != null) {
            localVarFormParams.put("mode", mode);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentImportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, File _file, String mode, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentImport(Async)");
        }
        Call localVarCall = this.createBigSegmentImportCall(projectKey, environmentKey, segmentKey, _file, mode, _callback);
        return localVarCall;
    }

    public void createBigSegmentImport(String projectKey, String environmentKey, String segmentKey, File _file, String mode) throws ApiException {
        this.createBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, _file, mode);
    }

    public ApiResponse<Void> createBigSegmentImportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, File _file, String mode) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentImportAsync(String projectKey, String environmentKey, String segmentKey, File _file, String mode, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBigSegmentExportCall(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports/{exportID}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{exportID\\}", this.localVarApiClient.escapeString(exportID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentExportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentExport(Async)");
        }
        if (exportID == null) {
            throw new ApiException("Missing the required parameter 'exportID' when calling getBigSegmentExport(Async)");
        }
        Call localVarCall = this.getBigSegmentExportCall(projectKey, environmentKey, segmentKey, exportID, _callback);
        return localVarCall;
    }

    public Export getBigSegmentExport(String projectKey, String environmentKey, String segmentKey, String exportID) throws ApiException {
        ApiResponse<Export> localVarResp = this.getBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey, exportID);
        return localVarResp.getData();
    }

    public ApiResponse<Export> getBigSegmentExportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String exportID) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, null);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentExportAsync(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback<Export> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, _callback);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBigSegmentImportCall(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports/{importID}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{importID\\}", this.localVarApiClient.escapeString(importID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentImportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentImport(Async)");
        }
        if (importID == null) {
            throw new ApiException("Missing the required parameter 'importID' when calling getBigSegmentImport(Async)");
        }
        Call localVarCall = this.getBigSegmentImportCall(projectKey, environmentKey, segmentKey, importID, _callback);
        return localVarCall;
    }

    public ModelImport getBigSegmentImport(String projectKey, String environmentKey, String segmentKey, String importID) throws ApiException {
        ApiResponse<ModelImport> localVarResp = this.getBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, importID);
        return localVarResp.getData();
    }

    public ApiResponse<ModelImport> getBigSegmentImportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String importID) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, null);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentImportAsync(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback<ModelImport> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, _callback);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

