/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CreateApprovalRequestRequest {
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    private String resourceId;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
    public static final String SERIALIZED_NAME_NOTIFY_MEMBER_IDS = "notifyMemberIds";
    @SerializedName(value="notifyMemberIds")
    private List<String> notifyMemberIds = null;
    public static final String SERIALIZED_NAME_NOTIFY_TEAM_KEYS = "notifyTeamKeys";
    @SerializedName(value="notifyTeamKeys")
    private List<String> notifyTeamKeys = null;
    public static final String SERIALIZED_NAME_INTEGRATION_CONFIG = "integrationConfig";
    @SerializedName(value="integrationConfig")
    private Map<String, Object> integrationConfig = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateApprovalRequestRequest resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="String representation of a resource")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public CreateApprovalRequestRequest comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="optional comment", value="Optional comment describing the approval request")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateApprovalRequestRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Requesting to update targeting", required=true, value="A brief description of the changes you're requesting")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateApprovalRequestRequest instructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
        return this;
    }

    public CreateApprovalRequestRequest addInstructionsItem(Map<String, Object> instructionsItem) {
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<Map<String, Object>> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
    }

    public CreateApprovalRequestRequest notifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
        return this;
    }

    public CreateApprovalRequestRequest addNotifyMemberIdsItem(String notifyMemberIdsItem) {
        if (this.notifyMemberIds == null) {
            this.notifyMemberIds = new ArrayList<String>();
        }
        this.notifyMemberIds.add(notifyMemberIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1234a56b7c89d012345e678f\"]", value="An array of member IDs. These members are notified to review the approval request.")
    public List<String> getNotifyMemberIds() {
        return this.notifyMemberIds;
    }

    public void setNotifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
    }

    public CreateApprovalRequestRequest notifyTeamKeys(List<String> notifyTeamKeys) {
        this.notifyTeamKeys = notifyTeamKeys;
        return this;
    }

    public CreateApprovalRequestRequest addNotifyTeamKeysItem(String notifyTeamKeysItem) {
        if (this.notifyTeamKeys == null) {
            this.notifyTeamKeys = new ArrayList<String>();
        }
        this.notifyTeamKeys.add(notifyTeamKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-reviewer-team\"]", value="An array of team keys. The members of these teams are notified to review the approval request.")
    public List<String> getNotifyTeamKeys() {
        return this.notifyTeamKeys;
    }

    public void setNotifyTeamKeys(List<String> notifyTeamKeys) {
        this.notifyTeamKeys = notifyTeamKeys;
    }

    public CreateApprovalRequestRequest integrationConfig(Map<String, Object> integrationConfig) {
        this.integrationConfig = integrationConfig;
        return this;
    }

    public CreateApprovalRequestRequest putIntegrationConfigItem(String key, Object integrationConfigItem) {
        if (this.integrationConfig == null) {
            this.integrationConfig = new HashMap<String, Object>();
        }
        this.integrationConfig.put(key, integrationConfigItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Object> getIntegrationConfig() {
        return this.integrationConfig;
    }

    public void setIntegrationConfig(Map<String, Object> integrationConfig) {
        this.integrationConfig = integrationConfig;
    }

    public CreateApprovalRequestRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateApprovalRequestRequest createApprovalRequestRequest = (CreateApprovalRequestRequest)o;
        return Objects.equals(this.resourceId, createApprovalRequestRequest.resourceId) && Objects.equals(this.comment, createApprovalRequestRequest.comment) && Objects.equals(this.description, createApprovalRequestRequest.description) && Objects.equals(this.instructions, createApprovalRequestRequest.instructions) && Objects.equals(this.notifyMemberIds, createApprovalRequestRequest.notifyMemberIds) && Objects.equals(this.notifyTeamKeys, createApprovalRequestRequest.notifyTeamKeys) && Objects.equals(this.integrationConfig, createApprovalRequestRequest.integrationConfig) && Objects.equals(this.additionalProperties, createApprovalRequestRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.comment, this.description, this.instructions, this.notifyMemberIds, this.notifyTeamKeys, this.integrationConfig, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateApprovalRequestRequest {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    notifyMemberIds: ").append(this.toIndentedString(this.notifyMemberIds)).append("\n");
        sb.append("    notifyTeamKeys: ").append(this.toIndentedString(this.notifyTeamKeys)).append("\n");
        sb.append("    integrationConfig: ").append(this.toIndentedString(this.integrationConfig)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateApprovalRequestRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `instructions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifyMemberIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifyTeamKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS).toString()));
        }
    }

    public static CreateApprovalRequestRequest fromJson(String jsonString) throws IOException {
        return (CreateApprovalRequestRequest)JSON.getGson().fromJson(jsonString, CreateApprovalRequestRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESOURCE_ID);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_MEMBER_IDS);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_TEAM_KEYS);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_CONFIG);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_INSTRUCTIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CreateApprovalRequestRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateApprovalRequestRequest.class));
            return new TypeAdapter<CreateApprovalRequestRequest>(){

                public void write(JsonWriter out, CreateApprovalRequestRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateApprovalRequestRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateApprovalRequestRequest.validateJsonObject(jsonObj);
                    CreateApprovalRequestRequest instance = (CreateApprovalRequestRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

