/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FlagCopyConfigEnvironment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlagCopyConfigPost {
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private FlagCopyConfigEnvironment source;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    private FlagCopyConfigEnvironment target;
    public static final String SERIALIZED_NAME_COMMENT = "comment";
    @SerializedName(value="comment")
    private String comment;
    public static final String SERIALIZED_NAME_INCLUDED_ACTIONS = "includedActions";
    @SerializedName(value="includedActions")
    private List<IncludedActionsEnum> includedActions = null;
    public static final String SERIALIZED_NAME_EXCLUDED_ACTIONS = "excludedActions";
    @SerializedName(value="excludedActions")
    private List<ExcludedActionsEnum> excludedActions = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagCopyConfigPost source(FlagCopyConfigEnvironment source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FlagCopyConfigEnvironment getSource() {
        return this.source;
    }

    public void setSource(FlagCopyConfigEnvironment source) {
        this.source = source;
    }

    public FlagCopyConfigPost target(FlagCopyConfigEnvironment target) {
        this.target = target;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FlagCopyConfigEnvironment getTarget() {
        return this.target;
    }

    public void setTarget(FlagCopyConfigEnvironment target) {
        this.target = target;
    }

    public FlagCopyConfigPost comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FlagCopyConfigPost includedActions(List<IncludedActionsEnum> includedActions) {
        this.includedActions = includedActions;
        return this;
    }

    public FlagCopyConfigPost addIncludedActionsItem(IncludedActionsEnum includedActionsItem) {
        if (this.includedActions == null) {
            this.includedActions = new ArrayList<IncludedActionsEnum>();
        }
        this.includedActions.add(includedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"updateOn\"]", value="Optional list of the flag changes to copy from the source environment to the target environment. You may include either <code>includedActions</code> or <code>excludedActions</code>, but not both. If you include neither, then all flag changes will be copied.")
    public List<IncludedActionsEnum> getIncludedActions() {
        return this.includedActions;
    }

    public void setIncludedActions(List<IncludedActionsEnum> includedActions) {
        this.includedActions = includedActions;
    }

    public FlagCopyConfigPost excludedActions(List<ExcludedActionsEnum> excludedActions) {
        this.excludedActions = excludedActions;
        return this;
    }

    public FlagCopyConfigPost addExcludedActionsItem(ExcludedActionsEnum excludedActionsItem) {
        if (this.excludedActions == null) {
            this.excludedActions = new ArrayList<ExcludedActionsEnum>();
        }
        this.excludedActions.add(excludedActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"updateOn\"]", value="Optional list of the flag changes NOT to copy from the source environment to the target environment. You may include either  <code>includedActions</code> or <code>excludedActions</code>, but not both. If you include neither, then all flag changes will be copied.")
    public List<ExcludedActionsEnum> getExcludedActions() {
        return this.excludedActions;
    }

    public void setExcludedActions(List<ExcludedActionsEnum> excludedActions) {
        this.excludedActions = excludedActions;
    }

    public FlagCopyConfigPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagCopyConfigPost flagCopyConfigPost = (FlagCopyConfigPost)o;
        return Objects.equals(this.source, flagCopyConfigPost.source) && Objects.equals(this.target, flagCopyConfigPost.target) && Objects.equals(this.comment, flagCopyConfigPost.comment) && Objects.equals(this.includedActions, flagCopyConfigPost.includedActions) && Objects.equals(this.excludedActions, flagCopyConfigPost.excludedActions) && Objects.equals(this.additionalProperties, flagCopyConfigPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.comment, this.includedActions, this.excludedActions, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagCopyConfigPost {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    includedActions: ").append(this.toIndentedString(this.includedActions)).append("\n");
        sb.append("    excludedActions: ").append(this.toIndentedString(this.excludedActions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagCopyConfigPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE) != null) {
            FlagCopyConfigEnvironment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOURCE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET) != null) {
            FlagCopyConfigEnvironment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `comment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INCLUDED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INCLUDED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `includedActions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INCLUDED_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDED_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDED_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `excludedActions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDED_ACTIONS).toString()));
        }
    }

    public static FlagCopyConfigPost fromJson(String jsonString) throws IOException {
        return (FlagCopyConfigPost)JSON.getGson().fromJson(jsonString, FlagCopyConfigPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_TARGET);
        openapiFields.add(SERIALIZED_NAME_COMMENT);
        openapiFields.add(SERIALIZED_NAME_INCLUDED_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_EXCLUDED_ACTIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SOURCE);
        openapiRequiredFields.add(SERIALIZED_NAME_TARGET);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagCopyConfigPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagCopyConfigPost.class));
            return new TypeAdapter<FlagCopyConfigPost>(){

                public void write(JsonWriter out, FlagCopyConfigPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagCopyConfigPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagCopyConfigPost.validateJsonObject(jsonObj);
                    FlagCopyConfigPost instance = (FlagCopyConfigPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExcludedActionsEnum {
        UPDATEON("updateOn"),
        UPDATERULES("updateRules"),
        UPDATEFALLTHROUGH("updateFallthrough"),
        UPDATEOFFVARIATION("updateOffVariation"),
        UPDATEPREREQUISITES("updatePrerequisites"),
        UPDATETARGETS("updateTargets"),
        UPDATEFLAGCONFIGMIGRATIONSETTINGS("updateFlagConfigMigrationSettings");

        private String value;

        private ExcludedActionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExcludedActionsEnum fromValue(String value) {
            for (ExcludedActionsEnum b : ExcludedActionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ExcludedActionsEnum> {
            public void write(JsonWriter jsonWriter, ExcludedActionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExcludedActionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExcludedActionsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IncludedActionsEnum {
        UPDATEON("updateOn"),
        UPDATERULES("updateRules"),
        UPDATEFALLTHROUGH("updateFallthrough"),
        UPDATEOFFVARIATION("updateOffVariation"),
        UPDATEPREREQUISITES("updatePrerequisites"),
        UPDATETARGETS("updateTargets"),
        UPDATEFLAGCONFIGMIGRATIONSETTINGS("updateFlagConfigMigrationSettings");

        private String value;

        private IncludedActionsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IncludedActionsEnum fromValue(String value) {
            for (IncludedActionsEnum b : IncludedActionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IncludedActionsEnum> {
            public void write(JsonWriter jsonWriter, IncludedActionsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IncludedActionsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IncludedActionsEnum.fromValue(value);
            }
        }
    }
}

