/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.InsightGroup;
import com.launchdarkly.api.model.InsightGroupCollectionMetadata;
import com.launchdarkly.api.model.InsightGroupCollectionScoreMetadata;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InsightGroupCollection {
    public static final String SERIALIZED_NAME_TOTAL_COUNT = "totalCount";
    @SerializedName(value="totalCount")
    private Integer totalCount;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<InsightGroup> items = new ArrayList<InsightGroup>();
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private InsightGroupCollectionMetadata metadata;
    public static final String SERIALIZED_NAME_SCORE_METADATA = "scoreMetadata";
    @SerializedName(value="scoreMetadata")
    private InsightGroupCollectionScoreMetadata scoreMetadata;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InsightGroupCollection totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="15", required=true, value="The total number of insight groups")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public InsightGroupCollection items(List<InsightGroup> items) {
        this.items = items;
        return this;
    }

    public InsightGroupCollection addItemsItem(InsightGroup itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of insight groups")
    public List<InsightGroup> getItems() {
        return this.items;
    }

    public void setItems(List<InsightGroup> items) {
        this.items = items;
    }

    public InsightGroupCollection links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public InsightGroupCollection putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public InsightGroupCollection metadata(InsightGroupCollectionMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InsightGroupCollectionMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(InsightGroupCollectionMetadata metadata) {
        this.metadata = metadata;
    }

    public InsightGroupCollection scoreMetadata(InsightGroupCollectionScoreMetadata scoreMetadata) {
        this.scoreMetadata = scoreMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InsightGroupCollectionScoreMetadata getScoreMetadata() {
        return this.scoreMetadata;
    }

    public void setScoreMetadata(InsightGroupCollectionScoreMetadata scoreMetadata) {
        this.scoreMetadata = scoreMetadata;
    }

    public InsightGroupCollection putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightGroupCollection insightGroupCollection = (InsightGroupCollection)o;
        return Objects.equals(this.totalCount, insightGroupCollection.totalCount) && Objects.equals(this.items, insightGroupCollection.items) && Objects.equals(this.links, insightGroupCollection.links) && Objects.equals(this.metadata, insightGroupCollection.metadata) && Objects.equals(this.scoreMetadata, insightGroupCollection.scoreMetadata) && Objects.equals(this.additionalProperties, insightGroupCollection.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.items, this.links, this.metadata, this.scoreMetadata, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsightGroupCollection {\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    scoreMetadata: ").append(this.toIndentedString(this.scoreMetadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InsightGroupCollection is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS);
        if (jsonArrayitems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                InsightGroup.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA) != null) {
            InsightGroupCollectionMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORE_METADATA) != null) {
            InsightGroupCollectionScoreMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORE_METADATA));
        }
    }

    public static InsightGroupCollection fromJson(String jsonString) throws IOException {
        return (InsightGroupCollection)JSON.getGson().fromJson(jsonString, InsightGroupCollection.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TOTAL_COUNT);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_SCORE_METADATA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!InsightGroupCollection.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InsightGroupCollection.class));
            return new TypeAdapter<InsightGroupCollection>(){

                public void write(JsonWriter out, InsightGroupCollection value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public InsightGroupCollection read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InsightGroupCollection.validateJsonObject(jsonObj);
                    InsightGroupCollection instance = (InsightGroupCollection)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

