/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FlagInput;
import com.launchdarkly.api.model.MetricInput;
import com.launchdarkly.api.model.TreatmentInput;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IterationInput {
    public static final String SERIALIZED_NAME_HYPOTHESIS = "hypothesis";
    @SerializedName(value="hypothesis")
    private String hypothesis;
    public static final String SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC = "canReshuffleTraffic";
    @SerializedName(value="canReshuffleTraffic")
    private Boolean canReshuffleTraffic;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<MetricInput> metrics = new ArrayList<MetricInput>();
    public static final String SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY = "primarySingleMetricKey";
    @SerializedName(value="primarySingleMetricKey")
    private String primarySingleMetricKey;
    public static final String SERIALIZED_NAME_PRIMARY_FUNNEL_KEY = "primaryFunnelKey";
    @SerializedName(value="primaryFunnelKey")
    private String primaryFunnelKey;
    public static final String SERIALIZED_NAME_TREATMENTS = "treatments";
    @SerializedName(value="treatments")
    private List<TreatmentInput> treatments = new ArrayList<TreatmentInput>();
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    private Map<String, FlagInput> flags = new HashMap<String, FlagInput>();
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNIT = "randomizationUnit";
    @SerializedName(value="randomizationUnit")
    private String randomizationUnit;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IterationInput hypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example hypothesis, the new button placement will increase conversion", required=true, value="The expected outcome of this experiment")
    public String getHypothesis() {
        return this.hypothesis;
    }

    public void setHypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
    }

    public IterationInput canReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether to allow the experiment to reassign traffic to different variations when you increase or decrease the traffic in your experiment audience (true) or keep all traffic assigned to its initial variation (false). Defaults to true.")
    public Boolean getCanReshuffleTraffic() {
        return this.canReshuffleTraffic;
    }

    public void setCanReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
    }

    public IterationInput metrics(List<MetricInput> metrics) {
        this.metrics = metrics;
        return this;
    }

    public IterationInput addMetricsItem(MetricInput metricsItem) {
        this.metrics.add(metricsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<MetricInput> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricInput> metrics) {
        this.metrics = metrics;
    }

    public IterationInput primarySingleMetricKey(String primarySingleMetricKey) {
        this.primarySingleMetricKey = primarySingleMetricKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="metric-key-123abc", value="The key of the primary metric for this experiment. Either <code>primarySingleMetricKey</code> or <code>primaryFunnelKey</code> must be present.")
    public String getPrimarySingleMetricKey() {
        return this.primarySingleMetricKey;
    }

    public void setPrimarySingleMetricKey(String primarySingleMetricKey) {
        this.primarySingleMetricKey = primarySingleMetricKey;
    }

    public IterationInput primaryFunnelKey(String primaryFunnelKey) {
        this.primaryFunnelKey = primaryFunnelKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="metric-group-key-123abc", value="The key of the primary funnel group for this experiment. Either <code>primarySingleMetricKey</code> or <code>primaryFunnelKey</code> must be present.")
    public String getPrimaryFunnelKey() {
        return this.primaryFunnelKey;
    }

    public void setPrimaryFunnelKey(String primaryFunnelKey) {
        this.primaryFunnelKey = primaryFunnelKey;
    }

    public IterationInput treatments(List<TreatmentInput> treatments) {
        this.treatments = treatments;
        return this;
    }

    public IterationInput addTreatmentsItem(TreatmentInput treatmentsItem) {
        this.treatments.add(treatmentsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<TreatmentInput> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(List<TreatmentInput> treatments) {
        this.treatments = treatments;
    }

    public IterationInput flags(Map<String, FlagInput> flags) {
        this.flags = flags;
        return this;
    }

    public IterationInput putFlagsItem(String key, FlagInput flagsItem) {
        this.flags.put(key, flagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Map<String, FlagInput> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, FlagInput> flags) {
        this.flags = flags;
    }

    public IterationInput randomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user", value="The unit of randomization for this iteration. Defaults to user.")
    public String getRandomizationUnit() {
        return this.randomizationUnit;
    }

    public void setRandomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
    }

    public IterationInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationInput iterationInput = (IterationInput)o;
        return Objects.equals(this.hypothesis, iterationInput.hypothesis) && Objects.equals(this.canReshuffleTraffic, iterationInput.canReshuffleTraffic) && Objects.equals(this.metrics, iterationInput.metrics) && Objects.equals(this.primarySingleMetricKey, iterationInput.primarySingleMetricKey) && Objects.equals(this.primaryFunnelKey, iterationInput.primaryFunnelKey) && Objects.equals(this.treatments, iterationInput.treatments) && Objects.equals(this.flags, iterationInput.flags) && Objects.equals(this.randomizationUnit, iterationInput.randomizationUnit) && Objects.equals(this.additionalProperties, iterationInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hypothesis, this.canReshuffleTraffic, this.metrics, this.primarySingleMetricKey, this.primaryFunnelKey, this.treatments, this.flags, this.randomizationUnit, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IterationInput {\n");
        sb.append("    hypothesis: ").append(this.toIndentedString(this.hypothesis)).append("\n");
        sb.append("    canReshuffleTraffic: ").append(this.toIndentedString(this.canReshuffleTraffic)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    primarySingleMetricKey: ").append(this.toIndentedString(this.primarySingleMetricKey)).append("\n");
        sb.append("    primaryFunnelKey: ").append(this.toIndentedString(this.primaryFunnelKey)).append("\n");
        sb.append("    treatments: ").append(this.toIndentedString(this.treatments)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    randomizationUnit: ").append(this.toIndentedString(this.randomizationUnit)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IterationInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HYPOTHESIS) != null && !jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hypothesis` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).toString()));
        }
        JsonArray jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS);
        if (jsonArraymetrics != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraymetrics.size(); ++i) {
                MetricInput.validateJsonObject(jsonArraymetrics.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `primarySingleMetricKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `primaryFunnelKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY).toString()));
        }
        JsonArray jsonArraytreatments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENTS);
        if (jsonArraytreatments != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TREATMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `treatments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENTS).toString()));
            }
            for (int i = 0; i < jsonArraytreatments.size(); ++i) {
                TreatmentInput.validateJsonObject(jsonArraytreatments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).toString()));
        }
    }

    public static IterationInput fromJson(String jsonString) throws IOException {
        return (IterationInput)JSON.getGson().fromJson(jsonString, IterationInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HYPOTHESIS);
        openapiFields.add(SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC);
        openapiFields.add(SERIALIZED_NAME_METRICS);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY);
        openapiFields.add(SERIALIZED_NAME_TREATMENTS);
        openapiFields.add(SERIALIZED_NAME_FLAGS);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNIT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HYPOTHESIS);
        openapiRequiredFields.add(SERIALIZED_NAME_METRICS);
        openapiRequiredFields.add(SERIALIZED_NAME_TREATMENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_FLAGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IterationInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IterationInput.class));
            return new TypeAdapter<IterationInput>(){

                public void write(JsonWriter out, IterationInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IterationInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IterationInput.validateJsonObject(jsonObj);
                    IterationInput instance = (IterationInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

