/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.DependentExperimentRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MaintainerRep;
import com.launchdarkly.api.model.MetricInGroupRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricGroupRep {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "_lastModified";
    @SerializedName(value="_lastModified")
    private Long lastModified;
    public static final String SERIALIZED_NAME_MAINTAINER = "maintainer";
    @SerializedName(value="maintainer")
    private MaintainerRep maintainer;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<MetricInGroupRep> metrics = new ArrayList<MetricInGroupRep>();
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    private List<DependentExperimentRep> experiments = null;
    public static final String SERIALIZED_NAME_EXPERIMENT_COUNT = "experimentCount";
    @SerializedName(value="experimentCount")
    private Integer experimentCount;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MetricGroupRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bc3e5be1-02d2-40c7-9926-26d0aacd7aab", required=true, value="The ID of this metric group")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MetricGroupRep key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="metric-group-key-123abc", required=true, value="A unique key to reference the metric group")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MetricGroupRep name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My metric group", required=true, value="A human-friendly name for the metric group")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricGroupRep kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="funnel", required=true, value="The type of the metric group")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public MetricGroupRep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Description of the metric group", value="Description of the metric group")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MetricGroupRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MetricGroupRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/projects/my-project\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/projects/my-project/metric-groups/my-metric-group\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public MetricGroupRep access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public MetricGroupRep tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricGroupRep addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"ops\"]", required=true, value="Tags for the metric group")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MetricGroupRep creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public MetricGroupRep lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public MetricGroupRep maintainer(MaintainerRep maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public MaintainerRep getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(MaintainerRep maintainer) {
        this.maintainer = maintainer;
    }

    public MetricGroupRep metrics(List<MetricInGroupRep> metrics) {
        this.metrics = metrics;
        return this;
    }

    public MetricGroupRep addMetricsItem(MetricInGroupRep metricsItem) {
        this.metrics.add(metricsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="An ordered list of the metrics in this metric group")
    public List<MetricInGroupRep> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricInGroupRep> metrics) {
        this.metrics = metrics;
    }

    public MetricGroupRep version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="The version of this metric group")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public MetricGroupRep experiments(List<DependentExperimentRep> experiments) {
        this.experiments = experiments;
        return this;
    }

    public MetricGroupRep addExperimentsItem(DependentExperimentRep experimentsItem) {
        if (this.experiments == null) {
            this.experiments = new ArrayList<DependentExperimentRep>();
        }
        this.experiments.add(experimentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<DependentExperimentRep> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(List<DependentExperimentRep> experiments) {
        this.experiments = experiments;
    }

    public MetricGroupRep experimentCount(Integer experimentCount) {
        this.experimentCount = experimentCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The number of experiments using this metric group")
    public Integer getExperimentCount() {
        return this.experimentCount;
    }

    public void setExperimentCount(Integer experimentCount) {
        this.experimentCount = experimentCount;
    }

    public MetricGroupRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricGroupRep metricGroupRep = (MetricGroupRep)o;
        return Objects.equals(this.id, metricGroupRep.id) && Objects.equals(this.key, metricGroupRep.key) && Objects.equals(this.name, metricGroupRep.name) && Objects.equals((Object)this.kind, (Object)metricGroupRep.kind) && Objects.equals(this.description, metricGroupRep.description) && Objects.equals(this.links, metricGroupRep.links) && Objects.equals(this.access, metricGroupRep.access) && Objects.equals(this.tags, metricGroupRep.tags) && Objects.equals(this.creationDate, metricGroupRep.creationDate) && Objects.equals(this.lastModified, metricGroupRep.lastModified) && Objects.equals(this.maintainer, metricGroupRep.maintainer) && Objects.equals(this.metrics, metricGroupRep.metrics) && Objects.equals(this.version, metricGroupRep.version) && Objects.equals(this.experiments, metricGroupRep.experiments) && Objects.equals(this.experimentCount, metricGroupRep.experimentCount) && Objects.equals(this.additionalProperties, metricGroupRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.name, this.kind, this.description, this.links, this.access, this.tags, this.creationDate, this.lastModified, this.maintainer, this.metrics, this.version, this.experiments, this.experimentCount, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricGroupRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    experimentCount: ").append(this.toIndentedString(this.experimentCount)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayexperiments;
        JsonArray jsonArraymetrics;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MetricGroupRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER) != null) {
            MaintainerRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER));
        }
        if ((jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraymetrics.size(); ++i) {
                MetricInGroupRep.validateJsonObject(jsonArraymetrics.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayexperiments = jsonObj.getAsJsonArray(SERIALIZED_NAME_EXPERIMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `experiments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayexperiments.size(); ++i) {
                DependentExperimentRep.validateJsonObject(jsonArrayexperiments.get(i).getAsJsonObject());
            }
        }
    }

    public static MetricGroupRep fromJson(String jsonString) throws IOException {
        return (MetricGroupRep)JSON.getGson().fromJson(jsonString, MetricGroupRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER);
        openapiFields.add(SERIALIZED_NAME_METRICS);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENTS);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENT_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_MODIFIED);
        openapiRequiredFields.add(SERIALIZED_NAME_MAINTAINER);
        openapiRequiredFields.add(SERIALIZED_NAME_METRICS);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricGroupRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricGroupRep.class));
            return new TypeAdapter<MetricGroupRep>(){

                public void write(JsonWriter out, MetricGroupRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricGroupRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MetricGroupRep.validateJsonObject(jsonObj);
                    MetricGroupRep instance = (MetricGroupRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        FUNNEL("funnel"),
        STANDARD("standard");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

