/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class PermissionGrantInput {
    public static final String SERIALIZED_NAME_ACTION_SET = "actionSet";
    @SerializedName(value="actionSet")
    private ActionSetEnum actionSet;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private List<String> actions = null;
    public static final String SERIALIZED_NAME_MEMBER_I_DS = "memberIDs";
    @SerializedName(value="memberIDs")
    private List<String> memberIDs = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PermissionGrantInput actionSet(ActionSetEnum actionSet) {
        this.actionSet = actionSet;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="maintainTeam", value="A group of related actions to allow. Specify either <code>actionSet</code> or <code>actions</code>. Use <code>maintainTeam</code> to add team maintainers.")
    public ActionSetEnum getActionSet() {
        return this.actionSet;
    }

    public void setActionSet(ActionSetEnum actionSet) {
        this.actionSet = actionSet;
    }

    public PermissionGrantInput actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public PermissionGrantInput addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"updateTeamMembers\"]", value="A list of actions to allow. Specify either <code>actionSet</code> or <code>actions</code>. To learn more, read [Role actions](https://docs.launchdarkly.com/home/account/role-actions).")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public PermissionGrantInput memberIDs(List<String> memberIDs) {
        this.memberIDs = memberIDs;
        return this;
    }

    public PermissionGrantInput addMemberIDsItem(String memberIDsItem) {
        if (this.memberIDs == null) {
            this.memberIDs = new ArrayList<String>();
        }
        this.memberIDs.add(memberIDsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"12ab3c45de678910fgh12345\"]", value="A list of member IDs who receive the permission grant.")
    public List<String> getMemberIDs() {
        return this.memberIDs;
    }

    public void setMemberIDs(List<String> memberIDs) {
        this.memberIDs = memberIDs;
    }

    public PermissionGrantInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrantInput permissionGrantInput = (PermissionGrantInput)o;
        return Objects.equals((Object)this.actionSet, (Object)permissionGrantInput.actionSet) && Objects.equals(this.actions, permissionGrantInput.actions) && Objects.equals(this.memberIDs, permissionGrantInput.memberIDs) && Objects.equals(this.additionalProperties, permissionGrantInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionSet, this.actions, this.memberIDs, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionGrantInput {\n");
        sb.append("    actionSet: ").append(this.toIndentedString((Object)this.actionSet)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    memberIDs: ").append(this.toIndentedString(this.memberIDs)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PermissionGrantInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTION_SET) != null && !jsonObj.get(SERIALIZED_NAME_ACTION_SET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `actionSet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTION_SET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMBER_I_DS) != null && !jsonObj.get(SERIALIZED_NAME_MEMBER_I_DS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `memberIDs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEMBER_I_DS).toString()));
        }
    }

    public static PermissionGrantInput fromJson(String jsonString) throws IOException {
        return (PermissionGrantInput)JSON.getGson().fromJson(jsonString, PermissionGrantInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTION_SET);
        openapiFields.add(SERIALIZED_NAME_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_MEMBER_I_DS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PermissionGrantInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PermissionGrantInput.class));
            return new TypeAdapter<PermissionGrantInput>(){

                public void write(JsonWriter out, PermissionGrantInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PermissionGrantInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PermissionGrantInput.validateJsonObject(jsonObj);
                    PermissionGrantInput instance = (PermissionGrantInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActionSetEnum {
        MAINTAINTEAM("maintainTeam");

        private String value;

        private ActionSetEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActionSetEnum fromValue(String value) {
            for (ActionSetEnum b : ActionSetEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ActionSetEnum> {
            public void write(JsonWriter jsonWriter, ActionSetEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActionSetEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActionSetEnum.fromValue(value);
            }
        }
    }
}

