/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.ClientSideAvailability;
import com.launchdarkly.api.model.Environments;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Project {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_INCLUDE_IN_SNIPPET_BY_DEFAULT = "includeInSnippetByDefault";
    @SerializedName(value="includeInSnippetByDefault")
    private Boolean includeInSnippetByDefault;
    public static final String SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY = "defaultClientSideAvailability";
    @SerializedName(value="defaultClientSideAvailability")
    private ClientSideAvailability defaultClientSideAvailability;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DEFAULT_RELEASE_PIPELINE_KEY = "defaultReleasePipelineKey";
    @SerializedName(value="defaultReleasePipelineKey")
    private String defaultReleasePipelineKey;
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    private Environments environments;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Project links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Project putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"environments\":{\"href\":\"/api/v2/projects/my-project/environments\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/projects/my-project\",\"type\":\"application/json\"}}", required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Project id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="57be1db38b75bf0772d11383", required=true, value="The ID of this project")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Project key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="project-key-123abc", required=true, value="The key of this project")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Project includeInSnippetByDefault(Boolean includeInSnippetByDefault) {
        this.includeInSnippetByDefault = includeInSnippetByDefault;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether or not flags created in this project are made available to the client-side JavaScript SDK by default")
    public Boolean getIncludeInSnippetByDefault() {
        return this.includeInSnippetByDefault;
    }

    public void setIncludeInSnippetByDefault(Boolean includeInSnippetByDefault) {
        this.includeInSnippetByDefault = includeInSnippetByDefault;
    }

    public Project defaultClientSideAvailability(ClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ClientSideAvailability getDefaultClientSideAvailability() {
        return this.defaultClientSideAvailability;
    }

    public void setDefaultClientSideAvailability(ClientSideAvailability defaultClientSideAvailability) {
        this.defaultClientSideAvailability = defaultClientSideAvailability;
    }

    public Project name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="My Project", required=true, value="A human-friendly name for the project")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public Project tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Project addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"ops\"]", required=true, value="A list of tags for the project")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Project defaultReleasePipelineKey(String defaultReleasePipelineKey) {
        this.defaultReleasePipelineKey = defaultReleasePipelineKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the default release pipeline for this project")
    public String getDefaultReleasePipelineKey() {
        return this.defaultReleasePipelineKey;
    }

    public void setDefaultReleasePipelineKey(String defaultReleasePipelineKey) {
        this.defaultReleasePipelineKey = defaultReleasePipelineKey;
    }

    public Project environments(Environments environments) {
        this.environments = environments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Environments getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Environments environments) {
        this.environments = environments;
    }

    public Project putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.links, project.links) && Objects.equals(this.id, project.id) && Objects.equals(this.key, project.key) && Objects.equals(this.includeInSnippetByDefault, project.includeInSnippetByDefault) && Objects.equals(this.defaultClientSideAvailability, project.defaultClientSideAvailability) && Objects.equals(this.name, project.name) && Objects.equals(this.access, project.access) && Objects.equals(this.tags, project.tags) && Objects.equals(this.defaultReleasePipelineKey, project.defaultReleasePipelineKey) && Objects.equals(this.environments, project.environments) && Objects.equals(this.additionalProperties, project.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.key, this.includeInSnippetByDefault, this.defaultClientSideAvailability, this.name, this.access, this.tags, this.defaultReleasePipelineKey, this.environments, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    includeInSnippetByDefault: ").append(this.toIndentedString(this.includeInSnippetByDefault)).append("\n");
        sb.append("    defaultClientSideAvailability: ").append(this.toIndentedString(this.defaultClientSideAvailability)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    defaultReleasePipelineKey: ").append(this.toIndentedString(this.defaultReleasePipelineKey)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Project is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY) != null) {
            ClientSideAvailability.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_RELEASE_PIPELINE_KEY) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_RELEASE_PIPELINE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultReleasePipelineKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_RELEASE_PIPELINE_KEY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENTS) != null) {
            Environments.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENTS));
        }
    }

    public static Project fromJson(String jsonString) throws IOException {
        return (Project)JSON.getGson().fromJson(jsonString, Project.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_INCLUDE_IN_SNIPPET_BY_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_CLIENT_SIDE_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_RELEASE_PIPELINE_KEY);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_INCLUDE_IN_SNIPPET_BY_DEFAULT);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Project.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Project.class));
            return new TypeAdapter<Project>(){

                public void write(JsonWriter out, Project value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Project read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Project.validateJsonObject(jsonObj);
                    Project instance = (Project)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

