/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.StatementPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WebhookPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_STATEMENTS = "statements";
    @SerializedName(value="statements")
    private List<StatementPost> statements = null;
    public static final String SERIALIZED_NAME_SIGN = "sign";
    @SerializedName(value="sign")
    private Boolean sign;
    public static final String SERIALIZED_NAME_ON = "on";
    @SerializedName(value="on")
    private Boolean on;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public WebhookPost name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example hook", value="A human-readable name for your webhook")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebhookPost url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="http://www.example.com", required=true, value="The URL of the remote webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookPost secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="frobozz", value="If sign is true, and the secret attribute is omitted, LaunchDarkly automatically generates a secret for you.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WebhookPost statements(List<StatementPost> statements) {
        this.statements = statements;
        return this;
    }

    public WebhookPost addStatementsItem(StatementPost statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<StatementPost>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<StatementPost> getStatements() {
        return this.statements;
    }

    public void setStatements(List<StatementPost> statements) {
        this.statements = statements;
    }

    public WebhookPost sign(Boolean sign) {
        this.sign = sign;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="If sign is false, the webhook does not include a signature header, and the secret can be omitted.")
    public Boolean getSign() {
        return this.sign;
    }

    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    public WebhookPost on(Boolean on) {
        this.on = on;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether or not this webhook is enabled.")
    public Boolean getOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public WebhookPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public WebhookPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="List of tags for this webhook")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public WebhookPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookPost webhookPost = (WebhookPost)o;
        return Objects.equals(this.name, webhookPost.name) && Objects.equals(this.url, webhookPost.url) && Objects.equals(this.secret, webhookPost.secret) && Objects.equals(this.statements, webhookPost.statements) && Objects.equals(this.sign, webhookPost.sign) && Objects.equals(this.on, webhookPost.on) && Objects.equals(this.tags, webhookPost.tags) && Objects.equals(this.additionalProperties, webhookPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.secret, this.statements, this.sign, this.on, this.tags, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    sign: ").append(this.toIndentedString(this.sign)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in WebhookPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECRET) != null && !jsonObj.get(SERIALIZED_NAME_SECRET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `secret` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECRET).toString()));
        }
        JsonArray jsonArraystatements = jsonObj.getAsJsonArray(SERIALIZED_NAME_STATEMENTS);
        if (jsonArraystatements != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATEMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `statements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATEMENTS).toString()));
            }
            for (int i = 0; i < jsonArraystatements.size(); ++i) {
                StatementPost.validateJsonObject(jsonArraystatements.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
    }

    public static WebhookPost fromJson(String jsonString) throws IOException {
        return (WebhookPost)JSON.getGson().fromJson(jsonString, WebhookPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_SECRET);
        openapiFields.add(SERIALIZED_NAME_STATEMENTS);
        openapiFields.add(SERIALIZED_NAME_SIGN);
        openapiFields.add(SERIALIZED_NAME_ON);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields.add(SERIALIZED_NAME_SIGN);
        openapiRequiredFields.add(SERIALIZED_NAME_ON);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!WebhookPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(WebhookPost.class));
            return new TypeAdapter<WebhookPost>(){

                public void write(JsonWriter out, WebhookPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public WebhookPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    WebhookPost.validateJsonObject(jsonObj);
                    WebhookPost instance = (WebhookPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

