/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.ContextAttributeNamesCollection;
import com.launchdarkly.api.model.ContextAttributeValuesCollection;
import com.launchdarkly.api.model.ContextInstanceEvaluations;
import com.launchdarkly.api.model.ContextInstanceSearch;
import com.launchdarkly.api.model.ContextInstances;
import com.launchdarkly.api.model.ContextKindsCollectionRep;
import com.launchdarkly.api.model.ContextSearch;
import com.launchdarkly.api.model.Contexts;
import com.launchdarkly.api.model.UpsertContextKindPayload;
import com.launchdarkly.api.model.UpsertResponseRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class ContextsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContextsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContextsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteContextInstancesCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/context-instances/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteContextInstancesValidateBeforeCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteContextInstances(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteContextInstances(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteContextInstances(Async)");
        }
        Call localVarCall = this.deleteContextInstancesCall(projectKey, environmentKey, id, _callback);
        return localVarCall;
    }

    public void deleteContextInstances(String projectKey, String environmentKey, String id) throws ApiException {
        this.deleteContextInstancesWithHttpInfo(projectKey, environmentKey, id);
    }

    public ApiResponse<Void> deleteContextInstancesWithHttpInfo(String projectKey, String environmentKey, String id) throws ApiException {
        Call localVarCall = this.deleteContextInstancesValidateBeforeCall(projectKey, environmentKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteContextInstancesAsync(String projectKey, String environmentKey, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteContextInstancesValidateBeforeCall(projectKey, environmentKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call evaluateContextInstanceCall(String projectKey, String environmentKey, Map<String, Object> requestBody, Long limit, Long offset, String sort, String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Map<String, Object> localVarPostBody = requestBody;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/flags/evaluate".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call evaluateContextInstanceValidateBeforeCall(String projectKey, String environmentKey, Map<String, Object> requestBody, Long limit, Long offset, String sort, String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling evaluateContextInstance(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling evaluateContextInstance(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling evaluateContextInstance(Async)");
        }
        Call localVarCall = this.evaluateContextInstanceCall(projectKey, environmentKey, requestBody, limit, offset, sort, filter, _callback);
        return localVarCall;
    }

    public ContextInstanceEvaluations evaluateContextInstance(String projectKey, String environmentKey, Map<String, Object> requestBody, Long limit, Long offset, String sort, String filter) throws ApiException {
        ApiResponse<ContextInstanceEvaluations> localVarResp = this.evaluateContextInstanceWithHttpInfo(projectKey, environmentKey, requestBody, limit, offset, sort, filter);
        return localVarResp.getData();
    }

    public ApiResponse<ContextInstanceEvaluations> evaluateContextInstanceWithHttpInfo(String projectKey, String environmentKey, Map<String, Object> requestBody, Long limit, Long offset, String sort, String filter) throws ApiException {
        Call localVarCall = this.evaluateContextInstanceValidateBeforeCall(projectKey, environmentKey, requestBody, limit, offset, sort, filter, null);
        Type localVarReturnType = new TypeToken<ContextInstanceEvaluations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call evaluateContextInstanceAsync(String projectKey, String environmentKey, Map<String, Object> requestBody, Long limit, Long offset, String sort, String filter, ApiCallback<ContextInstanceEvaluations> _callback) throws ApiException {
        Call localVarCall = this.evaluateContextInstanceValidateBeforeCall(projectKey, environmentKey, requestBody, limit, offset, sort, filter, _callback);
        Type localVarReturnType = new TypeToken<ContextInstanceEvaluations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextAttributeNamesCall(String projectKey, String environmentKey, String filter, Long limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/context-attributes".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextAttributeNamesValidateBeforeCall(String projectKey, String environmentKey, String filter, Long limit, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextAttributeNames(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContextAttributeNames(Async)");
        }
        Call localVarCall = this.getContextAttributeNamesCall(projectKey, environmentKey, filter, limit, _callback);
        return localVarCall;
    }

    public ContextAttributeNamesCollection getContextAttributeNames(String projectKey, String environmentKey, String filter, Long limit) throws ApiException {
        ApiResponse<ContextAttributeNamesCollection> localVarResp = this.getContextAttributeNamesWithHttpInfo(projectKey, environmentKey, filter, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ContextAttributeNamesCollection> getContextAttributeNamesWithHttpInfo(String projectKey, String environmentKey, String filter, Long limit) throws ApiException {
        Call localVarCall = this.getContextAttributeNamesValidateBeforeCall(projectKey, environmentKey, filter, limit, null);
        Type localVarReturnType = new TypeToken<ContextAttributeNamesCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextAttributeNamesAsync(String projectKey, String environmentKey, String filter, Long limit, ApiCallback<ContextAttributeNamesCollection> _callback) throws ApiException {
        Call localVarCall = this.getContextAttributeNamesValidateBeforeCall(projectKey, environmentKey, filter, limit, _callback);
        Type localVarReturnType = new TypeToken<ContextAttributeNamesCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextAttributeValuesCall(String projectKey, String environmentKey, String attributeName, String filter, Long limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/context-attributes/{attributeName}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{attributeName\\}", this.localVarApiClient.escapeString(attributeName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextAttributeValuesValidateBeforeCall(String projectKey, String environmentKey, String attributeName, String filter, Long limit, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextAttributeValues(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContextAttributeValues(Async)");
        }
        if (attributeName == null) {
            throw new ApiException("Missing the required parameter 'attributeName' when calling getContextAttributeValues(Async)");
        }
        Call localVarCall = this.getContextAttributeValuesCall(projectKey, environmentKey, attributeName, filter, limit, _callback);
        return localVarCall;
    }

    public ContextAttributeValuesCollection getContextAttributeValues(String projectKey, String environmentKey, String attributeName, String filter, Long limit) throws ApiException {
        ApiResponse<ContextAttributeValuesCollection> localVarResp = this.getContextAttributeValuesWithHttpInfo(projectKey, environmentKey, attributeName, filter, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ContextAttributeValuesCollection> getContextAttributeValuesWithHttpInfo(String projectKey, String environmentKey, String attributeName, String filter, Long limit) throws ApiException {
        Call localVarCall = this.getContextAttributeValuesValidateBeforeCall(projectKey, environmentKey, attributeName, filter, limit, null);
        Type localVarReturnType = new TypeToken<ContextAttributeValuesCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextAttributeValuesAsync(String projectKey, String environmentKey, String attributeName, String filter, Long limit, ApiCallback<ContextAttributeValuesCollection> _callback) throws ApiException {
        Call localVarCall = this.getContextAttributeValuesValidateBeforeCall(projectKey, environmentKey, attributeName, filter, limit, _callback);
        Type localVarReturnType = new TypeToken<ContextAttributeValuesCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextInstancesCall(String projectKey, String environmentKey, String id, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/context-instances/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (continuationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continuationToken", continuationToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (includeTotalCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotalCount", includeTotalCount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextInstancesValidateBeforeCall(String projectKey, String environmentKey, String id, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextInstances(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContextInstances(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getContextInstances(Async)");
        }
        Call localVarCall = this.getContextInstancesCall(projectKey, environmentKey, id, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        return localVarCall;
    }

    public ContextInstances getContextInstances(String projectKey, String environmentKey, String id, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        ApiResponse<ContextInstances> localVarResp = this.getContextInstancesWithHttpInfo(projectKey, environmentKey, id, limit, continuationToken, sort, filter, includeTotalCount);
        return localVarResp.getData();
    }

    public ApiResponse<ContextInstances> getContextInstancesWithHttpInfo(String projectKey, String environmentKey, String id, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        Call localVarCall = this.getContextInstancesValidateBeforeCall(projectKey, environmentKey, id, limit, continuationToken, sort, filter, includeTotalCount, null);
        Type localVarReturnType = new TypeToken<ContextInstances>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextInstancesAsync(String projectKey, String environmentKey, String id, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback<ContextInstances> _callback) throws ApiException {
        Call localVarCall = this.getContextInstancesValidateBeforeCall(projectKey, environmentKey, id, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        Type localVarReturnType = new TypeToken<ContextInstances>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextKindsByProjectKeyCall(String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/context-kinds".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextKindsByProjectKeyValidateBeforeCall(String projectKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextKindsByProjectKey(Async)");
        }
        Call localVarCall = this.getContextKindsByProjectKeyCall(projectKey, _callback);
        return localVarCall;
    }

    public ContextKindsCollectionRep getContextKindsByProjectKey(String projectKey) throws ApiException {
        ApiResponse<ContextKindsCollectionRep> localVarResp = this.getContextKindsByProjectKeyWithHttpInfo(projectKey);
        return localVarResp.getData();
    }

    public ApiResponse<ContextKindsCollectionRep> getContextKindsByProjectKeyWithHttpInfo(String projectKey) throws ApiException {
        Call localVarCall = this.getContextKindsByProjectKeyValidateBeforeCall(projectKey, null);
        Type localVarReturnType = new TypeToken<ContextKindsCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextKindsByProjectKeyAsync(String projectKey, ApiCallback<ContextKindsCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getContextKindsByProjectKeyValidateBeforeCall(projectKey, _callback);
        Type localVarReturnType = new TypeToken<ContextKindsCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextsCall(String projectKey, String environmentKey, String kind, String key, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/contexts/{kind}/{key}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{kind\\}", this.localVarApiClient.escapeString(kind.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (continuationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continuationToken", continuationToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (includeTotalCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotalCount", includeTotalCount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextsValidateBeforeCall(String projectKey, String environmentKey, String kind, String key, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContexts(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContexts(Async)");
        }
        if (kind == null) {
            throw new ApiException("Missing the required parameter 'kind' when calling getContexts(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getContexts(Async)");
        }
        Call localVarCall = this.getContextsCall(projectKey, environmentKey, kind, key, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        return localVarCall;
    }

    public Contexts getContexts(String projectKey, String environmentKey, String kind, String key, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        ApiResponse<Contexts> localVarResp = this.getContextsWithHttpInfo(projectKey, environmentKey, kind, key, limit, continuationToken, sort, filter, includeTotalCount);
        return localVarResp.getData();
    }

    public ApiResponse<Contexts> getContextsWithHttpInfo(String projectKey, String environmentKey, String kind, String key, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        Call localVarCall = this.getContextsValidateBeforeCall(projectKey, environmentKey, kind, key, limit, continuationToken, sort, filter, includeTotalCount, null);
        Type localVarReturnType = new TypeToken<Contexts>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextsAsync(String projectKey, String environmentKey, String kind, String key, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback<Contexts> _callback) throws ApiException {
        Call localVarCall = this.getContextsValidateBeforeCall(projectKey, environmentKey, kind, key, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        Type localVarReturnType = new TypeToken<Contexts>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putContextKindCall(String projectKey, String key, UpsertContextKindPayload upsertContextKindPayload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpsertContextKindPayload localVarPostBody = upsertContextKindPayload;
        String localVarPath = "/api/v2/projects/{projectKey}/context-kinds/{key}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putContextKindValidateBeforeCall(String projectKey, String key, UpsertContextKindPayload upsertContextKindPayload, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putContextKind(Async)");
        }
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling putContextKind(Async)");
        }
        if (upsertContextKindPayload == null) {
            throw new ApiException("Missing the required parameter 'upsertContextKindPayload' when calling putContextKind(Async)");
        }
        Call localVarCall = this.putContextKindCall(projectKey, key, upsertContextKindPayload, _callback);
        return localVarCall;
    }

    public UpsertResponseRep putContextKind(String projectKey, String key, UpsertContextKindPayload upsertContextKindPayload) throws ApiException {
        ApiResponse<UpsertResponseRep> localVarResp = this.putContextKindWithHttpInfo(projectKey, key, upsertContextKindPayload);
        return localVarResp.getData();
    }

    public ApiResponse<UpsertResponseRep> putContextKindWithHttpInfo(String projectKey, String key, UpsertContextKindPayload upsertContextKindPayload) throws ApiException {
        Call localVarCall = this.putContextKindValidateBeforeCall(projectKey, key, upsertContextKindPayload, null);
        Type localVarReturnType = new TypeToken<UpsertResponseRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putContextKindAsync(String projectKey, String key, UpsertContextKindPayload upsertContextKindPayload, ApiCallback<UpsertResponseRep> _callback) throws ApiException {
        Call localVarCall = this.putContextKindValidateBeforeCall(projectKey, key, upsertContextKindPayload, _callback);
        Type localVarReturnType = new TypeToken<UpsertResponseRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchContextInstancesCall(String projectKey, String environmentKey, ContextInstanceSearch contextInstanceSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ContextInstanceSearch localVarPostBody = contextInstanceSearch;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/context-instances/search".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (continuationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continuationToken", continuationToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (includeTotalCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotalCount", includeTotalCount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call searchContextInstancesValidateBeforeCall(String projectKey, String environmentKey, ContextInstanceSearch contextInstanceSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling searchContextInstances(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling searchContextInstances(Async)");
        }
        if (contextInstanceSearch == null) {
            throw new ApiException("Missing the required parameter 'contextInstanceSearch' when calling searchContextInstances(Async)");
        }
        Call localVarCall = this.searchContextInstancesCall(projectKey, environmentKey, contextInstanceSearch, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        return localVarCall;
    }

    public ContextInstances searchContextInstances(String projectKey, String environmentKey, ContextInstanceSearch contextInstanceSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        ApiResponse<ContextInstances> localVarResp = this.searchContextInstancesWithHttpInfo(projectKey, environmentKey, contextInstanceSearch, limit, continuationToken, sort, filter, includeTotalCount);
        return localVarResp.getData();
    }

    public ApiResponse<ContextInstances> searchContextInstancesWithHttpInfo(String projectKey, String environmentKey, ContextInstanceSearch contextInstanceSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        Call localVarCall = this.searchContextInstancesValidateBeforeCall(projectKey, environmentKey, contextInstanceSearch, limit, continuationToken, sort, filter, includeTotalCount, null);
        Type localVarReturnType = new TypeToken<ContextInstances>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call searchContextInstancesAsync(String projectKey, String environmentKey, ContextInstanceSearch contextInstanceSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback<ContextInstances> _callback) throws ApiException {
        Call localVarCall = this.searchContextInstancesValidateBeforeCall(projectKey, environmentKey, contextInstanceSearch, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        Type localVarReturnType = new TypeToken<ContextInstances>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call searchContextsCall(String projectKey, String environmentKey, ContextSearch contextSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ContextSearch localVarPostBody = contextSearch;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/contexts/search".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (continuationToken != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continuationToken", continuationToken));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (includeTotalCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeTotalCount", includeTotalCount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call searchContextsValidateBeforeCall(String projectKey, String environmentKey, ContextSearch contextSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling searchContexts(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling searchContexts(Async)");
        }
        if (contextSearch == null) {
            throw new ApiException("Missing the required parameter 'contextSearch' when calling searchContexts(Async)");
        }
        Call localVarCall = this.searchContextsCall(projectKey, environmentKey, contextSearch, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        return localVarCall;
    }

    public Contexts searchContexts(String projectKey, String environmentKey, ContextSearch contextSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        ApiResponse<Contexts> localVarResp = this.searchContextsWithHttpInfo(projectKey, environmentKey, contextSearch, limit, continuationToken, sort, filter, includeTotalCount);
        return localVarResp.getData();
    }

    public ApiResponse<Contexts> searchContextsWithHttpInfo(String projectKey, String environmentKey, ContextSearch contextSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount) throws ApiException {
        Call localVarCall = this.searchContextsValidateBeforeCall(projectKey, environmentKey, contextSearch, limit, continuationToken, sort, filter, includeTotalCount, null);
        Type localVarReturnType = new TypeToken<Contexts>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call searchContextsAsync(String projectKey, String environmentKey, ContextSearch contextSearch, Long limit, String continuationToken, String sort, String filter, Boolean includeTotalCount, ApiCallback<Contexts> _callback) throws ApiException {
        Call localVarCall = this.searchContextsValidateBeforeCall(projectKey, environmentKey, contextSearch, limit, continuationToken, sort, filter, includeTotalCount, _callback);
        Type localVarReturnType = new TypeToken<Contexts>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

