/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.FlagTriggerInput;
import com.launchdarkly.api.model.TriggerPost;
import com.launchdarkly.api.model.TriggerWorkflowCollectionRep;
import com.launchdarkly.api.model.TriggerWorkflowRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class FlagTriggersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FlagTriggersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlagTriggersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTriggerWorkflowCall(String projectKey, String environmentKey, String featureFlagKey, TriggerPost triggerPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TriggerPost localVarPostBody = triggerPost;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTriggerWorkflowValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, TriggerPost triggerPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling createTriggerWorkflow(Async)");
        }
        if (triggerPost == null) {
            throw new ApiException("Missing the required parameter 'triggerPost' when calling createTriggerWorkflow(Async)");
        }
        Call localVarCall = this.createTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, triggerPost, _callback);
        return localVarCall;
    }

    public TriggerWorkflowRep createTriggerWorkflow(String projectKey, String environmentKey, String featureFlagKey, TriggerPost triggerPost) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.createTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, triggerPost);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> createTriggerWorkflowWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, TriggerPost triggerPost) throws ApiException {
        Call localVarCall = this.createTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, triggerPost, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTriggerWorkflowAsync(String projectKey, String environmentKey, String featureFlagKey, TriggerPost triggerPost, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.createTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, triggerPost, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTriggerWorkflowCall(String projectKey, String environmentKey, String featureFlagKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTriggerWorkflowValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTriggerWorkflow(Async)");
        }
        Call localVarCall = this.deleteTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, id, _callback);
        return localVarCall;
    }

    public void deleteTriggerWorkflow(String projectKey, String environmentKey, String featureFlagKey, String id) throws ApiException {
        this.deleteTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, id);
    }

    public ApiResponse<Void> deleteTriggerWorkflowWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, String id) throws ApiException {
        Call localVarCall = this.deleteTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTriggerWorkflowAsync(String projectKey, String environmentKey, String featureFlagKey, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTriggerWorkflowByIdCall(String projectKey, String featureFlagKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTriggerWorkflowByIdValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getTriggerWorkflowById(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getTriggerWorkflowById(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getTriggerWorkflowById(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTriggerWorkflowById(Async)");
        }
        Call localVarCall = this.getTriggerWorkflowByIdCall(projectKey, featureFlagKey, environmentKey, id, _callback);
        return localVarCall;
    }

    public TriggerWorkflowRep getTriggerWorkflowById(String projectKey, String featureFlagKey, String environmentKey, String id) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.getTriggerWorkflowByIdWithHttpInfo(projectKey, featureFlagKey, environmentKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> getTriggerWorkflowByIdWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String id) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowByIdValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTriggerWorkflowByIdAsync(String projectKey, String featureFlagKey, String environmentKey, String id, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowByIdValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTriggerWorkflowsCall(String projectKey, String environmentKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTriggerWorkflowsValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getTriggerWorkflows(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getTriggerWorkflows(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getTriggerWorkflows(Async)");
        }
        Call localVarCall = this.getTriggerWorkflowsCall(projectKey, environmentKey, featureFlagKey, _callback);
        return localVarCall;
    }

    public TriggerWorkflowCollectionRep getTriggerWorkflows(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<TriggerWorkflowCollectionRep> localVarResp = this.getTriggerWorkflowsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowCollectionRep> getTriggerWorkflowsWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTriggerWorkflowsAsync(String projectKey, String environmentKey, String featureFlagKey, ApiCallback<TriggerWorkflowCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchTriggerWorkflowCall(String projectKey, String environmentKey, String featureFlagKey, String id, FlagTriggerInput flagTriggerInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagTriggerInput localVarPostBody = flagTriggerInput;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchTriggerWorkflowValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, String id, FlagTriggerInput flagTriggerInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchTriggerWorkflow(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchTriggerWorkflow(Async)");
        }
        if (flagTriggerInput == null) {
            throw new ApiException("Missing the required parameter 'flagTriggerInput' when calling patchTriggerWorkflow(Async)");
        }
        Call localVarCall = this.patchTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, _callback);
        return localVarCall;
    }

    public TriggerWorkflowRep patchTriggerWorkflow(String projectKey, String environmentKey, String featureFlagKey, String id, FlagTriggerInput flagTriggerInput) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.patchTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> patchTriggerWorkflowWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, String id, FlagTriggerInput flagTriggerInput) throws ApiException {
        Call localVarCall = this.patchTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchTriggerWorkflowAsync(String projectKey, String environmentKey, String featureFlagKey, String id, FlagTriggerInput flagTriggerInput, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.patchTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

