/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.DeploymentCollectionRep;
import com.launchdarkly.api.model.DeploymentRep;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.PostDeploymentEventInput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InsightsDeploymentsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InsightsDeploymentsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightsDeploymentsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createDeploymentEventCall(PostDeploymentEventInput postDeploymentEventInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostDeploymentEventInput localVarPostBody = postDeploymentEventInput;
        String localVarPath = "/api/v2/engineering-insights/deployment-events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeploymentEventValidateBeforeCall(PostDeploymentEventInput postDeploymentEventInput, ApiCallback _callback) throws ApiException {
        if (postDeploymentEventInput == null) {
            throw new ApiException("Missing the required parameter 'postDeploymentEventInput' when calling createDeploymentEvent(Async)");
        }
        Call localVarCall = this.createDeploymentEventCall(postDeploymentEventInput, _callback);
        return localVarCall;
    }

    public void createDeploymentEvent(PostDeploymentEventInput postDeploymentEventInput) throws ApiException {
        this.createDeploymentEventWithHttpInfo(postDeploymentEventInput);
    }

    public ApiResponse<Void> createDeploymentEventWithHttpInfo(PostDeploymentEventInput postDeploymentEventInput) throws ApiException {
        Call localVarCall = this.createDeploymentEventValidateBeforeCall(postDeploymentEventInput, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createDeploymentEventAsync(PostDeploymentEventInput postDeploymentEventInput, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createDeploymentEventValidateBeforeCall(postDeploymentEventInput, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getDeploymentCall(String deploymentID, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/deployments/{deploymentID}".replaceAll("\\{deploymentID\\}", this.localVarApiClient.escapeString(deploymentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentValidateBeforeCall(String deploymentID, String expand, ApiCallback _callback) throws ApiException {
        if (deploymentID == null) {
            throw new ApiException("Missing the required parameter 'deploymentID' when calling getDeployment(Async)");
        }
        Call localVarCall = this.getDeploymentCall(deploymentID, expand, _callback);
        return localVarCall;
    }

    public DeploymentRep getDeployment(String deploymentID, String expand) throws ApiException {
        ApiResponse<DeploymentRep> localVarResp = this.getDeploymentWithHttpInfo(deploymentID, expand);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentRep> getDeploymentWithHttpInfo(String deploymentID, String expand) throws ApiException {
        Call localVarCall = this.getDeploymentValidateBeforeCall(deploymentID, expand, null);
        Type localVarReturnType = new TypeToken<DeploymentRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentAsync(String deploymentID, String expand, ApiCallback<DeploymentRep> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentValidateBeforeCall(deploymentID, expand, _callback);
        Type localVarReturnType = new TypeToken<DeploymentRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentsCall(String projectKey, String environmentKey, String applicationKey, Long limit, String expand, Long from, Long to, String after, String before, String kind, String status, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/deployments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (projectKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projectKey", projectKey));
        }
        if (environmentKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentKey", environmentKey));
        }
        if (applicationKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("applicationKey", applicationKey));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("before", before));
        }
        if (kind != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("kind", kind));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentsValidateBeforeCall(String projectKey, String environmentKey, String applicationKey, Long limit, String expand, Long from, Long to, String after, String before, String kind, String status, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getDeployments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getDeployments(Async)");
        }
        Call localVarCall = this.getDeploymentsCall(projectKey, environmentKey, applicationKey, limit, expand, from, to, after, before, kind, status, _callback);
        return localVarCall;
    }

    public DeploymentCollectionRep getDeployments(String projectKey, String environmentKey, String applicationKey, Long limit, String expand, Long from, Long to, String after, String before, String kind, String status) throws ApiException {
        ApiResponse<DeploymentCollectionRep> localVarResp = this.getDeploymentsWithHttpInfo(projectKey, environmentKey, applicationKey, limit, expand, from, to, after, before, kind, status);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentCollectionRep> getDeploymentsWithHttpInfo(String projectKey, String environmentKey, String applicationKey, Long limit, String expand, Long from, Long to, String after, String before, String kind, String status) throws ApiException {
        Call localVarCall = this.getDeploymentsValidateBeforeCall(projectKey, environmentKey, applicationKey, limit, expand, from, to, after, before, kind, status, null);
        Type localVarReturnType = new TypeToken<DeploymentCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentsAsync(String projectKey, String environmentKey, String applicationKey, Long limit, String expand, Long from, Long to, String after, String before, String kind, String status, ApiCallback<DeploymentCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentsValidateBeforeCall(projectKey, environmentKey, applicationKey, limit, expand, from, to, after, before, kind, status, _callback);
        Type localVarReturnType = new TypeToken<DeploymentCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDeploymentCall(String deploymentID, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/engineering-insights/deployments/{deploymentID}".replaceAll("\\{deploymentID\\}", this.localVarApiClient.escapeString(deploymentID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDeploymentValidateBeforeCall(String deploymentID, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (deploymentID == null) {
            throw new ApiException("Missing the required parameter 'deploymentID' when calling updateDeployment(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling updateDeployment(Async)");
        }
        Call localVarCall = this.updateDeploymentCall(deploymentID, patchOperation, _callback);
        return localVarCall;
    }

    public DeploymentRep updateDeployment(String deploymentID, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<DeploymentRep> localVarResp = this.updateDeploymentWithHttpInfo(deploymentID, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentRep> updateDeploymentWithHttpInfo(String deploymentID, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.updateDeploymentValidateBeforeCall(deploymentID, patchOperation, null);
        Type localVarReturnType = new TypeToken<DeploymentRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDeploymentAsync(String deploymentID, List<PatchOperation> patchOperation, ApiCallback<DeploymentRep> _callback) throws ApiException {
        Call localVarCall = this.updateDeploymentValidateBeforeCall(deploymentID, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<DeploymentRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

