/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.IntegrationConfigurationCollectionRep;
import com.launchdarkly.api.model.IntegrationConfigurationPost;
import com.launchdarkly.api.model.IntegrationConfigurationsRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class IntegrationsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IntegrationsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIntegrationConfigurationCall(String integrationKey, IntegrationConfigurationPost integrationConfigurationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IntegrationConfigurationPost localVarPostBody = integrationConfigurationPost;
        String localVarPath = "/api/v2/integration-configurations/keys/{integrationKey}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIntegrationConfigurationValidateBeforeCall(String integrationKey, IntegrationConfigurationPost integrationConfigurationPost, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling createIntegrationConfiguration(Async)");
        }
        if (integrationConfigurationPost == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationPost' when calling createIntegrationConfiguration(Async)");
        }
        Call localVarCall = this.createIntegrationConfigurationCall(integrationKey, integrationConfigurationPost, _callback);
        return localVarCall;
    }

    public IntegrationConfigurationsRep createIntegrationConfiguration(String integrationKey, IntegrationConfigurationPost integrationConfigurationPost) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.createIntegrationConfigurationWithHttpInfo(integrationKey, integrationConfigurationPost);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> createIntegrationConfigurationWithHttpInfo(String integrationKey, IntegrationConfigurationPost integrationConfigurationPost) throws ApiException {
        Call localVarCall = this.createIntegrationConfigurationValidateBeforeCall(integrationKey, integrationConfigurationPost, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIntegrationConfigurationAsync(String integrationKey, IntegrationConfigurationPost integrationConfigurationPost, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.createIntegrationConfigurationValidateBeforeCall(integrationKey, integrationConfigurationPost, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIntegrationConfigurationCall(String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replaceAll("\\{integrationConfigurationId\\}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIntegrationConfigurationValidateBeforeCall(String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling deleteIntegrationConfiguration(Async)");
        }
        Call localVarCall = this.deleteIntegrationConfigurationCall(integrationConfigurationId, _callback);
        return localVarCall;
    }

    public void deleteIntegrationConfiguration(String integrationConfigurationId) throws ApiException {
        this.deleteIntegrationConfigurationWithHttpInfo(integrationConfigurationId);
    }

    public ApiResponse<Void> deleteIntegrationConfigurationWithHttpInfo(String integrationConfigurationId) throws ApiException {
        Call localVarCall = this.deleteIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIntegrationConfigurationAsync(String integrationConfigurationId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllIntegrationConfigurationsCall(String integrationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/keys/{integrationKey}".replaceAll("\\{integrationKey\\}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllIntegrationConfigurationsValidateBeforeCall(String integrationKey, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getAllIntegrationConfigurations(Async)");
        }
        Call localVarCall = this.getAllIntegrationConfigurationsCall(integrationKey, _callback);
        return localVarCall;
    }

    public IntegrationConfigurationCollectionRep getAllIntegrationConfigurations(String integrationKey) throws ApiException {
        ApiResponse<IntegrationConfigurationCollectionRep> localVarResp = this.getAllIntegrationConfigurationsWithHttpInfo(integrationKey);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationCollectionRep> getAllIntegrationConfigurationsWithHttpInfo(String integrationKey) throws ApiException {
        Call localVarCall = this.getAllIntegrationConfigurationsValidateBeforeCall(integrationKey, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllIntegrationConfigurationsAsync(String integrationKey, ApiCallback<IntegrationConfigurationCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getAllIntegrationConfigurationsValidateBeforeCall(integrationKey, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIntegrationConfigurationCall(String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replaceAll("\\{integrationConfigurationId\\}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIntegrationConfigurationValidateBeforeCall(String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling getIntegrationConfiguration(Async)");
        }
        Call localVarCall = this.getIntegrationConfigurationCall(integrationConfigurationId, _callback);
        return localVarCall;
    }

    public IntegrationConfigurationsRep getIntegrationConfiguration(String integrationConfigurationId) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.getIntegrationConfigurationWithHttpInfo(integrationConfigurationId);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> getIntegrationConfigurationWithHttpInfo(String integrationConfigurationId) throws ApiException {
        Call localVarCall = this.getIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIntegrationConfigurationAsync(String integrationConfigurationId, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.getIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIntegrationConfigurationCall(String integrationConfigurationId, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replaceAll("\\{integrationConfigurationId\\}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIntegrationConfigurationValidateBeforeCall(String integrationConfigurationId, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling updateIntegrationConfiguration(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling updateIntegrationConfiguration(Async)");
        }
        Call localVarCall = this.updateIntegrationConfigurationCall(integrationConfigurationId, patchOperation, _callback);
        return localVarCall;
    }

    public IntegrationConfigurationsRep updateIntegrationConfiguration(String integrationConfigurationId, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.updateIntegrationConfigurationWithHttpInfo(integrationConfigurationId, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> updateIntegrationConfigurationWithHttpInfo(String integrationConfigurationId, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.updateIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, patchOperation, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIntegrationConfigurationAsync(String integrationConfigurationId, List<PatchOperation> patchOperation, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.updateIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

