/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.FlagDefaultsRep;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.Project;
import com.launchdarkly.api.model.ProjectPost;
import com.launchdarkly.api.model.ProjectRep;
import com.launchdarkly.api.model.Projects;
import com.launchdarkly.api.model.UpsertFlagDefaultsPayload;
import com.launchdarkly.api.model.UpsertPayloadRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ProjectsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteProjectCall(String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProjectValidateBeforeCall(String projectKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteProject(Async)");
        }
        Call localVarCall = this.deleteProjectCall(projectKey, _callback);
        return localVarCall;
    }

    public void deleteProject(String projectKey) throws ApiException {
        this.deleteProjectWithHttpInfo(projectKey);
    }

    public ApiResponse<Void> deleteProjectWithHttpInfo(String projectKey) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(projectKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProjectAsync(String projectKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProjectValidateBeforeCall(projectKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getFlagDefaultsByProjectCall(String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flag-defaults".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFlagDefaultsByProjectValidateBeforeCall(String projectKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagDefaultsByProject(Async)");
        }
        Call localVarCall = this.getFlagDefaultsByProjectCall(projectKey, _callback);
        return localVarCall;
    }

    public FlagDefaultsRep getFlagDefaultsByProject(String projectKey) throws ApiException {
        ApiResponse<FlagDefaultsRep> localVarResp = this.getFlagDefaultsByProjectWithHttpInfo(projectKey);
        return localVarResp.getData();
    }

    public ApiResponse<FlagDefaultsRep> getFlagDefaultsByProjectWithHttpInfo(String projectKey) throws ApiException {
        Call localVarCall = this.getFlagDefaultsByProjectValidateBeforeCall(projectKey, null);
        Type localVarReturnType = new TypeToken<FlagDefaultsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFlagDefaultsByProjectAsync(String projectKey, ApiCallback<FlagDefaultsRep> _callback) throws ApiException {
        Call localVarCall = this.getFlagDefaultsByProjectValidateBeforeCall(projectKey, _callback);
        Type localVarReturnType = new TypeToken<FlagDefaultsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectCall(String projectKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectValidateBeforeCall(String projectKey, String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getProject(Async)");
        }
        Call localVarCall = this.getProjectCall(projectKey, expand, _callback);
        return localVarCall;
    }

    public Project getProject(String projectKey, String expand) throws ApiException {
        ApiResponse<Project> localVarResp = this.getProjectWithHttpInfo(projectKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Project> getProjectWithHttpInfo(String projectKey, String expand) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(projectKey, expand, null);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectAsync(String projectKey, String expand, ApiCallback<Project> _callback) throws ApiException {
        Call localVarCall = this.getProjectValidateBeforeCall(projectKey, expand, _callback);
        Type localVarReturnType = new TypeToken<Project>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProjectsCall(Long limit, Long offset, String filter, String sort, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProjectsValidateBeforeCall(Long limit, Long offset, String filter, String sort, String expand, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProjectsCall(limit, offset, filter, sort, expand, _callback);
        return localVarCall;
    }

    public Projects getProjects(Long limit, Long offset, String filter, String sort, String expand) throws ApiException {
        ApiResponse<Projects> localVarResp = this.getProjectsWithHttpInfo(limit, offset, filter, sort, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Projects> getProjectsWithHttpInfo(Long limit, Long offset, String filter, String sort, String expand) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(limit, offset, filter, sort, expand, null);
        Type localVarReturnType = new TypeToken<Projects>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProjectsAsync(Long limit, Long offset, String filter, String sort, String expand, ApiCallback<Projects> _callback) throws ApiException {
        Call localVarCall = this.getProjectsValidateBeforeCall(limit, offset, filter, sort, expand, _callback);
        Type localVarReturnType = new TypeToken<Projects>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlagDefaultsByProjectCall(String projectKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/projects/{projectKey}/flag-defaults".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlagDefaultsByProjectValidateBeforeCall(String projectKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFlagDefaultsByProject(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchFlagDefaultsByProject(Async)");
        }
        Call localVarCall = this.patchFlagDefaultsByProjectCall(projectKey, patchOperation, _callback);
        return localVarCall;
    }

    public UpsertPayloadRep patchFlagDefaultsByProject(String projectKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<UpsertPayloadRep> localVarResp = this.patchFlagDefaultsByProjectWithHttpInfo(projectKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<UpsertPayloadRep> patchFlagDefaultsByProjectWithHttpInfo(String projectKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchFlagDefaultsByProjectValidateBeforeCall(projectKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<UpsertPayloadRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlagDefaultsByProjectAsync(String projectKey, List<PatchOperation> patchOperation, ApiCallback<UpsertPayloadRep> _callback) throws ApiException {
        Call localVarCall = this.patchFlagDefaultsByProjectValidateBeforeCall(projectKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<UpsertPayloadRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchProjectCall(String projectKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/projects/{projectKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchProjectValidateBeforeCall(String projectKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchProject(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchProject(Async)");
        }
        Call localVarCall = this.patchProjectCall(projectKey, patchOperation, _callback);
        return localVarCall;
    }

    public ProjectRep patchProject(String projectKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<ProjectRep> localVarResp = this.patchProjectWithHttpInfo(projectKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectRep> patchProjectWithHttpInfo(String projectKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchProjectValidateBeforeCall(projectKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<ProjectRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchProjectAsync(String projectKey, List<PatchOperation> patchOperation, ApiCallback<ProjectRep> _callback) throws ApiException {
        Call localVarCall = this.patchProjectValidateBeforeCall(projectKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<ProjectRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postProjectCall(ProjectPost projectPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ProjectPost localVarPostBody = projectPost;
        String localVarPath = "/api/v2/projects";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postProjectValidateBeforeCall(ProjectPost projectPost, ApiCallback _callback) throws ApiException {
        if (projectPost == null) {
            throw new ApiException("Missing the required parameter 'projectPost' when calling postProject(Async)");
        }
        Call localVarCall = this.postProjectCall(projectPost, _callback);
        return localVarCall;
    }

    public ProjectRep postProject(ProjectPost projectPost) throws ApiException {
        ApiResponse<ProjectRep> localVarResp = this.postProjectWithHttpInfo(projectPost);
        return localVarResp.getData();
    }

    public ApiResponse<ProjectRep> postProjectWithHttpInfo(ProjectPost projectPost) throws ApiException {
        Call localVarCall = this.postProjectValidateBeforeCall(projectPost, null);
        Type localVarReturnType = new TypeToken<ProjectRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postProjectAsync(ProjectPost projectPost, ApiCallback<ProjectRep> _callback) throws ApiException {
        Call localVarCall = this.postProjectValidateBeforeCall(projectPost, _callback);
        Type localVarReturnType = new TypeToken<ProjectRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putFlagDefaultsByProjectCall(String projectKey, UpsertFlagDefaultsPayload upsertFlagDefaultsPayload, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpsertFlagDefaultsPayload localVarPostBody = upsertFlagDefaultsPayload;
        String localVarPath = "/api/v2/projects/{projectKey}/flag-defaults".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putFlagDefaultsByProjectValidateBeforeCall(String projectKey, UpsertFlagDefaultsPayload upsertFlagDefaultsPayload, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putFlagDefaultsByProject(Async)");
        }
        if (upsertFlagDefaultsPayload == null) {
            throw new ApiException("Missing the required parameter 'upsertFlagDefaultsPayload' when calling putFlagDefaultsByProject(Async)");
        }
        Call localVarCall = this.putFlagDefaultsByProjectCall(projectKey, upsertFlagDefaultsPayload, _callback);
        return localVarCall;
    }

    public UpsertPayloadRep putFlagDefaultsByProject(String projectKey, UpsertFlagDefaultsPayload upsertFlagDefaultsPayload) throws ApiException {
        ApiResponse<UpsertPayloadRep> localVarResp = this.putFlagDefaultsByProjectWithHttpInfo(projectKey, upsertFlagDefaultsPayload);
        return localVarResp.getData();
    }

    public ApiResponse<UpsertPayloadRep> putFlagDefaultsByProjectWithHttpInfo(String projectKey, UpsertFlagDefaultsPayload upsertFlagDefaultsPayload) throws ApiException {
        Call localVarCall = this.putFlagDefaultsByProjectValidateBeforeCall(projectKey, upsertFlagDefaultsPayload, null);
        Type localVarReturnType = new TypeToken<UpsertPayloadRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putFlagDefaultsByProjectAsync(String projectKey, UpsertFlagDefaultsPayload upsertFlagDefaultsPayload, ApiCallback<UpsertPayloadRep> _callback) throws ApiException {
        Call localVarCall = this.putFlagDefaultsByProjectValidateBeforeCall(projectKey, upsertFlagDefaultsPayload, _callback);
        Type localVarReturnType = new TypeToken<UpsertPayloadRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

