/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Team;
import com.launchdarkly.api.model.TeamCustomRoles;
import com.launchdarkly.api.model.TeamImportsRep;
import com.launchdarkly.api.model.TeamMaintainers;
import com.launchdarkly.api.model.TeamPatchInput;
import com.launchdarkly.api.model.TeamPostInput;
import com.launchdarkly.api.model.Teams;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TeamsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TeamsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TeamsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteTeamCall(String teamKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams/{teamKey}".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTeamValidateBeforeCall(String teamKey, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling deleteTeam(Async)");
        }
        Call localVarCall = this.deleteTeamCall(teamKey, _callback);
        return localVarCall;
    }

    public void deleteTeam(String teamKey) throws ApiException {
        this.deleteTeamWithHttpInfo(teamKey);
    }

    public ApiResponse<Void> deleteTeamWithHttpInfo(String teamKey) throws ApiException {
        Call localVarCall = this.deleteTeamValidateBeforeCall(teamKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTeamAsync(String teamKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTeamValidateBeforeCall(teamKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTeamCall(String teamKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams/{teamKey}".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTeamValidateBeforeCall(String teamKey, String expand, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling getTeam(Async)");
        }
        Call localVarCall = this.getTeamCall(teamKey, expand, _callback);
        return localVarCall;
    }

    public Team getTeam(String teamKey, String expand) throws ApiException {
        ApiResponse<Team> localVarResp = this.getTeamWithHttpInfo(teamKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Team> getTeamWithHttpInfo(String teamKey, String expand) throws ApiException {
        Call localVarCall = this.getTeamValidateBeforeCall(teamKey, expand, null);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTeamAsync(String teamKey, String expand, ApiCallback<Team> _callback) throws ApiException {
        Call localVarCall = this.getTeamValidateBeforeCall(teamKey, expand, _callback);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTeamMaintainersCall(String teamKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams/{teamKey}/maintainers".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTeamMaintainersValidateBeforeCall(String teamKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling getTeamMaintainers(Async)");
        }
        Call localVarCall = this.getTeamMaintainersCall(teamKey, limit, offset, _callback);
        return localVarCall;
    }

    public TeamMaintainers getTeamMaintainers(String teamKey, Long limit, Long offset) throws ApiException {
        ApiResponse<TeamMaintainers> localVarResp = this.getTeamMaintainersWithHttpInfo(teamKey, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<TeamMaintainers> getTeamMaintainersWithHttpInfo(String teamKey, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getTeamMaintainersValidateBeforeCall(teamKey, limit, offset, null);
        Type localVarReturnType = new TypeToken<TeamMaintainers>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTeamMaintainersAsync(String teamKey, Long limit, Long offset, ApiCallback<TeamMaintainers> _callback) throws ApiException {
        Call localVarCall = this.getTeamMaintainersValidateBeforeCall(teamKey, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<TeamMaintainers>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTeamRolesCall(String teamKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams/{teamKey}/roles".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTeamRolesValidateBeforeCall(String teamKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling getTeamRoles(Async)");
        }
        Call localVarCall = this.getTeamRolesCall(teamKey, limit, offset, _callback);
        return localVarCall;
    }

    public TeamCustomRoles getTeamRoles(String teamKey, Long limit, Long offset) throws ApiException {
        ApiResponse<TeamCustomRoles> localVarResp = this.getTeamRolesWithHttpInfo(teamKey, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<TeamCustomRoles> getTeamRolesWithHttpInfo(String teamKey, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getTeamRolesValidateBeforeCall(teamKey, limit, offset, null);
        Type localVarReturnType = new TypeToken<TeamCustomRoles>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTeamRolesAsync(String teamKey, Long limit, Long offset, ApiCallback<TeamCustomRoles> _callback) throws ApiException {
        Call localVarCall = this.getTeamRolesValidateBeforeCall(teamKey, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<TeamCustomRoles>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTeamsCall(Long limit, Long offset, String filter, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTeamsValidateBeforeCall(Long limit, Long offset, String filter, String expand, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTeamsCall(limit, offset, filter, expand, _callback);
        return localVarCall;
    }

    public Teams getTeams(Long limit, Long offset, String filter, String expand) throws ApiException {
        ApiResponse<Teams> localVarResp = this.getTeamsWithHttpInfo(limit, offset, filter, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Teams> getTeamsWithHttpInfo(Long limit, Long offset, String filter, String expand) throws ApiException {
        Call localVarCall = this.getTeamsValidateBeforeCall(limit, offset, filter, expand, null);
        Type localVarReturnType = new TypeToken<Teams>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTeamsAsync(Long limit, Long offset, String filter, String expand, ApiCallback<Teams> _callback) throws ApiException {
        Call localVarCall = this.getTeamsValidateBeforeCall(limit, offset, filter, expand, _callback);
        Type localVarReturnType = new TypeToken<Teams>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchTeamCall(String teamKey, TeamPatchInput teamPatchInput, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TeamPatchInput localVarPostBody = teamPatchInput;
        String localVarPath = "/api/v2/teams/{teamKey}".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchTeamValidateBeforeCall(String teamKey, TeamPatchInput teamPatchInput, String expand, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling patchTeam(Async)");
        }
        if (teamPatchInput == null) {
            throw new ApiException("Missing the required parameter 'teamPatchInput' when calling patchTeam(Async)");
        }
        Call localVarCall = this.patchTeamCall(teamKey, teamPatchInput, expand, _callback);
        return localVarCall;
    }

    public Team patchTeam(String teamKey, TeamPatchInput teamPatchInput, String expand) throws ApiException {
        ApiResponse<Team> localVarResp = this.patchTeamWithHttpInfo(teamKey, teamPatchInput, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Team> patchTeamWithHttpInfo(String teamKey, TeamPatchInput teamPatchInput, String expand) throws ApiException {
        Call localVarCall = this.patchTeamValidateBeforeCall(teamKey, teamPatchInput, expand, null);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchTeamAsync(String teamKey, TeamPatchInput teamPatchInput, String expand, ApiCallback<Team> _callback) throws ApiException {
        Call localVarCall = this.patchTeamValidateBeforeCall(teamKey, teamPatchInput, expand, _callback);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postTeamCall(TeamPostInput teamPostInput, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TeamPostInput localVarPostBody = teamPostInput;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postTeamValidateBeforeCall(TeamPostInput teamPostInput, String expand, ApiCallback _callback) throws ApiException {
        if (teamPostInput == null) {
            throw new ApiException("Missing the required parameter 'teamPostInput' when calling postTeam(Async)");
        }
        Call localVarCall = this.postTeamCall(teamPostInput, expand, _callback);
        return localVarCall;
    }

    public Team postTeam(TeamPostInput teamPostInput, String expand) throws ApiException {
        ApiResponse<Team> localVarResp = this.postTeamWithHttpInfo(teamPostInput, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Team> postTeamWithHttpInfo(TeamPostInput teamPostInput, String expand) throws ApiException {
        Call localVarCall = this.postTeamValidateBeforeCall(teamPostInput, expand, null);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postTeamAsync(TeamPostInput teamPostInput, String expand, ApiCallback<Team> _callback) throws ApiException {
        Call localVarCall = this.postTeamValidateBeforeCall(teamPostInput, expand, _callback);
        Type localVarReturnType = new TypeToken<Team>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postTeamMembersCall(String teamKey, File _file, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/teams/{teamKey}/members".replaceAll("\\{teamKey\\}", this.localVarApiClient.escapeString(teamKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postTeamMembersValidateBeforeCall(String teamKey, File _file, ApiCallback _callback) throws ApiException {
        if (teamKey == null) {
            throw new ApiException("Missing the required parameter 'teamKey' when calling postTeamMembers(Async)");
        }
        Call localVarCall = this.postTeamMembersCall(teamKey, _file, _callback);
        return localVarCall;
    }

    public TeamImportsRep postTeamMembers(String teamKey, File _file) throws ApiException {
        ApiResponse<TeamImportsRep> localVarResp = this.postTeamMembersWithHttpInfo(teamKey, _file);
        return localVarResp.getData();
    }

    public ApiResponse<TeamImportsRep> postTeamMembersWithHttpInfo(String teamKey, File _file) throws ApiException {
        Call localVarCall = this.postTeamMembersValidateBeforeCall(teamKey, _file, null);
        Type localVarReturnType = new TypeToken<TeamImportsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postTeamMembersAsync(String teamKey, File _file, ApiCallback<TeamImportsRep> _callback) throws ApiException {
        Call localVarCall = this.postTeamMembersValidateBeforeCall(teamKey, _file, _callback);
        Type localVarReturnType = new TypeToken<TeamImportsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

