/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AudienceConfiguration;
import com.launchdarkly.api.model.EnvironmentSummary;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Audience {
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private EnvironmentSummary environment;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private AudienceConfiguration _configuration;
    public static final String SERIALIZED_NAME_SEGMENT_KEYS = "segmentKeys";
    @SerializedName(value="segmentKeys")
    private List<String> segmentKeys = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Audience environment(EnvironmentSummary environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EnvironmentSummary getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentSummary environment) {
        this.environment = environment;
    }

    public Audience name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Phase 1 - Testing", required=true, value="The release phase name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Audience _configuration(AudienceConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AudienceConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(AudienceConfiguration _configuration) {
        this._configuration = _configuration;
    }

    public Audience segmentKeys(List<String> segmentKeys) {
        this.segmentKeys = segmentKeys;
        return this;
    }

    public Audience addSegmentKeysItem(String segmentKeysItem) {
        if (this.segmentKeys == null) {
            this.segmentKeys = new ArrayList<String>();
        }
        this.segmentKeys.add(segmentKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"segment-key-123abc\"]", value="A list of segment keys")
    public List<String> getSegmentKeys() {
        return this.segmentKeys;
    }

    public void setSegmentKeys(List<String> segmentKeys) {
        this.segmentKeys = segmentKeys;
    }

    public Audience putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Audience audience = (Audience)o;
        return Objects.equals(this.environment, audience.environment) && Objects.equals(this.name, audience.name) && Objects.equals(this._configuration, audience._configuration) && Objects.equals(this.segmentKeys, audience.segmentKeys) && Objects.equals(this.additionalProperties, audience.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.name, this._configuration, this.segmentKeys, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Audience {\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    segmentKeys: ").append(this.toIndentedString(this.segmentKeys)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Audience is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT) != null) {
            EnvironmentSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION) != null) {
            AudienceConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `segmentKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS).toString()));
        }
    }

    public static Audience fromJson(String jsonString) throws IOException {
        return (Audience)JSON.getGson().fromJson(jsonString, Audience.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_SEGMENT_KEYS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Audience.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Audience.class));
            return new TypeAdapter<Audience>(){

                public void write(JsonWriter out, Audience value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Audience read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Audience.validateJsonObject(jsonObj);
                    Audience instance = (Audience)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

