/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ReleaseGuardianConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AudienceConfiguration {
    public static final String SERIALIZED_NAME_RELEASE_STRATEGY = "releaseStrategy";
    @SerializedName(value="releaseStrategy")
    private String releaseStrategy;
    public static final String SERIALIZED_NAME_REQUIRE_APPROVAL = "requireApproval";
    @SerializedName(value="requireApproval")
    private Boolean requireApproval;
    public static final String SERIALIZED_NAME_NOTIFY_MEMBER_IDS = "notifyMemberIds";
    @SerializedName(value="notifyMemberIds")
    private List<String> notifyMemberIds = null;
    public static final String SERIALIZED_NAME_NOTIFY_TEAM_KEYS = "notifyTeamKeys";
    @SerializedName(value="notifyTeamKeys")
    private List<String> notifyTeamKeys = null;
    public static final String SERIALIZED_NAME_RELEASE_GUARDIAN_CONFIGURATION = "releaseGuardianConfiguration";
    @SerializedName(value="releaseGuardianConfiguration")
    private ReleaseGuardianConfiguration releaseGuardianConfiguration;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AudienceConfiguration releaseStrategy(String releaseStrategy) {
        this.releaseStrategy = releaseStrategy;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getReleaseStrategy() {
        return this.releaseStrategy;
    }

    public void setReleaseStrategy(String releaseStrategy) {
        this.releaseStrategy = releaseStrategy;
    }

    public AudienceConfiguration requireApproval(Boolean requireApproval) {
        this.requireApproval = requireApproval;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether or not the audience requires approval")
    public Boolean getRequireApproval() {
        return this.requireApproval;
    }

    public void setRequireApproval(Boolean requireApproval) {
        this.requireApproval = requireApproval;
    }

    public AudienceConfiguration notifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
        return this;
    }

    public AudienceConfiguration addNotifyMemberIdsItem(String notifyMemberIdsItem) {
        if (this.notifyMemberIds == null) {
            this.notifyMemberIds = new ArrayList<String>();
        }
        this.notifyMemberIds.add(notifyMemberIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"1234a56b7c89d012345e678f\"]", value="An array of member IDs. These members are notified to review the approval request.")
    public List<String> getNotifyMemberIds() {
        return this.notifyMemberIds;
    }

    public void setNotifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
    }

    public AudienceConfiguration notifyTeamKeys(List<String> notifyTeamKeys) {
        this.notifyTeamKeys = notifyTeamKeys;
        return this;
    }

    public AudienceConfiguration addNotifyTeamKeysItem(String notifyTeamKeysItem) {
        if (this.notifyTeamKeys == null) {
            this.notifyTeamKeys = new ArrayList<String>();
        }
        this.notifyTeamKeys.add(notifyTeamKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-reviewer-team\"]", value="An array of team keys. The members of these teams are notified to review the approval request.")
    public List<String> getNotifyTeamKeys() {
        return this.notifyTeamKeys;
    }

    public void setNotifyTeamKeys(List<String> notifyTeamKeys) {
        this.notifyTeamKeys = notifyTeamKeys;
    }

    public AudienceConfiguration releaseGuardianConfiguration(ReleaseGuardianConfiguration releaseGuardianConfiguration) {
        this.releaseGuardianConfiguration = releaseGuardianConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReleaseGuardianConfiguration getReleaseGuardianConfiguration() {
        return this.releaseGuardianConfiguration;
    }

    public void setReleaseGuardianConfiguration(ReleaseGuardianConfiguration releaseGuardianConfiguration) {
        this.releaseGuardianConfiguration = releaseGuardianConfiguration;
    }

    public AudienceConfiguration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceConfiguration audienceConfiguration = (AudienceConfiguration)o;
        return Objects.equals(this.releaseStrategy, audienceConfiguration.releaseStrategy) && Objects.equals(this.requireApproval, audienceConfiguration.requireApproval) && Objects.equals(this.notifyMemberIds, audienceConfiguration.notifyMemberIds) && Objects.equals(this.notifyTeamKeys, audienceConfiguration.notifyTeamKeys) && Objects.equals(this.releaseGuardianConfiguration, audienceConfiguration.releaseGuardianConfiguration) && Objects.equals(this.additionalProperties, audienceConfiguration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.releaseStrategy, this.requireApproval, this.notifyMemberIds, this.notifyTeamKeys, this.releaseGuardianConfiguration, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudienceConfiguration {\n");
        sb.append("    releaseStrategy: ").append(this.toIndentedString(this.releaseStrategy)).append("\n");
        sb.append("    requireApproval: ").append(this.toIndentedString(this.requireApproval)).append("\n");
        sb.append("    notifyMemberIds: ").append(this.toIndentedString(this.notifyMemberIds)).append("\n");
        sb.append("    notifyTeamKeys: ").append(this.toIndentedString(this.notifyTeamKeys)).append("\n");
        sb.append("    releaseGuardianConfiguration: ").append(this.toIndentedString(this.releaseGuardianConfiguration)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AudienceConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RELEASE_STRATEGY) != null && !jsonObj.get(SERIALIZED_NAME_RELEASE_STRATEGY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `releaseStrategy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELEASE_STRATEGY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifyMemberIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notifyTeamKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_TEAM_KEYS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RELEASE_GUARDIAN_CONFIGURATION) != null) {
            ReleaseGuardianConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RELEASE_GUARDIAN_CONFIGURATION));
        }
    }

    public static AudienceConfiguration fromJson(String jsonString) throws IOException {
        return (AudienceConfiguration)JSON.getGson().fromJson(jsonString, AudienceConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RELEASE_STRATEGY);
        openapiFields.add(SERIALIZED_NAME_REQUIRE_APPROVAL);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_MEMBER_IDS);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_TEAM_KEYS);
        openapiFields.add(SERIALIZED_NAME_RELEASE_GUARDIAN_CONFIGURATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RELEASE_STRATEGY);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRE_APPROVAL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AudienceConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AudienceConfiguration.class));
            return new TypeAdapter<AudienceConfiguration>(){

                public void write(JsonWriter out, AudienceConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AudienceConfiguration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AudienceConfiguration.validateJsonObject(jsonObj);
                    AudienceConfiguration instance = (AudienceConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

