/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.StoreIntegrationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class BigSegmentStoreStatus {
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private Boolean available;
    public static final String SERIALIZED_NAME_POTENTIALLY_STALE = "potentiallyStale";
    @SerializedName(value="potentiallyStale")
    private Boolean potentiallyStale;
    public static final String SERIALIZED_NAME_LAST_SYNC = "lastSync";
    @SerializedName(value="lastSync")
    private Long lastSync;
    public static final String SERIALIZED_NAME_LAST_ERROR = "lastError";
    @SerializedName(value="lastError")
    private Long lastError;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<StoreIntegrationError> errors = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BigSegmentStoreStatus available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the persistent store integration is fully synchronized with the LaunchDarkly environment, and the <code>lastSync</code> occurred within a few minutes")
    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public BigSegmentStoreStatus potentiallyStale(Boolean potentiallyStale) {
        this.potentiallyStale = potentiallyStale;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the persistent store integration may not be fully synchronized with the LaunchDarkly environment. <code>true</code> if the integration could be stale.")
    public Boolean getPotentiallyStale() {
        return this.potentiallyStale;
    }

    public void setPotentiallyStale(Boolean potentiallyStale) {
        this.potentiallyStale = potentiallyStale;
    }

    public BigSegmentStoreStatus lastSync(Long lastSync) {
        this.lastSync = lastSync;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Long lastSync) {
        this.lastSync = lastSync;
    }

    public BigSegmentStoreStatus lastError(Long lastError) {
        this.lastError = lastError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastError() {
        return this.lastError;
    }

    public void setLastError(Long lastError) {
        this.lastError = lastError;
    }

    public BigSegmentStoreStatus errors(List<StoreIntegrationError> errors) {
        this.errors = errors;
        return this;
    }

    public BigSegmentStoreStatus addErrorsItem(StoreIntegrationError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<StoreIntegrationError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<StoreIntegrationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<StoreIntegrationError> errors) {
        this.errors = errors;
    }

    public BigSegmentStoreStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigSegmentStoreStatus bigSegmentStoreStatus = (BigSegmentStoreStatus)o;
        return Objects.equals(this.available, bigSegmentStoreStatus.available) && Objects.equals(this.potentiallyStale, bigSegmentStoreStatus.potentiallyStale) && Objects.equals(this.lastSync, bigSegmentStoreStatus.lastSync) && Objects.equals(this.lastError, bigSegmentStoreStatus.lastError) && Objects.equals(this.errors, bigSegmentStoreStatus.errors) && Objects.equals(this.additionalProperties, bigSegmentStoreStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.potentiallyStale, this.lastSync, this.lastError, this.errors, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BigSegmentStoreStatus {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    potentiallyStale: ").append(this.toIndentedString(this.potentiallyStale)).append("\n");
        sb.append("    lastSync: ").append(this.toIndentedString(this.lastSync)).append("\n");
        sb.append("    lastError: ").append(this.toIndentedString(this.lastError)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BigSegmentStoreStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS);
        if (jsonArrayerrors != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                StoreIntegrationError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static BigSegmentStoreStatus fromJson(String jsonString) throws IOException {
        return (BigSegmentStoreStatus)JSON.getGson().fromJson(jsonString, BigSegmentStoreStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AVAILABLE);
        openapiFields.add(SERIALIZED_NAME_POTENTIALLY_STALE);
        openapiFields.add(SERIALIZED_NAME_LAST_SYNC);
        openapiFields.add(SERIALIZED_NAME_LAST_ERROR);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!BigSegmentStoreStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BigSegmentStoreStatus.class));
            return new TypeAdapter<BigSegmentStoreStatus>(){

                public void write(JsonWriter out, BigSegmentStoreStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public BigSegmentStoreStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BigSegmentStoreStatus.validateJsonObject(jsonObj);
                    BigSegmentStoreStatus instance = (BigSegmentStoreStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

