/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContextInstanceRecord {
    public static final String SERIALIZED_NAME_LAST_SEEN = "lastSeen";
    @SerializedName(value="lastSeen")
    private OffsetDateTime lastSeen;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_APPLICATION_ID = "applicationId";
    @SerializedName(value="applicationId")
    private String applicationId;
    public static final String SERIALIZED_NAME_ANONYMOUS_KINDS = "anonymousKinds";
    @SerializedName(value="anonymousKinds")
    private List<String> anonymousKinds = null;
    public static final String SERIALIZED_NAME_CONTEXT = "context";
    @SerializedName(value="context")
    private Object context = null;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContextInstanceRecord lastSeen(OffsetDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2022-04-15T15:00:57.526470334Z", value="Timestamp of the last time an evaluation occurred for this context instance")
    public OffsetDateTime getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(OffsetDateTime lastSeen) {
        this.lastSeen = lastSeen;
    }

    public ContextInstanceRecord id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="b3JnOmxhdW5jaGRhcmtseQ", required=true, value="The context instance ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContextInstanceRecord applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GoSDK/1.2", value="An identifier representing the application where the LaunchDarkly SDK is running")
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public ContextInstanceRecord anonymousKinds(List<String> anonymousKinds) {
        this.anonymousKinds = anonymousKinds;
        return this;
    }

    public ContextInstanceRecord addAnonymousKindsItem(String anonymousKindsItem) {
        if (this.anonymousKinds == null) {
            this.anonymousKinds = new ArrayList<String>();
        }
        this.anonymousKinds.add(anonymousKindsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"device\",\"privateKind\"]", value="A list of the context kinds this context was associated with that the SDK removed because they were marked as anonymous at flag evaluation")
    public List<String> getAnonymousKinds() {
        return this.anonymousKinds;
    }

    public void setAnonymousKinds(List<String> anonymousKinds) {
        this.anonymousKinds = anonymousKinds;
    }

    public ContextInstanceRecord context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"kind\": \"user\", \"key\": \"context-key-123abc\", \"name\": \"Sandy Smith\", \"email\": \"sandy@example.com\"}", required=true, value="The context, including its kind and attributes")
    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public ContextInstanceRecord links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ContextInstanceRecord putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"parent\":{\"href\":\"/api/v2/projects/my-project/environments/my-environment\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/projects/my-project/environments/my-env/context-instances/organization:launch-darkly:user:henry?filter=applicationId:\\\"GoSDK/1.2\\\"\",\"type\":\"application/json\"},\"site\":{\"href\":\"/my-project/my-environment/context-instances/organization:launch-darkly:user:henry\",\"type\":\"text/html\"}}", value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ContextInstanceRecord access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public ContextInstanceRecord putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextInstanceRecord contextInstanceRecord = (ContextInstanceRecord)o;
        return Objects.equals(this.lastSeen, contextInstanceRecord.lastSeen) && Objects.equals(this.id, contextInstanceRecord.id) && Objects.equals(this.applicationId, contextInstanceRecord.applicationId) && Objects.equals(this.anonymousKinds, contextInstanceRecord.anonymousKinds) && Objects.equals(this.context, contextInstanceRecord.context) && Objects.equals(this.links, contextInstanceRecord.links) && Objects.equals(this.access, contextInstanceRecord.access) && Objects.equals(this.additionalProperties, contextInstanceRecord.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.lastSeen, this.id, this.applicationId, this.anonymousKinds, this.context, this.links, this.access, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContextInstanceRecord {\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    applicationId: ").append(this.toIndentedString(this.applicationId)).append("\n");
        sb.append("    anonymousKinds: ").append(this.toIndentedString(this.anonymousKinds)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContextInstanceRecord is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ANONYMOUS_KINDS) != null && !jsonObj.get(SERIALIZED_NAME_ANONYMOUS_KINDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `anonymousKinds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ANONYMOUS_KINDS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
    }

    public static ContextInstanceRecord fromJson(String jsonString) throws IOException {
        return (ContextInstanceRecord)JSON.getGson().fromJson(jsonString, ContextInstanceRecord.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAST_SEEN);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_ID);
        openapiFields.add(SERIALIZED_NAME_ANONYMOUS_KINDS);
        openapiFields.add(SERIALIZED_NAME_CONTEXT);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_CONTEXT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ContextInstanceRecord.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContextInstanceRecord.class));
            return new TypeAdapter<ContextInstanceRecord>(){

                public void write(JsonWriter out, ContextInstanceRecord value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ContextInstanceRecord read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContextInstanceRecord.validateJsonObject(jsonObj);
                    ContextInstanceRecord instance = (ContextInstanceRecord)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

