/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ContextInstanceRecord;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContextInstances {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_TOTAL_COUNT = "totalCount";
    @SerializedName(value="totalCount")
    private Integer totalCount;
    public static final String SERIALIZED_NAME_ENVIRONMENT_ID = "_environmentId";
    @SerializedName(value="_environmentId")
    private String environmentId;
    public static final String SERIALIZED_NAME_CONTINUATION_TOKEN = "continuationToken";
    @SerializedName(value="continuationToken")
    private String continuationToken;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<ContextInstanceRecord> items = new ArrayList<ContextInstanceRecord>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContextInstances links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ContextInstances putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"next\":{\"href\":\"/api/v2/projects/my-project/environments/my-env/context-instances/organization:launch-darkly:user:henry?limit=2&continuationToken=2022-04-15T15:00:57.526470334Z\",\"type\":\"application/json\"},\"self\":{\"href\":\"/api/v2/projects/my-proj/environments/my-env/context-instances/organization:launch-darkly:user:henry-jacobs?limit=2\",\"type\":\"application/json\"}}", value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ContextInstances totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="The number of unique context instances")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public ContextInstances environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="57be1db38b75bf0772d11384", required=true, value="The environment ID")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public ContextInstances continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="QAGFKH1313KUGI2351", value="An obfuscated string that references the last context instance on the previous page of results. You can use this for pagination, however, we recommend using the <code>next</code> link instead.")
    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public ContextInstances items(List<ContextInstanceRecord> items) {
        this.items = items;
        return this;
    }

    public ContextInstances addItemsItem(ContextInstanceRecord itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A collection of context instances. Can include multiple versions of context instances that have the same <code>id</code>, but different <code>applicationId</code>s.")
    public List<ContextInstanceRecord> getItems() {
        return this.items;
    }

    public void setItems(List<ContextInstanceRecord> items) {
        this.items = items;
    }

    public ContextInstances putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextInstances contextInstances = (ContextInstances)o;
        return Objects.equals(this.links, contextInstances.links) && Objects.equals(this.totalCount, contextInstances.totalCount) && Objects.equals(this.environmentId, contextInstances.environmentId) && Objects.equals(this.continuationToken, contextInstances.continuationToken) && Objects.equals(this.items, contextInstances.items) && Objects.equals(this.additionalProperties, contextInstances.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.totalCount, this.environmentId, this.continuationToken, this.items, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContextInstances {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContextInstances is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_environmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTINUATION_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_CONTINUATION_TOKEN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `continuationToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTINUATION_TOKEN).toString()));
        }
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS);
        if (jsonArrayitems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                ContextInstanceRecord.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
    }

    public static ContextInstances fromJson(String jsonString) throws IOException {
        return (ContextInstances)JSON.getGson().fromJson(jsonString, ContextInstances.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_TOTAL_COUNT);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_ID);
        openapiFields.add(SERIALIZED_NAME_CONTINUATION_TOKEN);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENVIRONMENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ContextInstances.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContextInstances.class));
            return new TypeAdapter<ContextInstances>(){

                public void write(JsonWriter out, ContextInstances value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ContextInstances read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContextInstances.validateJsonObject(jsonObj);
                    ContextInstances instance = (ContextInstances)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

