/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ExperimentMetadataRep;
import com.launchdarkly.api.model.ExperimentStatsRep;
import com.launchdarkly.api.model.ExperimentTimeSeriesSlice;
import com.launchdarkly.api.model.ExperimentTotalsRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MetricSeen;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExperimentResults {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private List<ExperimentMetadataRep> metadata = null;
    public static final String SERIALIZED_NAME_TOTALS = "totals";
    @SerializedName(value="totals")
    private List<ExperimentTotalsRep> totals = null;
    public static final String SERIALIZED_NAME_SERIES = "series";
    @SerializedName(value="series")
    private List<ExperimentTimeSeriesSlice> series = null;
    public static final String SERIALIZED_NAME_STATS = "stats";
    @SerializedName(value="stats")
    private ExperimentStatsRep stats;
    public static final String SERIALIZED_NAME_GRANULARITY = "granularity";
    @SerializedName(value="granularity")
    private String granularity;
    public static final String SERIALIZED_NAME_METRIC_SEEN = "metricSeen";
    @SerializedName(value="metricSeen")
    private MetricSeen metricSeen;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExperimentResults links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ExperimentResults putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ExperimentResults metadata(List<ExperimentMetadataRep> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ExperimentResults addMetadataItem(ExperimentMetadataRep metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<ExperimentMetadataRep>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ExperimentMetadataRep> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<ExperimentMetadataRep> metadata) {
        this.metadata = metadata;
    }

    public ExperimentResults totals(List<ExperimentTotalsRep> totals) {
        this.totals = totals;
        return this;
    }

    public ExperimentResults addTotalsItem(ExperimentTotalsRep totalsItem) {
        if (this.totals == null) {
            this.totals = new ArrayList<ExperimentTotalsRep>();
        }
        this.totals.add(totalsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ExperimentTotalsRep> getTotals() {
        return this.totals;
    }

    public void setTotals(List<ExperimentTotalsRep> totals) {
        this.totals = totals;
    }

    public ExperimentResults series(List<ExperimentTimeSeriesSlice> series) {
        this.series = series;
        return this;
    }

    public ExperimentResults addSeriesItem(ExperimentTimeSeriesSlice seriesItem) {
        if (this.series == null) {
            this.series = new ArrayList<ExperimentTimeSeriesSlice>();
        }
        this.series.add(seriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ExperimentTimeSeriesSlice> getSeries() {
        return this.series;
    }

    public void setSeries(List<ExperimentTimeSeriesSlice> series) {
        this.series = series;
    }

    public ExperimentResults stats(ExperimentStatsRep stats) {
        this.stats = stats;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExperimentStatsRep getStats() {
        return this.stats;
    }

    public void setStats(ExperimentStatsRep stats) {
        this.stats = stats;
    }

    public ExperimentResults granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public ExperimentResults metricSeen(MetricSeen metricSeen) {
        this.metricSeen = metricSeen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MetricSeen getMetricSeen() {
        return this.metricSeen;
    }

    public void setMetricSeen(MetricSeen metricSeen) {
        this.metricSeen = metricSeen;
    }

    public ExperimentResults putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExperimentResults experimentResults = (ExperimentResults)o;
        return Objects.equals(this.links, experimentResults.links) && Objects.equals(this.metadata, experimentResults.metadata) && Objects.equals(this.totals, experimentResults.totals) && Objects.equals(this.series, experimentResults.series) && Objects.equals(this.stats, experimentResults.stats) && Objects.equals(this.granularity, experimentResults.granularity) && Objects.equals(this.metricSeen, experimentResults.metricSeen) && Objects.equals(this.additionalProperties, experimentResults.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.metadata, this.totals, this.series, this.stats, this.granularity, this.metricSeen, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExperimentResults {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    totals: ").append(this.toIndentedString(this.totals)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    metricSeen: ").append(this.toIndentedString(this.metricSeen)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayseries;
        JsonArray jsonArraytotals;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExperimentResults is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArraymetadata = jsonObj.getAsJsonArray(SERIALIZED_NAME_METADATA);
        if (jsonArraymetadata != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METADATA).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metadata` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METADATA).toString()));
            }
            for (int i = 0; i < jsonArraymetadata.size(); ++i) {
                ExperimentMetadataRep.validateJsonObject(jsonArraymetadata.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraytotals = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOTALS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOTALS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `totals` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOTALS).toString()));
            }
            for (int i = 0; i < jsonArraytotals.size(); ++i) {
                ExperimentTotalsRep.validateJsonObject(jsonArraytotals.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayseries = jsonObj.getAsJsonArray(SERIALIZED_NAME_SERIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SERIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `series` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERIES).toString()));
            }
            for (int i = 0; i < jsonArrayseries.size(); ++i) {
                ExperimentTimeSeriesSlice.validateJsonObject(jsonArrayseries.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STATS) != null) {
            ExperimentStatsRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STATS));
        }
        if (jsonObj.get(SERIALIZED_NAME_GRANULARITY) != null && !jsonObj.get(SERIALIZED_NAME_GRANULARITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `granularity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GRANULARITY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_METRIC_SEEN) != null) {
            MetricSeen.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METRIC_SEEN));
        }
    }

    public static ExperimentResults fromJson(String jsonString) throws IOException {
        return (ExperimentResults)JSON.getGson().fromJson(jsonString, ExperimentResults.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_TOTALS);
        openapiFields.add(SERIALIZED_NAME_SERIES);
        openapiFields.add(SERIALIZED_NAME_STATS);
        openapiFields.add(SERIALIZED_NAME_GRANULARITY);
        openapiFields.add(SERIALIZED_NAME_METRIC_SEEN);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ExperimentResults.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExperimentResults.class));
            return new TypeAdapter<ExperimentResults>(){

                public void write(JsonWriter out, ExperimentResults value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ExperimentResults read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExperimentResults.validateJsonObject(jsonObj);
                    ExperimentResults instance = (ExperimentResults)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

