/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FlagEventExperimentCollection;
import com.launchdarkly.api.model.FlagEventImpactRep;
import com.launchdarkly.api.model.FlagEventMemberRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlagEventRep {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_PROJECT_ID = "projectId";
    @SerializedName(value="projectId")
    private String projectId;
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    private String projectKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_ID = "environmentId";
    @SerializedName(value="environmentId")
    private String environmentId;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    private String environmentKey;
    public static final String SERIALIZED_NAME_FLAG_KEY = "flagKey";
    @SerializedName(value="flagKey")
    private String flagKey;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    private String eventType;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private Long eventTime;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_AUDIT_LOG_ENTRY_ID = "auditLogEntryId";
    @SerializedName(value="auditLogEntryId")
    private String auditLogEntryId;
    public static final String SERIALIZED_NAME_MEMBER = "member";
    @SerializedName(value="member")
    private FlagEventMemberRep member;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private List<String> actions = null;
    public static final String SERIALIZED_NAME_IMPACT = "impact";
    @SerializedName(value="impact")
    private FlagEventImpactRep impact;
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    private FlagEventExperimentCollection experiments;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagEventRep id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="e3b2b0e0-9e9b-4c9a-8e9a-0e0e0e0e0e0e", required=true, value="The flag event ID")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public FlagEventRep projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="65baa44ecc4b5bce113bb4f7", required=true, value="The project ID")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public FlagEventRep projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="default", required=true, value="The project key")
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public FlagEventRep environmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="65baa44ecc4b5bce113bb4f7", value="The environment ID")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public FlagEventRep environmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="production", value="The environment key")
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public FlagEventRep flagKey(String flagKey) {
        this.flagKey = flagKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="enable-new-payment-method", required=true, value="The flag key")
    public String getFlagKey() {
        return this.flagKey;
    }

    public void setFlagKey(String flagKey) {
        this.flagKey = flagKey;
    }

    public FlagEventRep eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public FlagEventRep eventTime(Long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public FlagEventRep description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Targeting rule enabled", required=true, value="The event description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FlagEventRep auditLogEntryId(String auditLogEntryId) {
        this.auditLogEntryId = auditLogEntryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="e3b2b0e0-9e9b-4c9a-8e9a-0e0e0e0e0e0e", value="The audit log entry ID")
    public String getAuditLogEntryId() {
        return this.auditLogEntryId;
    }

    public void setAuditLogEntryId(String auditLogEntryId) {
        this.auditLogEntryId = auditLogEntryId;
    }

    public FlagEventRep member(FlagEventMemberRep member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FlagEventMemberRep getMember() {
        return this.member;
    }

    public void setMember(FlagEventMemberRep member) {
        this.member = member;
    }

    public FlagEventRep actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public FlagEventRep addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The resource actions")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public FlagEventRep impact(FlagEventImpactRep impact) {
        this.impact = impact;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FlagEventImpactRep getImpact() {
        return this.impact;
    }

    public void setImpact(FlagEventImpactRep impact) {
        this.impact = impact;
    }

    public FlagEventRep experiments(FlagEventExperimentCollection experiments) {
        this.experiments = experiments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FlagEventExperimentCollection getExperiments() {
        return this.experiments;
    }

    public void setExperiments(FlagEventExperimentCollection experiments) {
        this.experiments = experiments;
    }

    public FlagEventRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagEventRep flagEventRep = (FlagEventRep)o;
        return Objects.equals(this.id, flagEventRep.id) && Objects.equals(this.projectId, flagEventRep.projectId) && Objects.equals(this.projectKey, flagEventRep.projectKey) && Objects.equals(this.environmentId, flagEventRep.environmentId) && Objects.equals(this.environmentKey, flagEventRep.environmentKey) && Objects.equals(this.flagKey, flagEventRep.flagKey) && Objects.equals(this.eventType, flagEventRep.eventType) && Objects.equals(this.eventTime, flagEventRep.eventTime) && Objects.equals(this.description, flagEventRep.description) && Objects.equals(this.auditLogEntryId, flagEventRep.auditLogEntryId) && Objects.equals(this.member, flagEventRep.member) && Objects.equals(this.actions, flagEventRep.actions) && Objects.equals(this.impact, flagEventRep.impact) && Objects.equals(this.experiments, flagEventRep.experiments) && Objects.equals(this.additionalProperties, flagEventRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.projectId, this.projectKey, this.environmentId, this.environmentKey, this.flagKey, this.eventType, this.eventTime, this.description, this.auditLogEntryId, this.member, this.actions, this.impact, this.experiments, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagEventRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    flagKey: ").append(this.toIndentedString(this.flagKey)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    auditLogEntryId: ").append(this.toIndentedString(this.auditLogEntryId)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    impact: ").append(this.toIndentedString(this.impact)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagEventRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `projectId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `environmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FLAG_KEY) != null && !jsonObj.get(SERIALIZED_NAME_FLAG_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `flagKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FLAG_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eventType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUDIT_LOG_ENTRY_ID) != null && !jsonObj.get(SERIALIZED_NAME_AUDIT_LOG_ENTRY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `auditLogEntryId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIT_LOG_ENTRY_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER) != null) {
            FlagEventMemberRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIONS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IMPACT) != null) {
            FlagEventImpactRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IMPACT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENTS) != null) {
            FlagEventExperimentCollection.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EXPERIMENTS));
        }
    }

    public static FlagEventRep fromJson(String jsonString) throws IOException {
        return (FlagEventRep)JSON.getGson().fromJson(jsonString, FlagEventRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PROJECT_ID);
        openapiFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_ID);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_KEY);
        openapiFields.add(SERIALIZED_NAME_FLAG_KEY);
        openapiFields.add(SERIALIZED_NAME_EVENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_EVENT_TIME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_AUDIT_LOG_ENTRY_ID);
        openapiFields.add(SERIALIZED_NAME_MEMBER);
        openapiFields.add(SERIALIZED_NAME_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_IMPACT);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PROJECT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_FLAG_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_IMPACT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagEventRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagEventRep.class));
            return new TypeAdapter<FlagEventRep>(){

                public void write(JsonWriter out, FlagEventRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagEventRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagEventRep.validateJsonObject(jsonObj);
                    FlagEventRep instance = (FlagEventRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

