/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.FlagImportIntegrationLinks;
import com.launchdarkly.api.model.FlagImportStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlagImportIntegration {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private FlagImportIntegrationLinks links;
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_INTEGRATION_KEY = "integrationKey";
    @SerializedName(value="integrationKey")
    private IntegrationKeyEnum integrationKey;
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    private String projectKey;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private Map<String, Object> config = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private Access access;
    public static final String SERIALIZED_NAME_STATUS = "_status";
    @SerializedName(value="_status")
    private FlagImportStatus status;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagImportIntegration links(FlagImportIntegrationLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FlagImportIntegrationLinks getLinks() {
        return this.links;
    }

    public void setLinks(FlagImportIntegrationLinks links) {
        this.links = links;
    }

    public FlagImportIntegration id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12ab3c4d5ef1a2345bcde67f", required=true, value="The integration ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FlagImportIntegration integrationKey(IntegrationKeyEnum integrationKey) {
        this.integrationKey = integrationKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="split", required=true, value="The integration key")
    public IntegrationKeyEnum getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(IntegrationKeyEnum integrationKey) {
        this.integrationKey = integrationKey;
    }

    public FlagImportIntegration projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="default", required=true, value="The project key")
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public FlagImportIntegration config(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    public FlagImportIntegration putConfigItem(String key, Object configItem) {
        this.config.put(key, configItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public FlagImportIntegration tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FlagImportIntegration addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[]", required=true, value="List of tags for this configuration")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FlagImportIntegration name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Development environment configuration", required=true, value="Name of the configuration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FlagImportIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Version of the current configuration")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FlagImportIntegration access(Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(Access access) {
        this.access = access;
    }

    public FlagImportIntegration status(FlagImportStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public FlagImportStatus getStatus() {
        return this.status;
    }

    public void setStatus(FlagImportStatus status) {
        this.status = status;
    }

    public FlagImportIntegration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagImportIntegration flagImportIntegration = (FlagImportIntegration)o;
        return Objects.equals(this.links, flagImportIntegration.links) && Objects.equals(this.id, flagImportIntegration.id) && Objects.equals((Object)this.integrationKey, (Object)flagImportIntegration.integrationKey) && Objects.equals(this.projectKey, flagImportIntegration.projectKey) && Objects.equals(this.config, flagImportIntegration.config) && Objects.equals(this.tags, flagImportIntegration.tags) && Objects.equals(this.name, flagImportIntegration.name) && Objects.equals(this.version, flagImportIntegration.version) && Objects.equals(this.access, flagImportIntegration.access) && Objects.equals(this.status, flagImportIntegration.status) && Objects.equals(this.additionalProperties, flagImportIntegration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.id, this.integrationKey, this.projectKey, this.config, this.tags, this.name, this.version, this.access, this.status, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagImportIntegration {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    integrationKey: ").append(this.toIndentedString((Object)this.integrationKey)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagImportIntegration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            FlagImportIntegrationLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `integrationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            Access.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STATUS) != null) {
            FlagImportStatus.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STATUS));
        }
    }

    public static FlagImportIntegration fromJson(String jsonString) throws IOException {
        return (FlagImportIntegration)JSON.getGson().fromJson(jsonString, FlagImportIntegration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_KEY);
        openapiFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_INTEGRATION_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CONFIG);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagImportIntegration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagImportIntegration.class));
            return new TypeAdapter<FlagImportIntegration>(){

                public void write(JsonWriter out, FlagImportIntegration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagImportIntegration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagImportIntegration.validateJsonObject(jsonObj);
                    FlagImportIntegration instance = (FlagImportIntegration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IntegrationKeyEnum {
        SPLIT("split"),
        UNLEASH("unleash");

        private String value;

        private IntegrationKeyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IntegrationKeyEnum fromValue(String value) {
            for (IntegrationKeyEnum b : IntegrationKeyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IntegrationKeyEnum> {
            public void write(JsonWriter jsonWriter, IntegrationKeyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IntegrationKeyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IntegrationKeyEnum.fromValue(value);
            }
        }
    }
}

