/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FlagLinkMember;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.TimestampRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FlagLinkRep {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_KEY = "_key";
    @SerializedName(value="_key")
    private String key;
    public static final String SERIALIZED_NAME_INTEGRATION_KEY = "_integrationKey";
    @SerializedName(value="_integrationKey")
    private String integrationKey;
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_DEEP_LINK = "_deepLink";
    @SerializedName(value="_deepLink")
    private String deepLink;
    public static final String SERIALIZED_NAME_TIMESTAMP = "_timestamp";
    @SerializedName(value="_timestamp")
    private TimestampRep timestamp;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_METADATA = "_metadata";
    @SerializedName(value="_metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "_createdAt";
    @SerializedName(value="_createdAt")
    private Long createdAt;
    public static final String SERIALIZED_NAME_MEMBER = "_member";
    @SerializedName(value="_member")
    private FlagLinkMember member;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagLinkRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public FlagLinkRep putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public FlagLinkRep key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="flag-link-key-123abc", value="The flag link key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FlagLinkRep integrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The integration key for an integration whose <code>manifest.json</code> includes the <code>flagLink</code> capability, if this is a flag link for an existing integration")
    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public FlagLinkRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The ID of this flag link")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FlagLinkRep deepLink(String deepLink) {
        this.deepLink = deepLink;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com/archives/123123123", required=true, value="The URL for the external resource the flag is linked to")
    public String getDeepLink() {
        return this.deepLink;
    }

    public void setDeepLink(String deepLink) {
        this.deepLink = deepLink;
    }

    public FlagLinkRep timestamp(TimestampRep timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public TimestampRep getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(TimestampRep timestamp) {
        this.timestamp = timestamp;
    }

    public FlagLinkRep title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example link title", value="The title of the flag link")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FlagLinkRep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example link description", value="The description of the flag link")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FlagLinkRep metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public FlagLinkRep putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The metadata required by this integration in order to create a flag link, if this is a flag link for an existing integration. Defined in the integration's <code>manifest.json</code> file under <code>flagLink</code>.")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public FlagLinkRep createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public FlagLinkRep member(FlagLinkMember member) {
        this.member = member;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FlagLinkMember getMember() {
        return this.member;
    }

    public void setMember(FlagLinkMember member) {
        this.member = member;
    }

    public FlagLinkRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagLinkRep flagLinkRep = (FlagLinkRep)o;
        return Objects.equals(this.links, flagLinkRep.links) && Objects.equals(this.key, flagLinkRep.key) && Objects.equals(this.integrationKey, flagLinkRep.integrationKey) && Objects.equals(this.id, flagLinkRep.id) && Objects.equals(this.deepLink, flagLinkRep.deepLink) && Objects.equals(this.timestamp, flagLinkRep.timestamp) && Objects.equals(this.title, flagLinkRep.title) && Objects.equals(this.description, flagLinkRep.description) && Objects.equals(this.metadata, flagLinkRep.metadata) && Objects.equals(this.createdAt, flagLinkRep.createdAt) && Objects.equals(this.member, flagLinkRep.member) && Objects.equals(this.additionalProperties, flagLinkRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.key, this.integrationKey, this.id, this.deepLink, this.timestamp, this.title, this.description, this.metadata, this.createdAt, this.member, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagLinkRep {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    integrationKey: ").append(this.toIndentedString(this.integrationKey)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    deepLink: ").append(this.toIndentedString(this.deepLink)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagLinkRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_integrationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEEP_LINK) != null && !jsonObj.get(SERIALIZED_NAME_DEEP_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_deepLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEEP_LINK).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TIMESTAMP) != null) {
            TimestampRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TIMESTAMP));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER) != null) {
            FlagLinkMember.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMBER));
        }
    }

    public static FlagLinkRep fromJson(String jsonString) throws IOException {
        return (FlagLinkRep)JSON.getGson().fromJson(jsonString, FlagLinkRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_KEY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_DEEP_LINK);
        openapiFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_MEMBER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_DEEP_LINK);
        openapiRequiredFields.add(SERIALIZED_NAME_TIMESTAMP);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagLinkRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagLinkRep.class));
            return new TypeAdapter<FlagLinkRep>(){

                public void write(JsonWriter out, FlagLinkRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagLinkRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagLinkRep.validateJsonObject(jsonObj);
                    FlagLinkRep instance = (FlagLinkRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

