/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.MetricInput;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class HoldoutPostRequest {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_RANDOMIZATIONUNIT = "randomizationunit";
    @SerializedName(value="randomizationunit")
    private String randomizationunit;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private List<String> attributes = null;
    public static final String SERIALIZED_NAME_HOLDOUTAMOUNT = "holdoutamount";
    @SerializedName(value="holdoutamount")
    private String holdoutamount;
    public static final String SERIALIZED_NAME_PRIMARYMETRICKEY = "primarymetrickey";
    @SerializedName(value="primarymetrickey")
    private String primarymetrickey;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<MetricInput> metrics = null;
    public static final String SERIALIZED_NAME_PREREQUISITEFLAGKEY = "prerequisiteflagkey";
    @SerializedName(value="prerequisiteflagkey")
    private String prerequisiteflagkey;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public HoldoutPostRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="holdout-one-name", value="A human-friendly name for the holdout")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HoldoutPostRequest key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="holdout-key", value="A key that identifies the holdout")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public HoldoutPostRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My holdout-one description", value="Description of the holdout")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HoldoutPostRequest randomizationunit(String randomizationunit) {
        this.randomizationunit = randomizationunit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user", value="The chosen randomization unit for the holdout base experiment")
    public String getRandomizationunit() {
        return this.randomizationunit;
    }

    public void setRandomizationunit(String randomizationunit) {
        this.randomizationunit = randomizationunit;
    }

    public HoldoutPostRequest attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public HoldoutPostRequest addAttributesItem(String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"country\",\"device\",\"os\"]", value="The attributes that the holdout iteration's results can be sliced by")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public HoldoutPostRequest holdoutamount(String holdoutamount) {
        this.holdoutamount = holdoutamount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Audience allocation for the holdout")
    public String getHoldoutamount() {
        return this.holdoutamount;
    }

    public void setHoldoutamount(String holdoutamount) {
        this.holdoutamount = holdoutamount;
    }

    public HoldoutPostRequest primarymetrickey(String primarymetrickey) {
        this.primarymetrickey = primarymetrickey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="metric-key-123abc", value="The key of the primary metric for this holdout")
    public String getPrimarymetrickey() {
        return this.primarymetrickey;
    }

    public void setPrimarymetrickey(String primarymetrickey) {
        this.primarymetrickey = primarymetrickey;
    }

    public HoldoutPostRequest metrics(List<MetricInput> metrics) {
        this.metrics = metrics;
        return this;
    }

    public HoldoutPostRequest addMetricsItem(MetricInput metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricInput>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the metrics for this experiment")
    public List<MetricInput> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricInput> metrics) {
        this.metrics = metrics;
    }

    public HoldoutPostRequest prerequisiteflagkey(String prerequisiteflagkey) {
        this.prerequisiteflagkey = prerequisiteflagkey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="flag-key-123abc", value="The key of the flag that the holdout is dependent on")
    public String getPrerequisiteflagkey() {
        return this.prerequisiteflagkey;
    }

    public void setPrerequisiteflagkey(String prerequisiteflagkey) {
        this.prerequisiteflagkey = prerequisiteflagkey;
    }

    public HoldoutPostRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoldoutPostRequest holdoutPostRequest = (HoldoutPostRequest)o;
        return Objects.equals(this.name, holdoutPostRequest.name) && Objects.equals(this.key, holdoutPostRequest.key) && Objects.equals(this.description, holdoutPostRequest.description) && Objects.equals(this.randomizationunit, holdoutPostRequest.randomizationunit) && Objects.equals(this.attributes, holdoutPostRequest.attributes) && Objects.equals(this.holdoutamount, holdoutPostRequest.holdoutamount) && Objects.equals(this.primarymetrickey, holdoutPostRequest.primarymetrickey) && Objects.equals(this.metrics, holdoutPostRequest.metrics) && Objects.equals(this.prerequisiteflagkey, holdoutPostRequest.prerequisiteflagkey) && Objects.equals(this.additionalProperties, holdoutPostRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.description, this.randomizationunit, this.attributes, this.holdoutamount, this.primarymetrickey, this.metrics, this.prerequisiteflagkey, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HoldoutPostRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    randomizationunit: ").append(this.toIndentedString(this.randomizationunit)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    holdoutamount: ").append(this.toIndentedString(this.holdoutamount)).append("\n");
        sb.append("    primarymetrickey: ").append(this.toIndentedString(this.primarymetrickey)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    prerequisiteflagkey: ").append(this.toIndentedString(this.prerequisiteflagkey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in HoldoutPostRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATIONUNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATIONUNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationunit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATIONUNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOLDOUTAMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_HOLDOUTAMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `holdoutamount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOLDOUTAMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARYMETRICKEY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARYMETRICKEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `primarymetrickey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARYMETRICKEY).toString()));
        }
        JsonArray jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS);
        if (jsonArraymetrics != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraymetrics.size(); ++i) {
                MetricInput.validateJsonObject(jsonArraymetrics.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PREREQUISITEFLAGKEY) != null && !jsonObj.get(SERIALIZED_NAME_PREREQUISITEFLAGKEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `prerequisiteflagkey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREREQUISITEFLAGKEY).toString()));
        }
    }

    public static HoldoutPostRequest fromJson(String jsonString) throws IOException {
        return (HoldoutPostRequest)JSON.getGson().fromJson(jsonString, HoldoutPostRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATIONUNIT);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_HOLDOUTAMOUNT);
        openapiFields.add(SERIALIZED_NAME_PRIMARYMETRICKEY);
        openapiFields.add(SERIALIZED_NAME_METRICS);
        openapiFields.add(SERIALIZED_NAME_PREREQUISITEFLAGKEY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!HoldoutPostRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(HoldoutPostRequest.class));
            return new TypeAdapter<HoldoutPostRequest>(){

                public void write(JsonWriter out, HoldoutPostRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public HoldoutPostRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    HoldoutPostRequest.validateJsonObject(jsonObj);
                    HoldoutPostRequest instance = (HoldoutPostRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

