/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Environment;
import com.launchdarkly.api.model.InsightGroupCollectionScoreMetadata;
import com.launchdarkly.api.model.InsightGroupScores;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InsightGroup {
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private Environment environment;
    public static final String SERIALIZED_NAME_SCORES = "scores";
    @SerializedName(value="scores")
    private InsightGroupScores scores;
    public static final String SERIALIZED_NAME_SCORE_METADATA = "scoreMetadata";
    @SerializedName(value="scoreMetadata")
    private InsightGroupCollectionScoreMetadata scoreMetadata;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    private String projectKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    private String environmentKey;
    public static final String SERIALIZED_NAME_APPLICATION_KEYS = "applicationKeys";
    @SerializedName(value="applicationKeys")
    private List<String> applicationKeys = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private Long createdAt;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InsightGroup environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public InsightGroup scores(InsightGroupScores scores) {
        this.scores = scores;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InsightGroupScores getScores() {
        return this.scores;
    }

    public void setScores(InsightGroupScores scores) {
        this.scores = scores;
    }

    public InsightGroup scoreMetadata(InsightGroupCollectionScoreMetadata scoreMetadata) {
        this.scoreMetadata = scoreMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public InsightGroupCollectionScoreMetadata getScoreMetadata() {
        return this.scoreMetadata;
    }

    public void setScoreMetadata(InsightGroupCollectionScoreMetadata scoreMetadata) {
        this.scoreMetadata = scoreMetadata;
    }

    public InsightGroup key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="default-production-all-apps", required=true, value="The insight group key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public InsightGroup name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Production - All Apps", required=true, value="The insight group name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InsightGroup projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="default", required=true, value="The project key")
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public InsightGroup environmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="production", required=true, value="The environment key")
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public InsightGroup applicationKeys(List<String> applicationKeys) {
        this.applicationKeys = applicationKeys;
        return this;
    }

    public InsightGroup addApplicationKeysItem(String applicationKeysItem) {
        if (this.applicationKeys == null) {
            this.applicationKeys = new ArrayList<String>();
        }
        this.applicationKeys.add(applicationKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"billing-service\",\"inventory-service\"]", value="The application keys")
    public List<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public void setApplicationKeys(List<String> applicationKeys) {
        this.applicationKeys = applicationKeys;
    }

    public InsightGroup createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public InsightGroup putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightGroup insightGroup = (InsightGroup)o;
        return Objects.equals(this.environment, insightGroup.environment) && Objects.equals(this.scores, insightGroup.scores) && Objects.equals(this.scoreMetadata, insightGroup.scoreMetadata) && Objects.equals(this.key, insightGroup.key) && Objects.equals(this.name, insightGroup.name) && Objects.equals(this.projectKey, insightGroup.projectKey) && Objects.equals(this.environmentKey, insightGroup.environmentKey) && Objects.equals(this.applicationKeys, insightGroup.applicationKeys) && Objects.equals(this.createdAt, insightGroup.createdAt) && Objects.equals(this.additionalProperties, insightGroup.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.scores, this.scoreMetadata, this.key, this.name, this.projectKey, this.environmentKey, this.applicationKeys, this.createdAt, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsightGroup {\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    scores: ").append(this.toIndentedString(this.scores)).append("\n");
        sb.append("    scoreMetadata: ").append(this.toIndentedString(this.scoreMetadata)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    applicationKeys: ").append(this.toIndentedString(this.applicationKeys)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InsightGroup is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT) != null) {
            Environment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORES) != null) {
            InsightGroupScores.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORE_METADATA) != null) {
            InsightGroupCollectionScoreMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCORE_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_KEYS).toString()));
        }
    }

    public static InsightGroup fromJson(String jsonString) throws IOException {
        return (InsightGroup)JSON.getGson().fromJson(jsonString, InsightGroup.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_SCORES);
        openapiFields.add(SERIALIZED_NAME_SCORE_METADATA);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_KEY);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_KEYS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ENVIRONMENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!InsightGroup.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InsightGroup.class));
            return new TypeAdapter<InsightGroup>(){

                public void write(JsonWriter out, InsightGroup value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public InsightGroup read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InsightGroup.validateJsonObject(jsonObj);
                    InsightGroup instance = (InsightGroup)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

