/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.DeploymentCollectionRep;
import com.launchdarkly.api.model.FlagReferenceCollectionRep;
import com.launchdarkly.api.model.PullRequestLeadTimeRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestRep {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
    @SerializedName(value="externalId")
    private String externalId;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_AUTHOR = "author";
    @SerializedName(value="author")
    private String author;
    public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
    @SerializedName(value="createTime")
    private Long createTime;
    public static final String SERIALIZED_NAME_MERGE_TIME = "mergeTime";
    @SerializedName(value="mergeTime")
    private Long mergeTime;
    public static final String SERIALIZED_NAME_MERGE_COMMIT_KEY = "mergeCommitKey";
    @SerializedName(value="mergeCommitKey")
    private String mergeCommitKey;
    public static final String SERIALIZED_NAME_BASE_COMMIT_KEY = "baseCommitKey";
    @SerializedName(value="baseCommitKey")
    private String baseCommitKey;
    public static final String SERIALIZED_NAME_HEAD_COMMIT_KEY = "headCommitKey";
    @SerializedName(value="headCommitKey")
    private String headCommitKey;
    public static final String SERIALIZED_NAME_FILES_CHANGED = "filesChanged";
    @SerializedName(value="filesChanged")
    private Integer filesChanged;
    public static final String SERIALIZED_NAME_LINES_ADDED = "linesAdded";
    @SerializedName(value="linesAdded")
    private Integer linesAdded;
    public static final String SERIALIZED_NAME_LINES_DELETED = "linesDeleted";
    @SerializedName(value="linesDeleted")
    private Integer linesDeleted;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_DEPLOYMENTS = "deployments";
    @SerializedName(value="deployments")
    private DeploymentCollectionRep deployments;
    public static final String SERIALIZED_NAME_FLAG_REFERENCES = "flagReferences";
    @SerializedName(value="flagReferences")
    private FlagReferenceCollectionRep flagReferences;
    public static final String SERIALIZED_NAME_LEAD_TIME = "leadTime";
    @SerializedName(value="leadTime")
    private PullRequestLeadTimeRep leadTime;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PullRequestRep id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11", required=true, value="The pull request internal ID")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public PullRequestRep externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234", required=true, value="The pull request number")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public PullRequestRep title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Enable new payment structure", required=true, value="The pull request title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public PullRequestRep status(String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="merged", required=true, value="The pull request status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PullRequestRep author(String author) {
        this.author = author;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="jane.doe", required=true, value="The pull request author")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public PullRequestRep createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public PullRequestRep mergeTime(Long mergeTime) {
        this.mergeTime = mergeTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getMergeTime() {
        return this.mergeTime;
    }

    public void setMergeTime(Long mergeTime) {
        this.mergeTime = mergeTime;
    }

    public PullRequestRep mergeCommitKey(String mergeCommitKey) {
        this.mergeCommitKey = mergeCommitKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="a90a8a2", value="The pull request merge commit key")
    public String getMergeCommitKey() {
        return this.mergeCommitKey;
    }

    public void setMergeCommitKey(String mergeCommitKey) {
        this.mergeCommitKey = mergeCommitKey;
    }

    public PullRequestRep baseCommitKey(String baseCommitKey) {
        this.baseCommitKey = baseCommitKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="a90a8a2", required=true, value="The pull request base commit key")
    public String getBaseCommitKey() {
        return this.baseCommitKey;
    }

    public void setBaseCommitKey(String baseCommitKey) {
        this.baseCommitKey = baseCommitKey;
    }

    public PullRequestRep headCommitKey(String headCommitKey) {
        this.headCommitKey = headCommitKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="a90a8a2", required=true, value="The pull request head commit key")
    public String getHeadCommitKey() {
        return this.headCommitKey;
    }

    public void setHeadCommitKey(String headCommitKey) {
        this.headCommitKey = headCommitKey;
    }

    public PullRequestRep filesChanged(Integer filesChanged) {
        this.filesChanged = filesChanged;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2", required=true, value="The number of files changed")
    public Integer getFilesChanged() {
        return this.filesChanged;
    }

    public void setFilesChanged(Integer filesChanged) {
        this.filesChanged = filesChanged;
    }

    public PullRequestRep linesAdded(Integer linesAdded) {
        this.linesAdded = linesAdded;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="100", required=true, value="The number of lines added")
    public Integer getLinesAdded() {
        return this.linesAdded;
    }

    public void setLinesAdded(Integer linesAdded) {
        this.linesAdded = linesAdded;
    }

    public PullRequestRep linesDeleted(Integer linesDeleted) {
        this.linesDeleted = linesDeleted;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="50", required=true, value="The number of lines deleted")
    public Integer getLinesDeleted() {
        return this.linesDeleted;
    }

    public void setLinesDeleted(Integer linesDeleted) {
        this.linesDeleted = linesDeleted;
    }

    public PullRequestRep url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs/pull/406", required=true, value="The pull request URL")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public PullRequestRep deployments(DeploymentCollectionRep deployments) {
        this.deployments = deployments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DeploymentCollectionRep getDeployments() {
        return this.deployments;
    }

    public void setDeployments(DeploymentCollectionRep deployments) {
        this.deployments = deployments;
    }

    public PullRequestRep flagReferences(FlagReferenceCollectionRep flagReferences) {
        this.flagReferences = flagReferences;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FlagReferenceCollectionRep getFlagReferences() {
        return this.flagReferences;
    }

    public void setFlagReferences(FlagReferenceCollectionRep flagReferences) {
        this.flagReferences = flagReferences;
    }

    public PullRequestRep leadTime(PullRequestLeadTimeRep leadTime) {
        this.leadTime = leadTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PullRequestLeadTimeRep getLeadTime() {
        return this.leadTime;
    }

    public void setLeadTime(PullRequestLeadTimeRep leadTime) {
        this.leadTime = leadTime;
    }

    public PullRequestRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullRequestRep pullRequestRep = (PullRequestRep)o;
        return Objects.equals(this.id, pullRequestRep.id) && Objects.equals(this.externalId, pullRequestRep.externalId) && Objects.equals(this.title, pullRequestRep.title) && Objects.equals(this.status, pullRequestRep.status) && Objects.equals(this.author, pullRequestRep.author) && Objects.equals(this.createTime, pullRequestRep.createTime) && Objects.equals(this.mergeTime, pullRequestRep.mergeTime) && Objects.equals(this.mergeCommitKey, pullRequestRep.mergeCommitKey) && Objects.equals(this.baseCommitKey, pullRequestRep.baseCommitKey) && Objects.equals(this.headCommitKey, pullRequestRep.headCommitKey) && Objects.equals(this.filesChanged, pullRequestRep.filesChanged) && Objects.equals(this.linesAdded, pullRequestRep.linesAdded) && Objects.equals(this.linesDeleted, pullRequestRep.linesDeleted) && Objects.equals(this.url, pullRequestRep.url) && Objects.equals(this.deployments, pullRequestRep.deployments) && Objects.equals(this.flagReferences, pullRequestRep.flagReferences) && Objects.equals(this.leadTime, pullRequestRep.leadTime) && Objects.equals(this.additionalProperties, pullRequestRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.title, this.status, this.author, this.createTime, this.mergeTime, this.mergeCommitKey, this.baseCommitKey, this.headCommitKey, this.filesChanged, this.linesAdded, this.linesDeleted, this.url, this.deployments, this.flagReferences, this.leadTime, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PullRequestRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    createTime: ").append(this.toIndentedString(this.createTime)).append("\n");
        sb.append("    mergeTime: ").append(this.toIndentedString(this.mergeTime)).append("\n");
        sb.append("    mergeCommitKey: ").append(this.toIndentedString(this.mergeCommitKey)).append("\n");
        sb.append("    baseCommitKey: ").append(this.toIndentedString(this.baseCommitKey)).append("\n");
        sb.append("    headCommitKey: ").append(this.toIndentedString(this.headCommitKey)).append("\n");
        sb.append("    filesChanged: ").append(this.toIndentedString(this.filesChanged)).append("\n");
        sb.append("    linesAdded: ").append(this.toIndentedString(this.linesAdded)).append("\n");
        sb.append("    linesDeleted: ").append(this.toIndentedString(this.linesDeleted)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    deployments: ").append(this.toIndentedString(this.deployments)).append("\n");
        sb.append("    flagReferences: ").append(this.toIndentedString(this.flagReferences)).append("\n");
        sb.append("    leadTime: ").append(this.toIndentedString(this.leadTime)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PullRequestRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHOR) != null && !jsonObj.get(SERIALIZED_NAME_AUTHOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `author` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERGE_COMMIT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MERGE_COMMIT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mergeCommitKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERGE_COMMIT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BASE_COMMIT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_BASE_COMMIT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `baseCommitKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE_COMMIT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEAD_COMMIT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_HEAD_COMMIT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `headCommitKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEAD_COMMIT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DEPLOYMENTS) != null) {
            DeploymentCollectionRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DEPLOYMENTS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FLAG_REFERENCES) != null) {
            FlagReferenceCollectionRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FLAG_REFERENCES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LEAD_TIME) != null) {
            PullRequestLeadTimeRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LEAD_TIME));
        }
    }

    public static PullRequestRep fromJson(String jsonString) throws IOException {
        return (PullRequestRep)JSON.getGson().fromJson(jsonString, PullRequestRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_AUTHOR);
        openapiFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiFields.add(SERIALIZED_NAME_MERGE_TIME);
        openapiFields.add(SERIALIZED_NAME_MERGE_COMMIT_KEY);
        openapiFields.add(SERIALIZED_NAME_BASE_COMMIT_KEY);
        openapiFields.add(SERIALIZED_NAME_HEAD_COMMIT_KEY);
        openapiFields.add(SERIALIZED_NAME_FILES_CHANGED);
        openapiFields.add(SERIALIZED_NAME_LINES_ADDED);
        openapiFields.add(SERIALIZED_NAME_LINES_DELETED);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_DEPLOYMENTS);
        openapiFields.add(SERIALIZED_NAME_FLAG_REFERENCES);
        openapiFields.add(SERIALIZED_NAME_LEAD_TIME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_EXTERNAL_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TITLE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_AUTHOR);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATE_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_BASE_COMMIT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_HEAD_COMMIT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_FILES_CHANGED);
        openapiRequiredFields.add(SERIALIZED_NAME_LINES_ADDED);
        openapiRequiredFields.add(SERIALIZED_NAME_LINES_DELETED);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PullRequestRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PullRequestRep.class));
            return new TypeAdapter<PullRequestRep>(){

                public void write(JsonWriter out, PullRequestRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PullRequestRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PullRequestRep.validateJsonObject(jsonObj);
                    PullRequestRep instance = (PullRequestRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

