/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ReferenceRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PutBranch {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_HEAD = "head";
    @SerializedName(value="head")
    private String head;
    public static final String SERIALIZED_NAME_UPDATE_SEQUENCE_ID = "updateSequenceId";
    @SerializedName(value="updateSequenceId")
    private Long updateSequenceId;
    public static final String SERIALIZED_NAME_SYNC_TIME = "syncTime";
    @SerializedName(value="syncTime")
    private Long syncTime;
    public static final String SERIALIZED_NAME_REFERENCES = "references";
    @SerializedName(value="references")
    private List<ReferenceRep> references = null;
    public static final String SERIALIZED_NAME_COMMIT_TIME = "commitTime";
    @SerializedName(value="commitTime")
    private Long commitTime;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PutBranch name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="main", required=true, value="The branch name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PutBranch head(String head) {
        this.head = head;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="a94a8fe5ccb19ba61c4c0873d391e987982fbbd3", required=true, value="An ID representing the branch HEAD. For example, a commit SHA.")
    public String getHead() {
        return this.head;
    }

    public void setHead(String head) {
        this.head = head;
    }

    public PutBranch updateSequenceId(Long updateSequenceId) {
        this.updateSequenceId = updateSequenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="25", value="An optional ID used to prevent older data from overwriting newer data. If no sequence ID is included, the newly submitted data will always be saved.")
    public Long getUpdateSequenceId() {
        return this.updateSequenceId;
    }

    public void setUpdateSequenceId(Long updateSequenceId) {
        this.updateSequenceId = updateSequenceId;
    }

    public PutBranch syncTime(Long syncTime) {
        this.syncTime = syncTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(Long syncTime) {
        this.syncTime = syncTime;
    }

    public PutBranch references(List<ReferenceRep> references) {
        this.references = references;
        return this;
    }

    public PutBranch addReferencesItem(ReferenceRep referencesItem) {
        if (this.references == null) {
            this.references = new ArrayList<ReferenceRep>();
        }
        this.references.add(referencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of flag references found on the branch")
    public List<ReferenceRep> getReferences() {
        return this.references;
    }

    public void setReferences(List<ReferenceRep> references) {
        this.references = references;
    }

    public PutBranch commitTime(Long commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getCommitTime() {
        return this.commitTime;
    }

    public void setCommitTime(Long commitTime) {
        this.commitTime = commitTime;
    }

    public PutBranch putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutBranch putBranch = (PutBranch)o;
        return Objects.equals(this.name, putBranch.name) && Objects.equals(this.head, putBranch.head) && Objects.equals(this.updateSequenceId, putBranch.updateSequenceId) && Objects.equals(this.syncTime, putBranch.syncTime) && Objects.equals(this.references, putBranch.references) && Objects.equals(this.commitTime, putBranch.commitTime) && Objects.equals(this.additionalProperties, putBranch.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.head, this.updateSequenceId, this.syncTime, this.references, this.commitTime, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PutBranch {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    head: ").append(this.toIndentedString(this.head)).append("\n");
        sb.append("    updateSequenceId: ").append(this.toIndentedString(this.updateSequenceId)).append("\n");
        sb.append("    syncTime: ").append(this.toIndentedString(this.syncTime)).append("\n");
        sb.append("    references: ").append(this.toIndentedString(this.references)).append("\n");
        sb.append("    commitTime: ").append(this.toIndentedString(this.commitTime)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PutBranch is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HEAD) != null && !jsonObj.get(SERIALIZED_NAME_HEAD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `head` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEAD).toString()));
        }
        JsonArray jsonArrayreferences = jsonObj.getAsJsonArray(SERIALIZED_NAME_REFERENCES);
        if (jsonArrayreferences != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REFERENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `references` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCES).toString()));
            }
            for (int i = 0; i < jsonArrayreferences.size(); ++i) {
                ReferenceRep.validateJsonObject(jsonArrayreferences.get(i).getAsJsonObject());
            }
        }
    }

    public static PutBranch fromJson(String jsonString) throws IOException {
        return (PutBranch)JSON.getGson().fromJson(jsonString, PutBranch.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_HEAD);
        openapiFields.add(SERIALIZED_NAME_UPDATE_SEQUENCE_ID);
        openapiFields.add(SERIALIZED_NAME_SYNC_TIME);
        openapiFields.add(SERIALIZED_NAME_REFERENCES);
        openapiFields.add(SERIALIZED_NAME_COMMIT_TIME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_HEAD);
        openapiRequiredFields.add(SERIALIZED_NAME_SYNC_TIME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PutBranch.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PutBranch.class));
            return new TypeAdapter<PutBranch>(){

                public void write(JsonWriter out, PutBranch value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PutBranch read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PutBranch.validateJsonObject(jsonObj);
                    PutBranch instance = (PutBranch)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

