/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class RelativeDifferenceRep {
    public static final String SERIALIZED_NAME_UPPER = "upper";
    @SerializedName(value="upper")
    private BigDecimal upper;
    public static final String SERIALIZED_NAME_LOWER = "lower";
    @SerializedName(value="lower")
    private BigDecimal lower;
    public static final String SERIALIZED_NAME_FROM_TREATMENT_ID = "fromTreatmentId";
    @SerializedName(value="fromTreatmentId")
    private String fromTreatmentId;
    public static final String SERIALIZED_NAME_VARIANCE = "variance";
    @SerializedName(value="variance")
    private BigDecimal variance;
    public static final String SERIALIZED_NAME_VARIANCE_REDUCTION = "varianceReduction";
    @SerializedName(value="varianceReduction")
    private BigDecimal varianceReduction;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RelativeDifferenceRep upper(BigDecimal upper) {
        this.upper = upper;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.42655970355712425", value="An upper bound of the relative difference between the treatment and the <code>fromTreatmentId</code>")
    public BigDecimal getUpper() {
        return this.upper;
    }

    public void setUpper(BigDecimal upper) {
        this.upper = upper;
    }

    public RelativeDifferenceRep lower(BigDecimal lower) {
        this.lower = lower;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-0.13708601934659803", value="A lower bound of the relative difference between the treatment and the <code>fromTreatmentId</code>")
    public BigDecimal getLower() {
        return this.lower;
    }

    public void setLower(BigDecimal lower) {
        this.lower = lower;
    }

    public RelativeDifferenceRep fromTreatmentId(String fromTreatmentId) {
        this.fromTreatmentId = fromTreatmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="92b8354e-360e-4d67-8f13-fa6a46ca8077", value="The treatment ID of the treatment against which the relative difference is calculated")
    public String getFromTreatmentId() {
        return this.fromTreatmentId;
    }

    public void setFromTreatmentId(String fromTreatmentId) {
        this.fromTreatmentId = fromTreatmentId;
    }

    public RelativeDifferenceRep variance(BigDecimal variance) {
        this.variance = variance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4.23", value="Variance of the relative difference")
    public BigDecimal getVariance() {
        return this.variance;
    }

    public void setVariance(BigDecimal variance) {
        this.variance = variance;
    }

    public RelativeDifferenceRep varianceReduction(BigDecimal varianceReduction) {
        this.varianceReduction = varianceReduction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The reduction in variance resulting from CUPED")
    public BigDecimal getVarianceReduction() {
        return this.varianceReduction;
    }

    public void setVarianceReduction(BigDecimal varianceReduction) {
        this.varianceReduction = varianceReduction;
    }

    public RelativeDifferenceRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelativeDifferenceRep relativeDifferenceRep = (RelativeDifferenceRep)o;
        return Objects.equals(this.upper, relativeDifferenceRep.upper) && Objects.equals(this.lower, relativeDifferenceRep.lower) && Objects.equals(this.fromTreatmentId, relativeDifferenceRep.fromTreatmentId) && Objects.equals(this.variance, relativeDifferenceRep.variance) && Objects.equals(this.varianceReduction, relativeDifferenceRep.varianceReduction) && Objects.equals(this.additionalProperties, relativeDifferenceRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.upper, this.lower, this.fromTreatmentId, this.variance, this.varianceReduction, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelativeDifferenceRep {\n");
        sb.append("    upper: ").append(this.toIndentedString(this.upper)).append("\n");
        sb.append("    lower: ").append(this.toIndentedString(this.lower)).append("\n");
        sb.append("    fromTreatmentId: ").append(this.toIndentedString(this.fromTreatmentId)).append("\n");
        sb.append("    variance: ").append(this.toIndentedString(this.variance)).append("\n");
        sb.append("    varianceReduction: ").append(this.toIndentedString(this.varianceReduction)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RelativeDifferenceRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_TREATMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_FROM_TREATMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fromTreatmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_TREATMENT_ID).toString()));
        }
    }

    public static RelativeDifferenceRep fromJson(String jsonString) throws IOException {
        return (RelativeDifferenceRep)JSON.getGson().fromJson(jsonString, RelativeDifferenceRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_UPPER);
        openapiFields.add(SERIALIZED_NAME_LOWER);
        openapiFields.add(SERIALIZED_NAME_FROM_TREATMENT_ID);
        openapiFields.add(SERIALIZED_NAME_VARIANCE);
        openapiFields.add(SERIALIZED_NAME_VARIANCE_REDUCTION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RelativeDifferenceRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RelativeDifferenceRep.class));
            return new TypeAdapter<RelativeDifferenceRep>(){

                public void write(JsonWriter out, RelativeDifferenceRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RelativeDifferenceRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RelativeDifferenceRep.validateJsonObject(jsonObj);
                    RelativeDifferenceRep instance = (RelativeDifferenceRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

