/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.PhaseInfo;
import com.launchdarkly.api.model.ReleaseProgression;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ReleaseProgressionCollection {
    public static final String SERIALIZED_NAME_ACTIVE_COUNT = "activeCount";
    @SerializedName(value="activeCount")
    private Integer activeCount;
    public static final String SERIALIZED_NAME_COMPLETED_COUNT = "completedCount";
    @SerializedName(value="completedCount")
    private Integer completedCount;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<ReleaseProgression> items = new ArrayList<ReleaseProgression>();
    public static final String SERIALIZED_NAME_PHASES = "phases";
    @SerializedName(value="phases")
    private List<PhaseInfo> phases = new ArrayList<PhaseInfo>();
    public static final String SERIALIZED_NAME_TOTAL_COUNT = "totalCount";
    @SerializedName(value="totalCount")
    private Integer totalCount;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ReleaseProgressionCollection activeCount(Integer activeCount) {
        this.activeCount = activeCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="3", required=true, value="The number of active releases")
    public Integer getActiveCount() {
        return this.activeCount;
    }

    public void setActiveCount(Integer activeCount) {
        this.activeCount = activeCount;
    }

    public ReleaseProgressionCollection completedCount(Integer completedCount) {
        this.completedCount = completedCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="The number of completed releases")
    public Integer getCompletedCount() {
        return this.completedCount;
    }

    public void setCompletedCount(Integer completedCount) {
        this.completedCount = completedCount;
    }

    public ReleaseProgressionCollection items(List<ReleaseProgression> items) {
        this.items = items;
        return this;
    }

    public ReleaseProgressionCollection addItemsItem(ReleaseProgression itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of details for each release, across all flags, for this release pipeline")
    public List<ReleaseProgression> getItems() {
        return this.items;
    }

    public void setItems(List<ReleaseProgression> items) {
        this.items = items;
    }

    public ReleaseProgressionCollection phases(List<PhaseInfo> phases) {
        this.phases = phases;
        return this;
    }

    public ReleaseProgressionCollection addPhasesItem(PhaseInfo phasesItem) {
        this.phases.add(phasesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of details for each phase, across all releases, for this release pipeline")
    public List<PhaseInfo> getPhases() {
        return this.phases;
    }

    public void setPhases(List<PhaseInfo> phases) {
        this.phases = phases;
    }

    public ReleaseProgressionCollection totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="8", required=true, value="The total number of releases for this release pipeline")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public ReleaseProgressionCollection links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ReleaseProgressionCollection putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ReleaseProgressionCollection putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseProgressionCollection releaseProgressionCollection = (ReleaseProgressionCollection)o;
        return Objects.equals(this.activeCount, releaseProgressionCollection.activeCount) && Objects.equals(this.completedCount, releaseProgressionCollection.completedCount) && Objects.equals(this.items, releaseProgressionCollection.items) && Objects.equals(this.phases, releaseProgressionCollection.phases) && Objects.equals(this.totalCount, releaseProgressionCollection.totalCount) && Objects.equals(this.links, releaseProgressionCollection.links) && Objects.equals(this.additionalProperties, releaseProgressionCollection.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.activeCount, this.completedCount, this.items, this.phases, this.totalCount, this.links, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReleaseProgressionCollection {\n");
        sb.append("    activeCount: ").append(this.toIndentedString(this.activeCount)).append("\n");
        sb.append("    completedCount: ").append(this.toIndentedString(this.completedCount)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    phases: ").append(this.toIndentedString(this.phases)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayphases;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReleaseProgressionCollection is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayitems = jsonObj.getAsJsonArray(SERIALIZED_NAME_ITEMS);
        if (jsonArrayitems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArrayitems.size(); ++i) {
                ReleaseProgression.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayphases = jsonObj.getAsJsonArray(SERIALIZED_NAME_PHASES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PHASES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `phases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASES).toString()));
            }
            for (int i = 0; i < jsonArrayphases.size(); ++i) {
                PhaseInfo.validateJsonObject(jsonArrayphases.get(i).getAsJsonObject());
            }
        }
    }

    public static ReleaseProgressionCollection fromJson(String jsonString) throws IOException {
        return (ReleaseProgressionCollection)JSON.getGson().fromJson(jsonString, ReleaseProgressionCollection.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE_COUNT);
        openapiFields.add(SERIALIZED_NAME_COMPLETED_COUNT);
        openapiFields.add(SERIALIZED_NAME_ITEMS);
        openapiFields.add(SERIALIZED_NAME_PHASES);
        openapiFields.add(SERIALIZED_NAME_TOTAL_COUNT);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_COMPLETED_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ITEMS);
        openapiRequiredFields.add(SERIALIZED_NAME_PHASES);
        openapiRequiredFields.add(SERIALIZED_NAME_TOTAL_COUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ReleaseProgressionCollection.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ReleaseProgressionCollection.class));
            return new TypeAdapter<ReleaseProgressionCollection>(){

                public void write(JsonWriter out, ReleaseProgressionCollection value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ReleaseProgressionCollection read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReleaseProgressionCollection.validateJsonObject(jsonObj);
                    ReleaseProgressionCollection instance = (ReleaseProgressionCollection)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

