/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SOURCE_LINK = "sourceLink";
    @SerializedName(value="sourceLink")
    private String sourceLink;
    public static final String SERIALIZED_NAME_COMMIT_URL_TEMPLATE = "commitUrlTemplate";
    @SerializedName(value="commitUrlTemplate")
    private String commitUrlTemplate;
    public static final String SERIALIZED_NAME_HUNK_URL_TEMPLATE = "hunkUrlTemplate";
    @SerializedName(value="hunkUrlTemplate")
    private String hunkUrlTemplate;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_DEFAULT_BRANCH = "defaultBranch";
    @SerializedName(value="defaultBranch")
    private String defaultBranch;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RepositoryPost name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="LaunchDarkly-Docs", required=true, value="The repository name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepositoryPost sourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs", value="A URL to access the repository")
    public String getSourceLink() {
        return this.sourceLink;
    }

    public void setSourceLink(String sourceLink) {
        this.sourceLink = sourceLink;
    }

    public RepositoryPost commitUrlTemplate(String commitUrlTemplate) {
        this.commitUrlTemplate = commitUrlTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs/commit/${sha}", value="A template for constructing a valid URL to view the commit")
    public String getCommitUrlTemplate() {
        return this.commitUrlTemplate;
    }

    public void setCommitUrlTemplate(String commitUrlTemplate) {
        this.commitUrlTemplate = commitUrlTemplate;
    }

    public RepositoryPost hunkUrlTemplate(String hunkUrlTemplate) {
        this.hunkUrlTemplate = hunkUrlTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://github.com/launchdarkly/LaunchDarkly-Docs/blob/${sha}/${filePath}#L${lineNumber}", value="A template for constructing a valid URL to view the hunk")
    public String getHunkUrlTemplate() {
        return this.hunkUrlTemplate;
    }

    public void setHunkUrlTemplate(String hunkUrlTemplate) {
        this.hunkUrlTemplate = hunkUrlTemplate;
    }

    public RepositoryPost type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="github", value="The type of repository. If not specified, the default value is <code>custom</code>.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RepositoryPost defaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="main", value="The repository's default branch. If not specified, the default value is <code>main</code>.")
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public RepositoryPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryPost repositoryPost = (RepositoryPost)o;
        return Objects.equals(this.name, repositoryPost.name) && Objects.equals(this.sourceLink, repositoryPost.sourceLink) && Objects.equals(this.commitUrlTemplate, repositoryPost.commitUrlTemplate) && Objects.equals(this.hunkUrlTemplate, repositoryPost.hunkUrlTemplate) && Objects.equals((Object)this.type, (Object)repositoryPost.type) && Objects.equals(this.defaultBranch, repositoryPost.defaultBranch) && Objects.equals(this.additionalProperties, repositoryPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceLink, this.commitUrlTemplate, this.hunkUrlTemplate, this.type, this.defaultBranch, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepositoryPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sourceLink: ").append(this.toIndentedString(this.sourceLink)).append("\n");
        sb.append("    commitUrlTemplate: ").append(this.toIndentedString(this.commitUrlTemplate)).append("\n");
        sb.append("    hunkUrlTemplate: ").append(this.toIndentedString(this.hunkUrlTemplate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    defaultBranch: ").append(this.toIndentedString(this.defaultBranch)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RepositoryPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE_LINK) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `sourceLink` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE_LINK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `commitUrlTemplate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMIT_URL_TEMPLATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE) != null && !jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hunkUrlTemplate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HUNK_URL_TEMPLATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `defaultBranch` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_BRANCH).toString()));
        }
    }

    public static RepositoryPost fromJson(String jsonString) throws IOException {
        return (RepositoryPost)JSON.getGson().fromJson(jsonString, RepositoryPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SOURCE_LINK);
        openapiFields.add(SERIALIZED_NAME_COMMIT_URL_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_HUNK_URL_TEMPLATE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_BRANCH);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RepositoryPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RepositoryPost.class));
            return new TypeAdapter<RepositoryPost>(){

                public void write(JsonWriter out, RepositoryPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RepositoryPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RepositoryPost.validateJsonObject(jsonObj);
                    RepositoryPost instance = (RepositoryPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BITBUCKET("bitbucket"),
        CUSTOM("custom"),
        GITHUB("github"),
        GITLAB("gitlab");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

