/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class RuleClause {
    public static final String SERIALIZED_NAME_ATTRIBUTE = "attribute";
    @SerializedName(value="attribute")
    private String attribute;
    public static final String SERIALIZED_NAME_OP = "op";
    @SerializedName(value="op")
    private OpEnum op;
    public static final String SERIALIZED_NAME_NEGATE = "negate";
    @SerializedName(value="negate")
    private Boolean negate;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RuleClause attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The attribute the rule applies to, for example, last name or email address")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public RuleClause op(OpEnum op) {
        this.op = op;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The operator to apply to the given attribute")
    public OpEnum getOp() {
        return this.op;
    }

    public void setOp(OpEnum op) {
        this.op = op;
    }

    public RuleClause negate(Boolean negate) {
        this.negate = negate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the operator should be negated")
    public Boolean getNegate() {
        return this.negate;
    }

    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    public RuleClause putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleClause ruleClause = (RuleClause)o;
        return Objects.equals(this.attribute, ruleClause.attribute) && Objects.equals((Object)this.op, (Object)ruleClause.op) && Objects.equals(this.negate, ruleClause.negate) && Objects.equals(this.additionalProperties, ruleClause.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attribute, this.op, this.negate, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuleClause {\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    op: ").append(this.toIndentedString((Object)this.op)).append("\n");
        sb.append("    negate: ").append(this.toIndentedString(this.negate)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RuleClause is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTE) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `attribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OP) != null && !jsonObj.get(SERIALIZED_NAME_OP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `op` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OP).toString()));
        }
    }

    public static RuleClause fromJson(String jsonString) throws IOException {
        return (RuleClause)JSON.getGson().fromJson(jsonString, RuleClause.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE);
        openapiFields.add(SERIALIZED_NAME_OP);
        openapiFields.add(SERIALIZED_NAME_NEGATE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!RuleClause.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RuleClause.class));
            return new TypeAdapter<RuleClause>(){

                public void write(JsonWriter out, RuleClause value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public RuleClause read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RuleClause.validateJsonObject(jsonObj);
                    RuleClause instance = (RuleClause)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OpEnum {
        IN("in"),
        ENDSWITH("endsWith"),
        STARTSWITH("startsWith"),
        MATCHES("matches"),
        CONTAINS("contains"),
        LESSTHAN("lessThan"),
        LESSTHANOREQUAL("lessThanOrEqual"),
        GREATERTHAN("greaterThan"),
        GREATERTHANOREQUAL("greaterThanOrEqual"),
        BEFORE("before"),
        AFTER("after"),
        SEGMENTMATCH("segmentMatch"),
        SEMVEREQUAL("semVerEqual"),
        SEMVERLESSTHAN("semVerLessThan"),
        SEMVERGREATERTHAN("semVerGreaterThan");

        private String value;

        private OpEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OpEnum fromValue(String value) {
            for (OpEnum b : OpEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OpEnum> {
            public void write(JsonWriter jsonWriter, OpEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OpEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OpEnum.fromValue(value);
            }
        }
    }
}

