/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.TreatmentResultRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SlicedResultsRep {
    public static final String SERIALIZED_NAME_ATTRIBUTE = "attribute";
    @SerializedName(value="attribute")
    private String attribute;
    public static final String SERIALIZED_NAME_ATTRIBUTE_VALUE = "attributeValue";
    @SerializedName(value="attributeValue")
    private String attributeValue;
    public static final String SERIALIZED_NAME_TREATMENT_RESULTS = "treatmentResults";
    @SerializedName(value="treatmentResults")
    private List<TreatmentResultRep> treatmentResults = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SlicedResultsRep attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="country", value="An attribute that results are sliced by")
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public SlicedResultsRep attributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Canada", value="Attribute Value for 'attribute'")
    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public SlicedResultsRep treatmentResults(List<TreatmentResultRep> treatmentResults) {
        this.treatmentResults = treatmentResults;
        return this;
    }

    public SlicedResultsRep addTreatmentResultsItem(TreatmentResultRep treatmentResultsItem) {
        if (this.treatmentResults == null) {
            this.treatmentResults = new ArrayList<TreatmentResultRep>();
        }
        this.treatmentResults.add(treatmentResultsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the results for each treatment")
    public List<TreatmentResultRep> getTreatmentResults() {
        return this.treatmentResults;
    }

    public void setTreatmentResults(List<TreatmentResultRep> treatmentResults) {
        this.treatmentResults = treatmentResults;
    }

    public SlicedResultsRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlicedResultsRep slicedResultsRep = (SlicedResultsRep)o;
        return Objects.equals(this.attribute, slicedResultsRep.attribute) && Objects.equals(this.attributeValue, slicedResultsRep.attributeValue) && Objects.equals(this.treatmentResults, slicedResultsRep.treatmentResults) && Objects.equals(this.additionalProperties, slicedResultsRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.attributeValue, this.treatmentResults, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SlicedResultsRep {\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    attributeValue: ").append(this.toIndentedString(this.attributeValue)).append("\n");
        sb.append("    treatmentResults: ").append(this.toIndentedString(this.treatmentResults)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SlicedResultsRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTE) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `attribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `attributeValue` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_VALUE).toString()));
        }
        JsonArray jsonArraytreatmentResults = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENT_RESULTS);
        if (jsonArraytreatmentResults != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TREATMENT_RESULTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `treatmentResults` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_RESULTS).toString()));
            }
            for (int i = 0; i < jsonArraytreatmentResults.size(); ++i) {
                TreatmentResultRep.validateJsonObject(jsonArraytreatmentResults.get(i).getAsJsonObject());
            }
        }
    }

    public static SlicedResultsRep fromJson(String jsonString) throws IOException {
        return (SlicedResultsRep)JSON.getGson().fromJson(jsonString, SlicedResultsRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE_VALUE);
        openapiFields.add(SERIALIZED_NAME_TREATMENT_RESULTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SlicedResultsRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SlicedResultsRep.class));
            return new TypeAdapter<SlicedResultsRep>(){

                public void write(JsonWriter out, SlicedResultsRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public SlicedResultsRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SlicedResultsRep.validateJsonObject(jsonObj);
                    SlicedResultsRep instance = (SlicedResultsRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

