/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.BayesianBetaBinomialStatsRep;
import com.launchdarkly.api.model.BayesianNormalStatsRep;
import com.launchdarkly.api.model.CredibleIntervalRep;
import com.launchdarkly.api.model.Distribution;
import com.launchdarkly.api.model.RelativeDifferenceRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TreatmentResultRep {
    public static final String SERIALIZED_NAME_TREATMENT_ID = "treatmentId";
    @SerializedName(value="treatmentId")
    private String treatmentId;
    public static final String SERIALIZED_NAME_TREATMENT_NAME = "treatmentName";
    @SerializedName(value="treatmentName")
    private String treatmentName;
    public static final String SERIALIZED_NAME_MEAN = "mean";
    @SerializedName(value="mean")
    private BigDecimal mean;
    public static final String SERIALIZED_NAME_DATA_MEAN = "dataMean";
    @SerializedName(value="dataMean")
    private BigDecimal dataMean;
    public static final String SERIALIZED_NAME_DATA_STD_DEV = "dataStdDev";
    @SerializedName(value="dataStdDev")
    private BigDecimal dataStdDev;
    public static final String SERIALIZED_NAME_CREDIBLE_INTERVAL = "credibleInterval";
    @SerializedName(value="credibleInterval")
    private CredibleIntervalRep credibleInterval;
    public static final String SERIALIZED_NAME_P_BEST = "pBest";
    @SerializedName(value="pBest")
    private BigDecimal pBest;
    public static final String SERIALIZED_NAME_RELATIVE_DIFFERENCES = "relativeDifferences";
    @SerializedName(value="relativeDifferences")
    private List<RelativeDifferenceRep> relativeDifferences = null;
    public static final String SERIALIZED_NAME_UNITS = "units";
    @SerializedName(value="units")
    private Long units;
    public static final String SERIALIZED_NAME_TRAFFIC = "traffic";
    @SerializedName(value="traffic")
    private Long traffic;
    public static final String SERIALIZED_NAME_EVENT_VALUES_SUM = "eventValuesSum";
    @SerializedName(value="eventValuesSum")
    private BigDecimal eventValuesSum;
    public static final String SERIALIZED_NAME_DISTRIBUTION = "distribution";
    @SerializedName(value="distribution")
    private Distribution distribution;
    public static final String SERIALIZED_NAME_CORRELATION = "correlation";
    @SerializedName(value="correlation")
    private BigDecimal correlation;
    public static final String SERIALIZED_NAME_STANDARD_DEVIATION_RATIO = "standardDeviationRatio";
    @SerializedName(value="standardDeviationRatio")
    private BigDecimal standardDeviationRatio;
    public static final String SERIALIZED_NAME_COVARIATE_IMBALANCE = "covariateImbalance";
    @SerializedName(value="covariateImbalance")
    private BigDecimal covariateImbalance;
    public static final String SERIALIZED_NAME_VARIANCE_REDUCTION = "varianceReduction";
    @SerializedName(value="varianceReduction")
    private BigDecimal varianceReduction;
    public static final String SERIALIZED_NAME_MODEL = "model";
    @SerializedName(value="model")
    private ModelEnum model;
    public static final String SERIALIZED_NAME_BAYESIAN_NORMAL = "bayesianNormal";
    @SerializedName(value="bayesianNormal")
    private BayesianNormalStatsRep bayesianNormal;
    public static final String SERIALIZED_NAME_BAYESIAN_BETA = "bayesianBeta";
    @SerializedName(value="bayesianBeta")
    private BayesianBetaBinomialStatsRep bayesianBeta;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TreatmentResultRep treatmentId(String treatmentId) {
        this.treatmentId = treatmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="92b8354e-360e-4d67-8f13-fa6a46ca8077", value="The ID of the treatment")
    public String getTreatmentId() {
        return this.treatmentId;
    }

    public void setTreatmentId(String treatmentId) {
        this.treatmentId = treatmentId;
    }

    public TreatmentResultRep treatmentName(String treatmentName) {
        this.treatmentName = treatmentName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="variation 25% off", value="The name of the treatment")
    public String getTreatmentName() {
        return this.treatmentName;
    }

    public void setTreatmentName(String treatmentName) {
        this.treatmentName = treatmentName;
    }

    public TreatmentResultRep mean(BigDecimal mean) {
        this.mean = mean;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.5432525951557093", value="The average value of the variation in this sample. It doesn\u2019t capture the uncertainty in the measurement, so it should not be the only measurement you use to make decisions.")
    public BigDecimal getMean() {
        return this.mean;
    }

    public void setMean(BigDecimal mean) {
        this.mean = mean;
    }

    public TreatmentResultRep dataMean(BigDecimal dataMean) {
        this.dataMean = dataMean;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2.464845", value="The mean of the data, with no priors effecting the result.")
    public BigDecimal getDataMean() {
        return this.dataMean;
    }

    public void setDataMean(BigDecimal dataMean) {
        this.dataMean = dataMean;
    }

    public TreatmentResultRep dataStdDev(BigDecimal dataStdDev) {
        this.dataStdDev = dataStdDev;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1.0E-7", value="The standard deviation of the data, with no priors effecting the result.")
    public BigDecimal getDataStdDev() {
        return this.dataStdDev;
    }

    public void setDataStdDev(BigDecimal dataStdDev) {
        this.dataStdDev = dataStdDev;
    }

    public TreatmentResultRep credibleInterval(CredibleIntervalRep credibleInterval) {
        this.credibleInterval = credibleInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CredibleIntervalRep getCredibleInterval() {
        return this.credibleInterval;
    }

    public void setCredibleInterval(CredibleIntervalRep credibleInterval) {
        this.credibleInterval = credibleInterval;
    }

    public TreatmentResultRep pBest(BigDecimal pBest) {
        this.pBest = pBest;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.6083", value="The likelihood that this variation has the biggest effect on the primary metric. The variation with the highest probability is likely the best of the variations you're testing")
    public BigDecimal getpBest() {
        return this.pBest;
    }

    public void setpBest(BigDecimal pBest) {
        this.pBest = pBest;
    }

    public TreatmentResultRep relativeDifferences(List<RelativeDifferenceRep> relativeDifferences) {
        this.relativeDifferences = relativeDifferences;
        return this;
    }

    public TreatmentResultRep addRelativeDifferencesItem(RelativeDifferenceRep relativeDifferencesItem) {
        if (this.relativeDifferences == null) {
            this.relativeDifferences = new ArrayList<RelativeDifferenceRep>();
        }
        this.relativeDifferences.add(relativeDifferencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"fromTreatmentId\":\"92b8354e-360e-4d67-8f13-fa6a46ca8077\",\"lower\":-0.13708601934659803,\"upper\":0.42655970355712425}]", value="Estimates of the relative difference between this treatment's mean and the mean of each other treatment")
    public List<RelativeDifferenceRep> getRelativeDifferences() {
        return this.relativeDifferences;
    }

    public void setRelativeDifferences(List<RelativeDifferenceRep> relativeDifferences) {
        this.relativeDifferences = relativeDifferences;
    }

    public TreatmentResultRep units(Long units) {
        this.units = units;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="76", value="The number of units exposed to this treatment that have event values, including those that are configured to default to 0")
    public Long getUnits() {
        return this.units;
    }

    public void setUnits(Long units) {
        this.units = units;
    }

    public TreatmentResultRep traffic(Long traffic) {
        this.traffic = traffic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="332", value="The number of units exposed to this treatment.")
    public Long getTraffic() {
        return this.traffic;
    }

    public void setTraffic(Long traffic) {
        this.traffic = traffic;
    }

    public TreatmentResultRep eventValuesSum(BigDecimal eventValuesSum) {
        this.eventValuesSum = eventValuesSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6234", value="The sum of the event values for the units exposed to this treatment.")
    public BigDecimal getEventValuesSum() {
        return this.eventValuesSum;
    }

    public void setEventValuesSum(BigDecimal eventValuesSum) {
        this.eventValuesSum = eventValuesSum;
    }

    public TreatmentResultRep distribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public TreatmentResultRep correlation(BigDecimal correlation) {
        this.correlation = correlation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The outcome-covariate correlation")
    public BigDecimal getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(BigDecimal correlation) {
        this.correlation = correlation;
    }

    public TreatmentResultRep standardDeviationRatio(BigDecimal standardDeviationRatio) {
        this.standardDeviationRatio = standardDeviationRatio;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ratio of the outcome SD to covariate SD")
    public BigDecimal getStandardDeviationRatio() {
        return this.standardDeviationRatio;
    }

    public void setStandardDeviationRatio(BigDecimal standardDeviationRatio) {
        this.standardDeviationRatio = standardDeviationRatio;
    }

    public TreatmentResultRep covariateImbalance(BigDecimal covariateImbalance) {
        this.covariateImbalance = covariateImbalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The imbalance between the covariate mean for the arm and the covariate mean for the experiment")
    public BigDecimal getCovariateImbalance() {
        return this.covariateImbalance;
    }

    public void setCovariateImbalance(BigDecimal covariateImbalance) {
        this.covariateImbalance = covariateImbalance;
    }

    public TreatmentResultRep varianceReduction(BigDecimal varianceReduction) {
        this.varianceReduction = varianceReduction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The reduction in variance resulting from CUPED")
    public BigDecimal getVarianceReduction() {
        return this.varianceReduction;
    }

    public void setVarianceReduction(BigDecimal varianceReduction) {
        this.varianceReduction = varianceReduction;
    }

    public TreatmentResultRep model(ModelEnum model) {
        this.model = model;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bayesianNormal", value="The model used to calculate the results. Parameters specific to this model will be defined under the field under the same name")
    public ModelEnum getModel() {
        return this.model;
    }

    public void setModel(ModelEnum model) {
        this.model = model;
    }

    public TreatmentResultRep bayesianNormal(BayesianNormalStatsRep bayesianNormal) {
        this.bayesianNormal = bayesianNormal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BayesianNormalStatsRep getBayesianNormal() {
        return this.bayesianNormal;
    }

    public void setBayesianNormal(BayesianNormalStatsRep bayesianNormal) {
        this.bayesianNormal = bayesianNormal;
    }

    public TreatmentResultRep bayesianBeta(BayesianBetaBinomialStatsRep bayesianBeta) {
        this.bayesianBeta = bayesianBeta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BayesianBetaBinomialStatsRep getBayesianBeta() {
        return this.bayesianBeta;
    }

    public void setBayesianBeta(BayesianBetaBinomialStatsRep bayesianBeta) {
        this.bayesianBeta = bayesianBeta;
    }

    public TreatmentResultRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreatmentResultRep treatmentResultRep = (TreatmentResultRep)o;
        return Objects.equals(this.treatmentId, treatmentResultRep.treatmentId) && Objects.equals(this.treatmentName, treatmentResultRep.treatmentName) && Objects.equals(this.mean, treatmentResultRep.mean) && Objects.equals(this.dataMean, treatmentResultRep.dataMean) && Objects.equals(this.dataStdDev, treatmentResultRep.dataStdDev) && Objects.equals(this.credibleInterval, treatmentResultRep.credibleInterval) && Objects.equals(this.pBest, treatmentResultRep.pBest) && Objects.equals(this.relativeDifferences, treatmentResultRep.relativeDifferences) && Objects.equals(this.units, treatmentResultRep.units) && Objects.equals(this.traffic, treatmentResultRep.traffic) && Objects.equals(this.eventValuesSum, treatmentResultRep.eventValuesSum) && Objects.equals(this.distribution, treatmentResultRep.distribution) && Objects.equals(this.correlation, treatmentResultRep.correlation) && Objects.equals(this.standardDeviationRatio, treatmentResultRep.standardDeviationRatio) && Objects.equals(this.covariateImbalance, treatmentResultRep.covariateImbalance) && Objects.equals(this.varianceReduction, treatmentResultRep.varianceReduction) && Objects.equals((Object)this.model, (Object)treatmentResultRep.model) && Objects.equals(this.bayesianNormal, treatmentResultRep.bayesianNormal) && Objects.equals(this.bayesianBeta, treatmentResultRep.bayesianBeta) && Objects.equals(this.additionalProperties, treatmentResultRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.treatmentId, this.treatmentName, this.mean, this.dataMean, this.dataStdDev, this.credibleInterval, this.pBest, this.relativeDifferences, this.units, this.traffic, this.eventValuesSum, this.distribution, this.correlation, this.standardDeviationRatio, this.covariateImbalance, this.varianceReduction, this.model, this.bayesianNormal, this.bayesianBeta, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreatmentResultRep {\n");
        sb.append("    treatmentId: ").append(this.toIndentedString(this.treatmentId)).append("\n");
        sb.append("    treatmentName: ").append(this.toIndentedString(this.treatmentName)).append("\n");
        sb.append("    mean: ").append(this.toIndentedString(this.mean)).append("\n");
        sb.append("    dataMean: ").append(this.toIndentedString(this.dataMean)).append("\n");
        sb.append("    dataStdDev: ").append(this.toIndentedString(this.dataStdDev)).append("\n");
        sb.append("    credibleInterval: ").append(this.toIndentedString(this.credibleInterval)).append("\n");
        sb.append("    pBest: ").append(this.toIndentedString(this.pBest)).append("\n");
        sb.append("    relativeDifferences: ").append(this.toIndentedString(this.relativeDifferences)).append("\n");
        sb.append("    units: ").append(this.toIndentedString(this.units)).append("\n");
        sb.append("    traffic: ").append(this.toIndentedString(this.traffic)).append("\n");
        sb.append("    eventValuesSum: ").append(this.toIndentedString(this.eventValuesSum)).append("\n");
        sb.append("    distribution: ").append(this.toIndentedString(this.distribution)).append("\n");
        sb.append("    correlation: ").append(this.toIndentedString(this.correlation)).append("\n");
        sb.append("    standardDeviationRatio: ").append(this.toIndentedString(this.standardDeviationRatio)).append("\n");
        sb.append("    covariateImbalance: ").append(this.toIndentedString(this.covariateImbalance)).append("\n");
        sb.append("    varianceReduction: ").append(this.toIndentedString(this.varianceReduction)).append("\n");
        sb.append("    model: ").append(this.toIndentedString((Object)this.model)).append("\n");
        sb.append("    bayesianNormal: ").append(this.toIndentedString(this.bayesianNormal)).append("\n");
        sb.append("    bayesianBeta: ").append(this.toIndentedString(this.bayesianBeta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayrelativeDifferences;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TreatmentResultRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TREATMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TREATMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `treatmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `treatmentName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENT_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDIBLE_INTERVAL) != null) {
            CredibleIntervalRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CREDIBLE_INTERVAL));
        }
        if ((jsonArrayrelativeDifferences = jsonObj.getAsJsonArray(SERIALIZED_NAME_RELATIVE_DIFFERENCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RELATIVE_DIFFERENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `relativeDifferences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RELATIVE_DIFFERENCES).toString()));
            }
            for (int i = 0; i < jsonArrayrelativeDifferences.size(); ++i) {
                RelativeDifferenceRep.validateJsonObject(jsonArrayrelativeDifferences.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DISTRIBUTION) != null) {
            Distribution.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DISTRIBUTION));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODEL) != null && !jsonObj.get(SERIALIZED_NAME_MODEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `model` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODEL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BAYESIAN_NORMAL) != null) {
            BayesianNormalStatsRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BAYESIAN_NORMAL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BAYESIAN_BETA) != null) {
            BayesianBetaBinomialStatsRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BAYESIAN_BETA));
        }
    }

    public static TreatmentResultRep fromJson(String jsonString) throws IOException {
        return (TreatmentResultRep)JSON.getGson().fromJson(jsonString, TreatmentResultRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TREATMENT_ID);
        openapiFields.add(SERIALIZED_NAME_TREATMENT_NAME);
        openapiFields.add(SERIALIZED_NAME_MEAN);
        openapiFields.add(SERIALIZED_NAME_DATA_MEAN);
        openapiFields.add(SERIALIZED_NAME_DATA_STD_DEV);
        openapiFields.add(SERIALIZED_NAME_CREDIBLE_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_P_BEST);
        openapiFields.add(SERIALIZED_NAME_RELATIVE_DIFFERENCES);
        openapiFields.add(SERIALIZED_NAME_UNITS);
        openapiFields.add(SERIALIZED_NAME_TRAFFIC);
        openapiFields.add(SERIALIZED_NAME_EVENT_VALUES_SUM);
        openapiFields.add(SERIALIZED_NAME_DISTRIBUTION);
        openapiFields.add(SERIALIZED_NAME_CORRELATION);
        openapiFields.add(SERIALIZED_NAME_STANDARD_DEVIATION_RATIO);
        openapiFields.add(SERIALIZED_NAME_COVARIATE_IMBALANCE);
        openapiFields.add(SERIALIZED_NAME_VARIANCE_REDUCTION);
        openapiFields.add(SERIALIZED_NAME_MODEL);
        openapiFields.add(SERIALIZED_NAME_BAYESIAN_NORMAL);
        openapiFields.add(SERIALIZED_NAME_BAYESIAN_BETA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TreatmentResultRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TreatmentResultRep.class));
            return new TypeAdapter<TreatmentResultRep>(){

                public void write(JsonWriter out, TreatmentResultRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TreatmentResultRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TreatmentResultRep.validateJsonObject(jsonObj);
                    TreatmentResultRep instance = (TreatmentResultRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ModelEnum {
        BAYESIANNORMAL("bayesianNormal"),
        BAYESIANBETA("bayesianBeta");

        private String value;

        private ModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ModelEnum fromValue(String value) {
            for (ModelEnum b : ModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ModelEnum> {
            public void write(JsonWriter jsonWriter, ModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ModelEnum.fromValue(value);
            }
        }
    }
}

